/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.config.AuthenticationApiModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.SwiftApiMetadata;
import org.jclouds.openstack.swift.SwiftKeystoneClient;
import org.jclouds.openstack.swift.blobstore.config.SwiftBlobStoreContextModule;
import org.jclouds.openstack.swift.blobstore.config.TemporaryUrlExtensionModule;
import org.jclouds.openstack.swift.config.SwiftHttpApiModule;
import org.jclouds.openstack.swift.config.SwiftKeystoneHttpApiModule;

@AutoService(value=ApiMetadata.class)
public class SwiftKeystoneApiMetadata
extends SwiftApiMetadata {
    public Builder<?, ?> toBuilder() {
        return (Builder)new ConcreteBuilder().fromApiMetadata((ApiMetadata)this);
    }

    public SwiftKeystoneApiMetadata() {
        this(new ConcreteBuilder());
    }

    protected SwiftKeystoneApiMetadata(Builder<?, ?> builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = SwiftApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.service-type", "object-store");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        properties.setProperty("jclouds.region", "");
        properties.remove("jclouds.regions");
        return properties;
    }

    private static class ConcreteBuilder
    extends Builder<SwiftKeystoneClient, ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<A extends CommonSwiftClient, T extends Builder<A, T>>
    extends SwiftApiMetadata.Builder<A, T> {
        protected Builder() {
            this((Class)Class.class.cast(SwiftKeystoneClient.class));
        }

        protected Builder(Class<A> syncClient) {
            super(syncClient);
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("swift-keystone")).name("OpenStack Swift with Keystone authentication")).identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant")).credentialName("${password}")).endpointName("KeyStone base url ending in /v2.0/")).defaultEndpoint("http://localhost:5000/v2.0/")).defaultProperties(SwiftKeystoneApiMetadata.defaultProperties())).defaultModules((Set)ImmutableSet.builder().add(AuthenticationApiModule.class).add(SwiftHttpApiModule.KeystoneStorageEndpointModule.class).add(KeystoneAuthenticationModule.RegionModule.class).add(SwiftKeystoneHttpApiModule.class).add(SwiftBlobStoreContextModule.class).add(TemporaryUrlExtensionModule.SwiftKeystoneTemporaryUrlExtensionModule.class).build());
        }

        @Override
        public SwiftKeystoneApiMetadata build() {
            return new SwiftKeystoneApiMetadata(this);
        }
    }
}

