/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.config;

import com.google.common.base.Supplier;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.config.AzureOAuthConfigFactory;
import org.jclouds.azurecompute.arm.config.GraphRBAC;
import org.jclouds.azurecompute.arm.config.Tenant;
import org.jclouds.azurecompute.arm.domain.ServicePrincipal;
import org.jclouds.azurecompute.arm.handlers.AzureComputeErrorHandler;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.implicit.FirstRegion;
import org.jclouds.oauth.v2.config.OAuthConfigFactory;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;

@ConfiguresHttpApi
public class AzureComputeHttpApiModule
extends HttpApiModule<AzureComputeApi> {
    private static final Pattern OAUTH_TENANT_PATTERN = Pattern.compile("https://login.microsoft(?:online)?.com/([^/]+)/oauth2/token");

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(AzureComputeErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(AzureComputeErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(AzureComputeErrorHandler.class);
    }

    protected void installLocations() {
        super.installLocations();
        this.bind(ImplicitLocationSupplier.class).to(FirstRegion.class).in(Scopes.SINGLETON);
    }

    protected void configure() {
        super.configure();
        this.bind(OAuthScopes.class).toInstance((Object)OAuthScopes.NoScopes.create());
        this.bind(OAuthConfigFactory.class).to(AzureOAuthConfigFactory.class).in(Scopes.SINGLETON);
        this.bindServiceEndpoints();
    }

    protected void bindServiceEndpoints() {
        this.bind((TypeLiteral)new TypeLiteral<Supplier<URI>>(){}).annotatedWith(GraphRBAC.class).to(GraphRBAC.GraphRBACForTenant.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @Tenant
    protected final String provideTenant(@Named(value="oauth.endpoint") String oauthEndpoint) {
        Matcher m = OAUTH_TENANT_PATTERN.matcher(oauthEndpoint);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not parse tenantId from: " + oauthEndpoint);
        }
        return m.group(1);
    }

    @Provides
    @Singleton
    protected final Supplier<ServicePrincipal> provideServicePrincipal(final AzureComputeApi api, AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, (Supplier)new Supplier<ServicePrincipal>(){

            public ServicePrincipal get() {
                return api.getGraphRBACApi().getCurrentServicePrincipal();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }
}

