/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.config;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.jclouds.azurecompute.arm.config.OAuthResource;
import org.jclouds.http.HttpRequest;
import org.jclouds.oauth.v2.config.OAuthConfigFactory;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class AzureOAuthConfigFactory
implements OAuthConfigFactory {
    private final OAuthScopes scopes;
    @Named(value="jclouds.oauth.audience")
    @Inject(optional=true)
    private String audience;
    @Named(value="jclouds.oauth.resource")
    @Inject(optional=true)
    private String resource;

    @Inject
    AzureOAuthConfigFactory(OAuthScopes scopes) {
        this.scopes = scopes;
    }

    public OAuthConfigFactory.OAuthConfig forRequest(HttpRequest input) {
        GeneratedHttpRequest request;
        OAuthResource customResource = null;
        if (input instanceof GeneratedHttpRequest && (customResource = (OAuthResource)(request = (GeneratedHttpRequest)input).getInvocation().getInvokable().getAnnotation(OAuthResource.class)) == null) {
            customResource = request.getInvocation().getInvokable().getDeclaringClass().getAnnotation(OAuthResource.class);
        }
        String oauthResource = customResource != null ? customResource.value() : this.resource;
        return OAuthConfigFactory.OAuthConfig.create((List)this.scopes.forRequest(input), (String)this.audience, (String)oauthResource);
    }
}

