/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import java.util.Map;
import org.jclouds.azurecompute.arm.domain.PublicIPAddress;
import org.jclouds.azurecompute.arm.domain.PublicIPAddressProperties;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_PublicIPAddress
extends PublicIPAddress {
    private final String name;
    private final String id;
    private final String etag;
    private final String location;
    private final Map<String, String> tags;
    private final PublicIPAddressProperties properties;

    private AutoValue_PublicIPAddress(String name, String id, String etag, String location, @Nullable Map<String, String> tags, PublicIPAddressProperties properties) {
        this.name = name;
        this.id = id;
        this.etag = etag;
        this.location = location;
        this.tags = tags;
        this.properties = properties;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    @Nullable
    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public PublicIPAddressProperties properties() {
        return this.properties;
    }

    public String toString() {
        return "PublicIPAddress{name=" + this.name + ", " + "id=" + this.id + ", " + "etag=" + this.etag + ", " + "location=" + this.location + ", " + "tags=" + this.tags + ", " + "properties=" + this.properties + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PublicIPAddress) {
            PublicIPAddress that = (PublicIPAddress)o;
            return this.name.equals(that.name()) && this.id.equals(that.id()) && this.etag.equals(that.etag()) && this.location.equals(that.location()) && (this.tags == null ? that.tags() == null : this.tags.equals(that.tags())) && this.properties.equals(that.properties());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.id.hashCode();
        h *= 1000003;
        h ^= this.etag.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.tags == null ? 0 : this.tags.hashCode();
        h *= 1000003;
        return h ^= this.properties.hashCode();
    }

    @Override
    public PublicIPAddress.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends PublicIPAddress.Builder {
        private String name;
        private String id;
        private String etag;
        private String location;
        private Map<String, String> tags;
        private PublicIPAddressProperties properties;

        Builder() {
        }

        private Builder(PublicIPAddress source) {
            this.name = source.name();
            this.id = source.id();
            this.etag = source.etag();
            this.location = source.location();
            this.tags = source.tags();
            this.properties = source.properties();
        }

        @Override
        public PublicIPAddress.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public PublicIPAddress.Builder id(String id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public PublicIPAddress.Builder etag(String etag) {
            if (etag == null) {
                throw new NullPointerException("Null etag");
            }
            this.etag = etag;
            return this;
        }

        @Override
        public PublicIPAddress.Builder location(String location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public PublicIPAddress.Builder tags(@Nullable Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Override
        @Nullable
        Map<String, String> tags() {
            return this.tags;
        }

        @Override
        public PublicIPAddress.Builder properties(PublicIPAddressProperties properties) {
            if (properties == null) {
                throw new NullPointerException("Null properties");
            }
            this.properties = properties;
            return this;
        }

        @Override
        PublicIPAddress autoBuild() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.id == null) {
                missing = missing + " id";
            }
            if (this.etag == null) {
                missing = missing + " etag";
            }
            if (this.location == null) {
                missing = missing + " location";
            }
            if (this.properties == null) {
                missing = missing + " properties";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PublicIPAddress(this.name, this.id, this.etag, this.location, this.tags, this.properties);
        }
    }
}

