/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.domain;

import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jclouds.digitalocean2.domain.AutoValue_Droplet;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.digitalocean2.domain.Kernel;
import org.jclouds.digitalocean2.domain.Networks;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.digitalocean2.domain.Size;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Droplet {
    public abstract int id();

    public abstract String name();

    public abstract int memory();

    public abstract int vcpus();

    public abstract int disk();

    public abstract boolean locked();

    public abstract Date createdAt();

    public abstract Status status();

    public abstract List<Integer> backupsIds();

    public abstract List<Integer> snapshotIds();

    public abstract List<String> features();

    @Nullable
    public abstract Region region();

    @Nullable
    public abstract Image image();

    @Nullable
    public abstract Size size();

    public abstract String sizeSlug();

    @Nullable
    public abstract Networks networks();

    @Nullable
    public abstract Kernel kernel();

    @SerializedNames(value={"id", "name", "memory", "vcpus", "disk", "locked", "created_at", "status", "backup_ids", "snapshot_ids", "features", "region", "image", "size", "size_slug", "networks", "kernel"})
    public static Droplet create(int id, String name, int memory, int vcpus, int disk, boolean locked, Date createdAt, Status status, List<Integer> backupIds, List<Integer> snapshotIds, List<String> features, Region region, Image image, Size size, String sizeSlug, Networks network, Kernel kernel) {
        return new AutoValue_Droplet(id, name, memory, vcpus, disk, locked, createdAt, status, (List<Integer>)(backupIds == null ? ImmutableList.of() : ImmutableList.copyOf(backupIds)), (List<Integer>)(snapshotIds == null ? ImmutableList.of() : ImmutableList.copyOf(snapshotIds)), (List<String>)ImmutableList.copyOf(features), region, image, size, sizeSlug, network, kernel);
    }

    public Set<Networks.Address> getPublicAddresses() {
        return FluentIterable.from((Iterable)Iterables.concat(this.networks().ipv4(), this.networks().ipv6())).filter(Networks.Predicates.publicNetworks()).toSet();
    }

    public Set<Networks.Address> getPrivateAddresses() {
        return FluentIterable.from((Iterable)Iterables.concat(this.networks().ipv4(), this.networks().ipv6())).filter(Networks.Predicates.privateNetworks()).toSet();
    }

    Droplet() {
    }

    public static enum Status {
        NEW,
        ACTIVE,
        ARCHIVE,
        OFF;


        public static Status fromValue(String value) {
            Optional status = Enums.getIfPresent(Status.class, (String)value.toUpperCase());
            Preconditions.checkArgument((boolean)status.isPresent(), (String)"Expected one of %s but was %s", (Object[])new Object[]{Joiner.on((char)',').join((Object[])Status.values()), value});
            return (Status)((Object)status.get());
        }
    }
}

