/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class TrafficControllerPoolRecord {
    private final String type;
    private final String rdata;

    public static TrafficControllerPoolRecord createA(String rdata) {
        return new TrafficControllerPoolRecord("A", rdata);
    }

    public static TrafficControllerPoolRecord createCNAME(String rdata) {
        return new TrafficControllerPoolRecord("CNAME", rdata);
    }

    public static TrafficControllerPoolRecord create(String type, String rdata) {
        return new TrafficControllerPoolRecord(type, rdata);
    }

    private TrafficControllerPoolRecord(String type, String rdata) {
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.rdata = (String)Preconditions.checkNotNull((Object)rdata, (Object)"rdata");
    }

    public String getType() {
        return this.type;
    }

    public String getRData() {
        return this.rdata;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.rdata});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrafficControllerPoolRecord that = (TrafficControllerPoolRecord)TrafficControllerPoolRecord.class.cast(obj);
        return Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.rdata, (Object)that.rdata);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("rdata", (Object)this.rdata).toString();
    }
}

