/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.writers.WriterNode;
import org.apache.jena.sparql.util.Iso;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class QuadPattern
implements Iterable<Quad> {
    private List<Quad> quads = new ArrayList<Quad>();

    public QuadPattern() {
    }

    public QuadPattern(QuadPattern other) {
        this.quads.addAll(other.quads);
    }

    public void add(Quad q) {
        this.quads.add(q);
    }

    public void addAll(QuadPattern other) {
        this.quads.addAll(other.quads);
    }

    public void add(int i, Quad q) {
        this.quads.add(i, q);
    }

    public Quad get(int i) {
        return this.quads.get(i);
    }

    @Override
    public ListIterator<Quad> iterator() {
        return this.quads.listIterator();
    }

    public int size() {
        return this.quads.size();
    }

    public boolean isEmpty() {
        return this.quads.isEmpty();
    }

    public List<Quad> getList() {
        return this.quads;
    }

    public int hashCode() {
        return this.quads.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QuadPattern)) {
            return false;
        }
        QuadPattern bp = (QuadPattern)other;
        return this.quads.equals(bp.quads);
    }

    public boolean equiv(QuadPattern other, NodeIsomorphismMap isoMap) {
        if (this.quads.size() != other.quads.size()) {
            return false;
        }
        for (int i = 0; i < this.quads.size(); ++i) {
            Quad q2;
            Quad q1 = this.get(i);
            if (Iso.quadIso(q1, q2 = other.get(i), isoMap)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        IndentedLineBuffer out = new IndentedLineBuffer();
        SerializationContext sCxt = SSE.sCxt(SSE.defaultPrefixMapWrite);
        boolean first = true;
        for (Quad quad : this.quads) {
            if (!first) {
                out.print(" ");
            } else {
                first = false;
            }
            out.print("(");
            WriterNode.outputPlain((IndentedWriter)out, quad, sCxt);
            out.print(")");
        }
        out.flush();
        return out.toString();
    }
}

