/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorDelayedInitialization;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.ext.com.google.common.collect.HashMultimap;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;

public class QueryIterGroup
extends QueryIterPlainWrapper {
    private final QueryIterator embeddedIterator;
    private static Pair<Var, Accumulator> placeholder = Pair.create((Object)((Object)((Var)null)), (Object)null);

    public QueryIterGroup(QueryIterator qIter, VarExprList groupVars, List<ExprAggregator> aggregators, ExecutionContext execCxt) {
        super(null, execCxt);
        this.embeddedIterator = qIter;
        Iterator<Binding> iter = QueryIterGroup.calc(qIter, groupVars, aggregators, execCxt);
        this.setIterator(iter);
    }

    @Override
    public void requestCancel() {
        this.embeddedIterator.cancel();
        super.requestCancel();
    }

    private static Iterator<Binding> calc(final QueryIterator iter, final VarExprList groupVarExpr, final List<ExprAggregator> aggregators, final ExecutionContext execCxt) {
        return new IteratorDelayedInitialization<Binding>(){

            protected Iterator<Binding> initializeIterator() {
                boolean noAggregators = aggregators == null || aggregators.isEmpty();
                HashMultimap accumulators = HashMultimap.create();
                while (iter.hasNext()) {
                    Binding b = iter.nextBinding();
                    Binding key = QueryIterGroup.genKey(groupVarExpr, b, execCxt);
                    if (noAggregators) {
                        accumulators.put((Object)key, (Object)placeholder);
                        continue;
                    }
                    if (!accumulators.containsKey((Object)key)) {
                        for (ExprAggregator agg : aggregators) {
                            Accumulator x = agg.getAggregator().createAccumulator();
                            Var v = agg.getVar();
                            accumulators.put((Object)key, (Object)Pair.create((Object)((Object)v), (Object)x));
                        }
                    }
                    for (Pair pair : accumulators.get((Object)key)) {
                        ((Accumulator)pair.getRight()).accumulate(b, execCxt);
                    }
                }
                if (accumulators.isEmpty()) {
                    if (noAggregators) {
                        return Iter.nullIterator();
                    }
                    BindingMap binding = BindingFactory.create();
                    for (ExprAggregator agg : aggregators) {
                        Var v = agg.getVar();
                        Node value = agg.getAggregator().getValueEmpty();
                        if (value == null) continue;
                        binding.add(v, value);
                    }
                    if (binding == null) {
                        return Iter.nullIterator();
                    }
                    return Iter.singletonIter((Object)binding);
                }
                if (noAggregators) {
                    return accumulators.keySet().iterator();
                }
                ArrayList<BindingMap> results = new ArrayList<BindingMap>();
                for (Binding k : accumulators.keySet()) {
                    Collection accs = accumulators.get((Object)k);
                    BindingMap b = BindingFactory.create(k);
                    for (Pair pair : accs) {
                        Node n;
                        Var v = (Var)((Object)pair.getLeft());
                        NodeValue value = ((Accumulator)pair.getRight()).getValue();
                        Node node = n = value == null ? null : value.asNode();
                        if (v == null || n == null) continue;
                        b.add(v, n);
                    }
                    results.add(b);
                }
                return results.iterator();
            }
        };
    }

    private static Binding genKey(VarExprList vars, Binding binding, ExecutionContext execCxt) {
        return QueryIterGroup.copyProject(vars, binding, execCxt);
    }

    private static Binding copyProject(VarExprList vars, Binding binding, ExecutionContext execCxt) {
        BindingMap x = BindingFactory.create();
        for (Var var : vars.getVars()) {
            Node node = vars.get(var, binding, execCxt);
            if (node == null) continue;
            x.add(var, node);
        }
        return x;
    }
}

