/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.binding.BindingUtils;
import org.apache.jena.sparql.engine.iterator.QueryIterConvert;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.main.OpExecutor;

public class QueryIterProjectMerge
extends QueryIterRepeatApply {
    private final OpProject opProject;
    private final OpExecutor engine;

    public QueryIterProjectMerge(OpProject opProject, QueryIterator input, OpExecutor engine, ExecutionContext execCxt) {
        super(input, execCxt);
        this.opProject = opProject;
        this.engine = engine;
    }

    @Override
    protected QueryIterator nextStage(Binding binding) {
        QueryIterator qIter = this.engine.executeOp(this.opProject.getSubOp(), QueryIterSingleton.create(binding, this.getExecContext()));
        qIter = new QueryIterConvert(qIter, new ProjectEnsureBindingConverter(binding, this.opProject.getVars()), this.getExecContext());
        return qIter;
    }

    static class ProjectEnsureBindingConverter
    implements QueryIterConvert.Converter {
        private final Binding outerBinding;
        private final List<Var> projectionVars;

        public ProjectEnsureBindingConverter(Binding outerBinding, List<Var> vars) {
            this.outerBinding = outerBinding;
            this.projectionVars = vars;
        }

        @Override
        public Binding convert(Binding bind) {
            return ProjectEnsureBindingConverter.ensure(this.projectionVars, this.outerBinding, bind);
        }

        private static Binding ensure(List<Var> vars, Binding outer, Binding inner) {
            Iterator<Var> vIter;
            BindingMap b2 = BindingFactory.create(outer);
            Iterator<Var> iterator = vIter = vars != null ? vars.iterator() : inner.vars();
            while (vIter.hasNext()) {
                Var v = vIter.next();
                Node n2 = inner.get(v);
                if (n2 == null) continue;
                if (!b2.contains(v)) {
                    b2.add(v, inner.get(v));
                    continue;
                }
                Node n1 = outer.get(v);
                if (n1.equals((Object)n2)) continue;
                Log.warn(BindingUtils.class, (String)("merge: Mismatch : " + n1 + " != " + n2));
            }
            return b2;
        }
    }
}

