/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.writers;

import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.SortCondition;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpPrefixesUsed;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDiff;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.algebra.table.TableUnit;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.WriterBasePrefix;
import org.apache.jena.sparql.sse.writers.WriterExpr;
import org.apache.jena.sparql.sse.writers.WriterLib;
import org.apache.jena.sparql.sse.writers.WriterNode;
import org.apache.jena.sparql.sse.writers.WriterPath;
import org.apache.jena.sparql.sse.writers.WriterTable;
import org.apache.jena.sparql.util.FmtUtils;

public class WriterOp {
    private static final int NL = 1;
    private static final int NoNL = -1;
    private static final int NoSP = -2;

    public static void output(Op op) {
        WriterOp.output(System.out, op);
    }

    public static void output(Op op, PrefixMapping pMap) {
        WriterOp.output((OutputStream)System.out, op, pMap);
    }

    public static void output(Op op, Prologue prologue) {
        WriterOp.output((OutputStream)System.out, op, prologue);
    }

    public static void output(OutputStream out, Op op) {
        WriterOp.output(out, op, (PrefixMapping)null);
    }

    public static void output(OutputStream out, Op op, PrefixMapping pMap) {
        WriterOp.output(new IndentedWriter(out), op, pMap);
    }

    public static void output(OutputStream out, Op op, Prologue prologue) {
        WriterOp.output(new IndentedWriter(out), op, prologue);
    }

    public static void output(IndentedWriter iWriter, Op op) {
        WriterOp.output(iWriter, op, (PrefixMapping)null);
    }

    public static void output(IndentedWriter iWriter, Op op, PrefixMapping pMap) {
        if (pMap == null) {
            pMap = OpPrefixesUsed.used(op, ARQConstants.getGlobalPrefixMap());
        }
        SerializationContext sCxt = new SerializationContext(pMap);
        WriterOp.output(iWriter, op, sCxt);
    }

    public static void output(IndentedWriter iWriter, Op op, Prologue prologue) {
        SerializationContext sCxt = new SerializationContext(prologue);
        WriterOp.output(iWriter, op, sCxt);
    }

    public static void output(OutputStream out, Op op, SerializationContext sCxt) {
        WriterOp.output(new IndentedWriter(out), op, sCxt);
    }

    public static void output(final IndentedWriter iWriter, final Op op, SerializationContext sCxt) {
        if (sCxt == null) {
            sCxt = new SerializationContext();
        }
        final SerializationContext sCxt2 = sCxt;
        WriterBasePrefix.Fmt fmt = new WriterBasePrefix.Fmt(){

            @Override
            public void format() {
                op.visit(new OpWriterWorker(iWriter, sCxt2));
            }
        };
        WriterBasePrefix.output(iWriter, fmt, sCxt2.getPrologue());
    }

    static void outputNoPrologue(IndentedWriter iWriter, Op op, SerializationContext sCxt) {
        OpWriterWorker v = new OpWriterWorker(iWriter, sCxt);
        op.visit(v);
    }

    public static class OpWriterWorker
    implements OpVisitor {
        private IndentedWriter out;
        private SerializationContext sContext;

        public OpWriterWorker(IndentedWriter out, SerializationContext sCxt) {
            this.sContext = sCxt;
            this.out = out;
        }

        private void visitOpN(OpN op) {
            this.start(op, 1);
            Iterator<Op> iter = op.iterator();
            while (iter.hasNext()) {
                Op sub = iter.next();
                this.out.ensureStartOfLine();
                this.printOp(sub);
            }
            this.finish(op);
        }

        private void visitOp2(Op2 op, ExprList exprs) {
            this.start(op, 1);
            this.printOp(op.getLeft());
            this.out.ensureStartOfLine();
            this.printOp(op.getRight());
            if (exprs != null) {
                this.out.ensureStartOfLine();
                WriterExpr.output(this.out, exprs, this.sContext);
            }
            this.finish(op);
        }

        private void visitOp1(Op1 op) {
            this.start(op, 1);
            this.printOp(op.getSubOp());
            this.finish(op);
        }

        @Override
        public void visit(OpBGP opBGP) {
            if (opBGP.getPattern().size() == 1) {
                this.start(opBGP, -1);
                this.write(opBGP.getPattern(), true);
                this.finish(opBGP);
                return;
            }
            this.start(opBGP, 1);
            this.write(opBGP.getPattern(), false);
            this.finish(opBGP);
        }

        @Override
        public void visit(OpQuadPattern opQuadP) {
            QuadPattern quads = opQuadP.getPattern();
            if (quads.size() == 1) {
                this.start(opQuadP, -1);
                this.formatQuad(quads.get(0));
                this.finish(opQuadP);
                return;
            }
            this.start(opQuadP, 1);
            this.write(quads, false);
            this.finish(opQuadP);
        }

        @Override
        public void visit(OpQuadBlock opQuads) {
            QuadPattern quads = opQuads.getPattern();
            if (quads.size() == 1) {
                this.start(opQuads, -1);
                this.formatQuad(quads.get(0));
                this.finish(opQuads);
                return;
            }
            this.start(opQuads, 1);
            this.write(quads, false);
            this.finish(opQuads);
        }

        private void write(BasicPattern pattern, boolean oneLine) {
            boolean first = true;
            for (Triple t : pattern) {
                this.formatTriple(t);
                if (oneLine) {
                    if (!first) {
                        this.out.print(" ");
                    }
                } else {
                    this.out.println();
                }
                first = false;
            }
        }

        private void write(QuadPattern quads, boolean oneLine) {
            boolean first = true;
            for (Quad t : quads) {
                this.formatQuad(t);
                if (oneLine) {
                    if (!first) {
                        this.out.print(" ");
                    }
                } else {
                    this.out.println();
                }
                first = false;
            }
        }

        @Override
        public void visit(OpTriple opTriple) {
            this.formatTriple(opTriple.getTriple());
        }

        @Override
        public void visit(OpQuad opQuad) {
            this.formatQuad(opQuad.getQuad());
        }

        @Override
        public void visit(OpPath opPath) {
            this.formatTriplePath(opPath.getTriplePath());
        }

        @Override
        public void visit(OpProcedure opProc) {
            this.start(opProc, -1);
            WriterNode.output(this.out, opProc.getProcId(), this.sContext);
            this.out.println();
            WriterExpr.output(this.out, opProc.getArgs(), true, false, this.sContext);
            this.out.println();
            this.printOp(opProc.getSubOp());
            this.finish(opProc);
        }

        @Override
        public void visit(OpPropFunc opPropFunc) {
            this.start(opPropFunc, -1);
            this.out.print(FmtUtils.stringForNode(opPropFunc.getProperty(), this.sContext));
            this.out.println();
            this.outputPF(opPropFunc.getSubjectArgs());
            this.out.print(" ");
            this.outputPF(opPropFunc.getObjectArgs());
            this.out.println();
            this.printOp(opPropFunc.getSubOp());
            this.finish(opPropFunc);
        }

        private void outputPF(PropFuncArg pfArg) {
            if (pfArg.isNode()) {
                WriterNode.output(this.out, pfArg.getArg(), this.sContext);
                return;
            }
            WriterNode.output(this.out, pfArg.getArgList(), this.sContext);
        }

        @Override
        public void visit(OpJoin opJoin) {
            this.visitOp2(opJoin, null);
        }

        @Override
        public void visit(OpSequence opSequence) {
            this.visitOpN(opSequence);
        }

        @Override
        public void visit(OpDisjunction opDisjunction) {
            this.visitOpN(opDisjunction);
        }

        @Override
        public void visit(OpLeftJoin opLeftJoin) {
            this.visitOp2(opLeftJoin, opLeftJoin.getExprs());
        }

        @Override
        public void visit(OpDiff opDiff) {
            this.visitOp2(opDiff, null);
        }

        @Override
        public void visit(OpMinus opMinus) {
            this.visitOp2(opMinus, null);
        }

        @Override
        public void visit(OpUnion opUnion) {
            this.visitOp2(opUnion, null);
        }

        @Override
        public void visit(OpConditional opCondition) {
            this.visitOp2(opCondition, null);
        }

        @Override
        public void visit(OpFilter opFilter) {
            this.start(opFilter, -1);
            ExprList exprs = opFilter.getExprs();
            if (exprs == null) {
                this.start();
                this.finish();
            } else {
                WriterExpr.output(this.out, exprs, this.sContext);
            }
            this.out.println();
            this.printOp(opFilter.getSubOp());
            this.finish(opFilter);
        }

        @Override
        public void visit(OpGraph opGraph) {
            this.start(opGraph, -1);
            this.out.println(FmtUtils.stringForNode(opGraph.getNode(), this.sContext));
            opGraph.getSubOp().visit(this);
            this.finish(opGraph);
        }

        @Override
        public void visit(OpService opService) {
            this.start(opService, -1);
            if (opService.getSilent()) {
                this.out.println("silent ");
            }
            this.out.println(FmtUtils.stringForNode(opService.getService(), this.sContext));
            opService.getSubOp().visit(this);
            this.finish(opService);
        }

        @Override
        public void visit(OpTable opTable) {
            if (TableUnit.isTableUnit(opTable.getTable())) {
                this.start(opTable, -1);
                this.out.print("unit");
                this.finish(opTable);
                return;
            }
            if (opTable.getTable().isEmpty()) {
                this.start(opTable, -1);
                this.out.print("empty");
                this.finish(opTable);
                return;
            }
            this.start(opTable, -1);
            WriterNode.outputVars(this.out, opTable.getTable().getVars(), this.sContext);
            this.out.println();
            WriterTable.outputPlain(this.out, opTable.getTable(), this.sContext);
            this.finish(opTable);
        }

        @Override
        public void visit(OpDatasetNames dsNames) {
            this.start(dsNames, -1);
            WriterNode.output(this.out, dsNames.getGraphNode(), this.sContext);
            this.finish(dsNames);
        }

        @Override
        public void visit(OpExt opExt) {
            opExt.output(this.out, this.sContext);
        }

        @Override
        public void visit(OpNull opNull) {
            this.start(opNull, -2);
            this.finish(opNull);
        }

        @Override
        public void visit(OpLabel opLabel) {
            String x = FmtUtils.stringForString(opLabel.getObject().toString());
            if (opLabel.hasSubOp()) {
                this.start(opLabel, 1);
                this.out.println(x);
                this.printOp(opLabel.getSubOp());
                this.finish(opLabel);
            } else {
                this.start(opLabel, -1);
                this.out.print(x);
                this.finish(opLabel);
            }
        }

        @Override
        public void visit(OpList opList) {
            this.visitOp1(opList);
        }

        @Override
        public void visit(OpGroup opGroup) {
            this.start(opGroup, -1);
            this.writeNamedExprList(opGroup.getGroupVars());
            if (!opGroup.getAggregators().isEmpty()) {
                this.out.print(" ");
                this.start();
                this.out.incIndent();
                boolean first = true;
                for (ExprAggregator agg : opGroup.getAggregators()) {
                    if (!first) {
                        this.out.print(" ");
                    }
                    first = false;
                    Var v = agg.getVar();
                    String str2 = agg.getAggregator().toPrefixString();
                    this.start();
                    this.out.print(v.toString());
                    this.out.print(" ");
                    this.out.print(str2);
                    this.finish();
                }
                this.finish();
                this.out.decIndent();
            }
            this.out.println();
            this.printOp(opGroup.getSubOp());
            this.finish(opGroup);
        }

        @Override
        public void visit(OpOrder opOrder) {
            this.start(opOrder, -1);
            this.start();
            boolean first = true;
            for (SortCondition sc : opOrder.getConditions()) {
                if (!first) {
                    this.out.print(" ");
                }
                first = false;
                this.formatSortCondition(sc);
            }
            this.finish();
            this.out.newline();
            this.printOp(opOrder.getSubOp());
            this.finish(opOrder);
        }

        @Override
        public void visit(OpTopN opTop) {
            this.start(opTop, -1);
            this.start();
            this.writeIntOrDefault(opTop.getLimit());
            this.out.print(" ");
            boolean first = true;
            for (SortCondition sc : opTop.getConditions()) {
                if (!first) {
                    this.out.print(" ");
                }
                first = false;
                this.formatSortCondition(sc);
            }
            this.finish();
            this.out.newline();
            this.printOp(opTop.getSubOp());
            this.finish(opTop);
        }

        private void formatSortCondition(SortCondition sc) {
            boolean close = true;
            String tag = null;
            if (sc.getDirection() != -2) {
                if (sc.getDirection() == 1) {
                    tag = "asc";
                    WriterLib.start(this.out, tag, -1);
                }
                if (sc.getDirection() == -1) {
                    tag = "desc";
                    WriterLib.start(this.out, tag, -1);
                }
            }
            WriterExpr.output(this.out, sc.getExpression(), this.sContext);
            if (tag != null) {
                WriterLib.finish(this.out, tag);
            }
        }

        @Override
        public void visit(OpProject opProject) {
            this.start(opProject, -1);
            this.writeVarList(opProject.getVars());
            this.out.println();
            this.printOp(opProject.getSubOp());
            this.finish(opProject);
        }

        @Override
        public void visit(OpDistinct opDistinct) {
            this.visitOp1(opDistinct);
        }

        @Override
        public void visit(OpReduced opReduced) {
            this.visitOp1(opReduced);
        }

        @Override
        public void visit(OpAssign opAssign) {
            this.start(opAssign, -1);
            this.writeNamedExprList(opAssign.getVarExprList());
            this.out.println();
            this.printOp(opAssign.getSubOp());
            this.finish(opAssign);
        }

        @Override
        public void visit(OpExtend opExtend) {
            this.start(opExtend, -1);
            this.writeNamedExprList(opExtend.getVarExprList());
            this.out.println();
            this.printOp(opExtend.getSubOp());
            this.finish(opExtend);
        }

        @Override
        public void visit(OpSlice opSlice) {
            this.start(opSlice, -1);
            this.writeIntOrDefault(opSlice.getStart());
            this.out.print(" ");
            this.writeIntOrDefault(opSlice.getLength());
            this.out.println();
            this.printOp(opSlice.getSubOp());
            this.finish(opSlice);
        }

        private void writeIntOrDefault(long value) {
            String x = "_";
            if (value != Long.MIN_VALUE) {
                x = Long.toString(value);
            }
            this.out.print(x);
        }

        private void start(Op op, int newline) {
            WriterLib.start(this.out, op.getName(), newline);
        }

        private void finish(Op op) {
            WriterLib.finish(this.out, op.getName());
        }

        private void start() {
            WriterLib.start(this.out);
        }

        private void finish() {
            WriterLib.finish(this.out);
        }

        private void printOp(Op op) {
            if (op == null) {
                WriterLib.start(this.out, "null", -2);
                WriterLib.finish(this.out, "null");
            } else {
                op.visit(this);
            }
        }

        private void writeVarList(List<Var> vars) {
            this.start();
            boolean first = true;
            for (Var var : vars) {
                if (!first) {
                    this.out.print(" ");
                }
                first = false;
                this.out.print(var.toString());
            }
            this.finish();
        }

        private void writeNamedExprList(VarExprList project) {
            this.start();
            boolean first = true;
            for (Var v : project.getVars()) {
                if (!first) {
                    this.out.print(" ");
                }
                first = false;
                Expr expr = project.getExpr(v);
                if (expr != null) {
                    this.start();
                    this.out.print(v.toString());
                    this.out.print(" ");
                    String $ = WriterExpr.asString(expr);
                    WriterExpr.output(this.out, expr, this.sContext);
                    this.finish();
                    continue;
                }
                this.out.print(v.toString());
            }
            this.finish();
        }

        private void formatTriple(Triple tp) {
            WriterNode.output(this.out, tp, this.sContext);
        }

        private void formatQuad(Quad qp) {
            WriterNode.output(this.out, qp, this.sContext);
        }

        private void formatTriplePath(TriplePath tp) {
            WriterPath.output(this.out, tp, this.sContext);
        }
    }
}

