/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.lang.JsonLDReader;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.ReaderRDFNULL;
import org.apache.jena.riot.lang.ReaderTriX;
import org.apache.jena.riot.lang.RiotParsers;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.thrift.BinRDF;
import org.apache.jena.sparql.util.Context;

public class RDFParserRegistry {
    private static Map<String, Lang> mapJenaNameToLang = new HashMap<String, Lang>();
    private static Map<Lang, ReaderRIOTFactory> langToParserFactory = new HashMap<Lang, ReaderRIOTFactory>();
    private static Set<Lang> langTriples = new HashSet<Lang>();
    private static Set<Lang> langQuads = new HashSet<Lang>();
    private static ReaderRIOTFactory parserFactory = new ReaderRIOTFactoryImpl();
    private static ReaderRIOTFactory parserFactoryJsonLD = new ReaderRIOTFactoryJSONLD();
    private static ReaderRIOTFactory parserFactoryThrift = new ReaderRIOTFactoryThrift();
    private static ReaderRIOTFactory parserFactoryTriX = new ReaderRIOTFactoryTriX();
    private static ReaderRIOTFactory parserFactoryRDFNULL = new ReaderRIOTFactoryRDFNULL();
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        RDFParserRegistry.initStandard();
    }

    private static void initStandard() {
        RDFLanguages.init();
        RDFParserRegistry.registerLangTriples(RDFLanguages.RDFXML, parserFactory);
        RDFParserRegistry.registerLangTriples(RDFLanguages.NTRIPLES, parserFactory);
        RDFParserRegistry.registerLangTriples(RDFLanguages.N3, parserFactory);
        RDFParserRegistry.registerLangTriples(RDFLanguages.TURTLE, parserFactory);
        RDFParserRegistry.registerLangTriples(RDFLanguages.JSONLD, parserFactoryJsonLD);
        RDFParserRegistry.registerLangTriples(RDFLanguages.RDFJSON, parserFactory);
        RDFParserRegistry.registerLangTriples(RDFLanguages.CSV, parserFactory);
        RDFParserRegistry.registerLangTriples(RDFLanguages.THRIFT, parserFactoryThrift);
        RDFParserRegistry.registerLangTriples(RDFLanguages.TRIX, parserFactoryTriX);
        RDFParserRegistry.registerLangTriples(RDFLanguages.RDFNULL, parserFactoryRDFNULL);
        RDFParserRegistry.registerLangQuads(RDFLanguages.JSONLD, parserFactoryJsonLD);
        RDFParserRegistry.registerLangQuads(RDFLanguages.NQUADS, parserFactory);
        RDFParserRegistry.registerLangQuads(RDFLanguages.TRIG, parserFactory);
        RDFParserRegistry.registerLangQuads(RDFLanguages.THRIFT, parserFactoryThrift);
        RDFParserRegistry.registerLangQuads(RDFLanguages.TRIX, parserFactoryTriX);
        RDFParserRegistry.registerLangQuads(RDFLanguages.RDFNULL, parserFactoryRDFNULL);
    }

    private static void registerLang(Lang lang, ReaderRIOTFactory factory) {
        RDFLanguages.register(lang);
        langToParserFactory.put(lang, factory);
    }

    public static void registerLangTriples(Lang lang, ReaderRIOTFactory factory) {
        langTriples.add(lang);
        RDFParserRegistry.registerLang(lang, factory);
    }

    public static void registerLangQuads(Lang lang, ReaderRIOTFactory factory) {
        langQuads.add(lang);
        RDFParserRegistry.registerLang(lang, factory);
    }

    public static void removeRegistration(Lang lang) {
        RDFLanguages.unregister(lang);
        langToParserFactory.remove(lang);
    }

    public static ReaderRIOTFactory getFactory(Lang language) {
        return langToParserFactory.get(language);
    }

    public static boolean isRegistered(Lang lang) {
        return langToParserFactory.containsKey(lang);
    }

    public static boolean isTriples(Lang lang) {
        return langTriples.contains(lang);
    }

    public static boolean isQuads(Lang lang) {
        return langQuads.contains(lang);
    }

    static {
        RDFParserRegistry.init();
    }

    private static class ReaderRIOTFactoryRDFNULL
    implements ReaderRIOTFactory {
        private ReaderRIOTFactoryRDFNULL() {
        }

        @Override
        public ReaderRIOT create(Lang language) {
            return new ReaderRDFNULL();
        }
    }

    private static class ReaderRIOTFactoryTriX
    implements ReaderRIOTFactory {
        private ReaderRIOTFactoryTriX() {
        }

        @Override
        public ReaderRIOT create(Lang language) {
            return new ReaderTriX();
        }
    }

    private static class ReaderRDFThrift
    implements ReaderRIOT {
        private ReaderRDFThrift() {
        }

        @Override
        public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context) {
            BinRDF.inputStreamToStream(in, output);
        }

        @Override
        public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context) {
            throw new RiotException("RDF Thrift : Reading binary data from a java.io.reader is not supported. Please use an InputStream");
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return null;
        }

        @Override
        public void setErrorHandler(ErrorHandler errorHandler) {
        }

        @Override
        public ParserProfile getParserProfile() {
            return null;
        }

        @Override
        public void setParserProfile(ParserProfile profile) {
        }
    }

    private static class ReaderRIOTFactoryThrift
    implements ReaderRIOTFactory {
        private ReaderRIOTFactoryThrift() {
        }

        @Override
        public ReaderRIOT create(Lang language) {
            return new ReaderRDFThrift();
        }
    }

    private static class ReaderRIOTFactoryJSONLD
    implements ReaderRIOTFactory {
        private ReaderRIOTFactoryJSONLD() {
        }

        @Override
        public ReaderRIOT create(Lang language) {
            if (!Lang.JSONLD.equals(language)) {
                throw new InternalErrorException("Attempt to parse " + language + " as JSON-LD");
            }
            return new JsonLDReader();
        }
    }

    private static class ReaderRIOTLang
    implements ReaderRIOT {
        private final Lang lang;
        private ErrorHandler errorHandler;
        private ParserProfile parserProfile = null;

        ReaderRIOTLang(Lang lang) {
            this.lang = lang;
            this.errorHandler = ErrorHandlerFactory.getDefaultErrorHandler();
        }

        @Override
        public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context) {
            LangRIOT parser = RiotParsers.createParser(in, this.lang, baseURI, output);
            if (this.parserProfile != null) {
                parser.setProfile(this.parserProfile);
            }
            if (this.errorHandler != null) {
                parser.getProfile().setHandler(this.errorHandler);
            }
            parser.parse();
        }

        @Override
        public void read(Reader in, String baseURI, ContentType ct, StreamRDF output, Context context) {
            LangRIOT parser = RiotParsers.createParser(in, this.lang, baseURI, output);
            parser.getProfile().setHandler(this.errorHandler);
            parser.parse();
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        @Override
        public void setErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        @Override
        public ParserProfile getParserProfile() {
            return this.parserProfile;
        }

        @Override
        public void setParserProfile(ParserProfile parserProfile) {
            this.parserProfile = parserProfile;
            this.errorHandler = parserProfile.getHandler();
        }
    }

    private static class ReaderRIOTFactoryImpl
    implements ReaderRIOTFactory {
        private ReaderRIOTFactoryImpl() {
        }

        @Override
        public ReaderRIOT create(Lang lang) {
            return new ReaderRIOTLang(lang);
        }
    }
}

