/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.data.BagFactory;
import org.apache.jena.atlas.data.SortedDataBag;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.atlas.iterator.IteratorDelayedInitialization;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.SortCondition;
import org.apache.jena.riot.system.SerializationFactoryFinder;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;

public class QueryIterSort
extends QueryIterPlainWrapper {
    private final QueryIterator embeddedIterator;
    final SortedDataBag<Binding> db;

    public QueryIterSort(QueryIterator qIter, List<SortCondition> conditions, ExecutionContext context) {
        this(qIter, new BindingComparator(conditions, context), context);
    }

    public QueryIterSort(QueryIterator qIter, Comparator<Binding> comparator, ExecutionContext context) {
        super(null, context);
        this.embeddedIterator = qIter;
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(context.getContext());
        this.db = BagFactory.newSortedBag(policy, SerializationFactoryFinder.bindingSerializationFactory(), comparator);
        this.setIterator((Iterator<Binding>)((Object)new SortedBindingIterator(qIter)));
    }

    @Override
    public void requestCancel() {
        this.db.cancel();
        this.embeddedIterator.cancel();
        super.requestCancel();
    }

    private class SortedBindingIterator
    extends IteratorDelayedInitialization<Binding>
    implements Closeable {
        private final QueryIterator qIter;

        public SortedBindingIterator(QueryIterator qIter) {
            this.qIter = qIter;
        }

        protected Iterator<Binding> initializeIterator() {
            try {
                QueryIterSort.this.db.addAll(this.qIter);
                return QueryIterSort.this.db.iterator();
            }
            catch (QueryCancelledException e2) {
                this.close();
                throw e2;
            }
        }

        public void close() {
            QueryIterSort.this.db.close();
        }
    }
}

