/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockCharFilter;
import org.apache.lucene.analysis.MockReaderWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.TokenStreamToDot;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LineFileDocs;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.Rethrow;
import org.apache.lucene.util._TestUtil;

public abstract class BaseTokenStreamTestCase
extends LuceneTestCase {
    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset, Integer finalPosInc, boolean[] keywordAtts, boolean offsetsAreCorrect) throws IOException {
        BaseTokenStreamTestCase.assertNotNull((Object)output);
        CheckClearAttributesAttribute checkClearAtt = (CheckClearAttributesAttribute)ts.addAttribute(CheckClearAttributesAttribute.class);
        CharTermAttribute termAtt = null;
        if (output.length > 0) {
            BaseTokenStreamTestCase.assertTrue((String)"has no CharTermAttribute", (boolean)ts.hasAttribute(CharTermAttribute.class));
            termAtt = (CharTermAttribute)ts.getAttribute(CharTermAttribute.class);
        }
        OffsetAttribute offsetAtt = null;
        if (startOffsets != null || endOffsets != null || finalOffset != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no OffsetAttribute", (boolean)ts.hasAttribute(OffsetAttribute.class));
            offsetAtt = (OffsetAttribute)ts.getAttribute(OffsetAttribute.class);
        }
        TypeAttribute typeAtt = null;
        if (types != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no TypeAttribute", (boolean)ts.hasAttribute(TypeAttribute.class));
            typeAtt = (TypeAttribute)ts.getAttribute(TypeAttribute.class);
        }
        PositionIncrementAttribute posIncrAtt = null;
        if (posIncrements != null || finalPosInc != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no PositionIncrementAttribute", (boolean)ts.hasAttribute(PositionIncrementAttribute.class));
            posIncrAtt = (PositionIncrementAttribute)ts.getAttribute(PositionIncrementAttribute.class);
        }
        PositionLengthAttribute posLengthAtt = null;
        if (posLengths != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no PositionLengthAttribute", (boolean)ts.hasAttribute(PositionLengthAttribute.class));
            posLengthAtt = (PositionLengthAttribute)ts.getAttribute(PositionLengthAttribute.class);
        }
        KeywordAttribute keywordAtt = null;
        if (keywordAtts != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no KeywordAttribute", (boolean)ts.hasAttribute(KeywordAttribute.class));
            keywordAtt = (KeywordAttribute)ts.getAttribute(KeywordAttribute.class);
        }
        HashMap<Integer, Integer> posToStartOffset = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> posToEndOffset = new HashMap<Integer, Integer>();
        ts.reset();
        int pos = -1;
        int lastStartOffset = 0;
        for (int i = 0; i < output.length; ++i) {
            ts.clearAttributes();
            termAtt.setEmpty().append("bogusTerm");
            if (offsetAtt != null) {
                offsetAtt.setOffset(14584724, 24683243);
            }
            if (typeAtt != null) {
                typeAtt.setType("bogusType");
            }
            if (posIncrAtt != null) {
                posIncrAtt.setPositionIncrement(45987657);
            }
            if (posLengthAtt != null) {
                posLengthAtt.setPositionLength(45987653);
            }
            if (keywordAtt != null) {
                keywordAtt.setKeyword((i & 1) == 0);
            }
            checkClearAtt.getAndResetClearCalled();
            BaseTokenStreamTestCase.assertTrue((String)("token " + i + " does not exist"), (boolean)ts.incrementToken());
            BaseTokenStreamTestCase.assertTrue((String)"clearAttributes() was not called correctly in TokenStream chain", (boolean)checkClearAtt.getAndResetClearCalled());
            BaseTokenStreamTestCase.assertEquals((String)("term " + i), (Object)output[i], (Object)termAtt.toString());
            if (startOffsets != null) {
                BaseTokenStreamTestCase.assertEquals((String)("startOffset " + i), (long)startOffsets[i], (long)offsetAtt.startOffset());
            }
            if (endOffsets != null) {
                BaseTokenStreamTestCase.assertEquals((String)("endOffset " + i), (long)endOffsets[i], (long)offsetAtt.endOffset());
            }
            if (types != null) {
                BaseTokenStreamTestCase.assertEquals((String)("type " + i), (Object)types[i], (Object)typeAtt.type());
            }
            if (posIncrements != null) {
                BaseTokenStreamTestCase.assertEquals((String)("posIncrement " + i), (long)posIncrements[i], (long)posIncrAtt.getPositionIncrement());
            }
            if (posLengths != null) {
                BaseTokenStreamTestCase.assertEquals((String)("posLength " + i), (long)posLengths[i], (long)posLengthAtt.getPositionLength());
            }
            if (keywordAtts != null) {
                BaseTokenStreamTestCase.assertEquals((String)("keywordAtt " + i), (Object)keywordAtts[i], (Object)keywordAtt.isKeyword());
            }
            if (offsetAtt != null) {
                int startOffset = offsetAtt.startOffset();
                int endOffset = offsetAtt.endOffset();
                if (finalOffset != null) {
                    BaseTokenStreamTestCase.assertTrue((String)"startOffset must be <= finalOffset", (startOffset <= finalOffset ? 1 : 0) != 0);
                    BaseTokenStreamTestCase.assertTrue((String)("endOffset must be <= finalOffset: got endOffset=" + endOffset + " vs finalOffset=" + finalOffset), (endOffset <= finalOffset ? 1 : 0) != 0);
                }
                if (offsetsAreCorrect) {
                    BaseTokenStreamTestCase.assertTrue((String)("offsets must not go backwards startOffset=" + startOffset + " is < lastStartOffset=" + lastStartOffset), (offsetAtt.startOffset() >= lastStartOffset ? 1 : 0) != 0);
                    lastStartOffset = offsetAtt.startOffset();
                }
                if (offsetsAreCorrect && posLengthAtt != null && posIncrAtt != null) {
                    int posInc = posIncrAtt.getPositionIncrement();
                    int posLength = posLengthAtt.getPositionLength();
                    if (!posToStartOffset.containsKey(pos += posInc)) {
                        posToStartOffset.put(pos, startOffset);
                    } else {
                        BaseTokenStreamTestCase.assertEquals((String)("pos=" + pos + " posLen=" + posLength + " token=" + termAtt), (long)((Integer)posToStartOffset.get(pos)).intValue(), (long)startOffset);
                    }
                    int endPos = pos + posLength;
                    if (!posToEndOffset.containsKey(endPos)) {
                        posToEndOffset.put(endPos, endOffset);
                    } else {
                        BaseTokenStreamTestCase.assertEquals((String)("pos=" + pos + " posLen=" + posLength + " token=" + termAtt), (long)((Integer)posToEndOffset.get(endPos)).intValue(), (long)endOffset);
                    }
                }
            }
            if (posIncrAtt != null) {
                if (i == 0) {
                    BaseTokenStreamTestCase.assertTrue((String)"first posIncrement must be >= 1", (posIncrAtt.getPositionIncrement() >= 1 ? 1 : 0) != 0);
                } else {
                    BaseTokenStreamTestCase.assertTrue((String)"posIncrement must be >= 0", (posIncrAtt.getPositionIncrement() >= 0 ? 1 : 0) != 0);
                }
            }
            if (posLengthAtt == null) continue;
            BaseTokenStreamTestCase.assertTrue((String)"posLength must be >= 1", (posLengthAtt.getPositionLength() >= 1 ? 1 : 0) != 0);
        }
        if (ts.incrementToken()) {
            BaseTokenStreamTestCase.fail((String)("TokenStream has more tokens than expected (expected count=" + output.length + "); extra token=" + termAtt.toString()));
        }
        ts.clearAttributes();
        if (termAtt != null) {
            termAtt.setEmpty().append("bogusTerm");
        }
        if (offsetAtt != null) {
            offsetAtt.setOffset(14584724, 24683243);
        }
        if (typeAtt != null) {
            typeAtt.setType("bogusType");
        }
        if (posIncrAtt != null) {
            posIncrAtt.setPositionIncrement(45987657);
        }
        if (posLengthAtt != null) {
            posLengthAtt.setPositionLength(45987653);
        }
        checkClearAtt.getAndResetClearCalled();
        ts.end();
        BaseTokenStreamTestCase.assertTrue((String)"super.end()/clearAttributes() was not called correctly in end()", (boolean)checkClearAtt.getAndResetClearCalled());
        if (finalOffset != null) {
            BaseTokenStreamTestCase.assertEquals((String)"finalOffset", (long)finalOffset.intValue(), (long)offsetAtt.endOffset());
        }
        if (offsetAtt != null) {
            BaseTokenStreamTestCase.assertTrue((String)"finalOffset must be >= 0", (offsetAtt.endOffset() >= 0 ? 1 : 0) != 0);
        }
        if (finalPosInc != null) {
            BaseTokenStreamTestCase.assertEquals((String)"finalPosInc", (long)finalPosInc.intValue(), (long)posIncrAtt.getPositionIncrement());
        }
        ts.close();
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset, boolean[] keywordAtts, boolean offsetsAreCorrect) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, posLengths, finalOffset, null, null, offsetsAreCorrect);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset, boolean offsetsAreCorrect) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, posLengths, finalOffset, null, offsetsAreCorrect);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, posLengths, finalOffset, true);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, null, finalOffset);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, null, null, null, null, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, String[] types) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, null, null, types, null, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, null, null, null, posIncrements, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, null, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, null, null, finalOffset);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, posIncrements, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, int[] posIncrements, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, posIncrements, null, finalOffset);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, int[] posIncrements, int[] posLengths, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, posIncrements, posLengths, finalOffset);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.checkResetException(a, input);
        BaseTokenStreamTestCase.assertTokenStreamContents(a.tokenStream("dummy", input), output, startOffsets, endOffsets, types, posIncrements, null, input.length());
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths) throws IOException {
        BaseTokenStreamTestCase.checkResetException(a, input);
        BaseTokenStreamTestCase.assertTokenStreamContents(a.tokenStream("dummy", input), output, startOffsets, endOffsets, types, posIncrements, posLengths, input.length());
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, int[] posLengths, boolean offsetsAreCorrect) throws IOException {
        BaseTokenStreamTestCase.checkResetException(a, input);
        BaseTokenStreamTestCase.assertTokenStreamContents(a.tokenStream("dummy", input), output, startOffsets, endOffsets, types, posIncrements, posLengths, input.length(), offsetsAreCorrect);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, null, null, null, null, null);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, String[] types) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, null, null, types, null, null);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, null, null, null, posIncrements, null);
    }

    public static void assertAnalyzesToPositions(Analyzer a, String input, String[] output, int[] posIncrements, int[] posLengths) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, null, null, null, posIncrements, posLengths);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, startOffsets, endOffsets, null, null, null);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, startOffsets, endOffsets, null, posIncrements, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkResetException(Analyzer a, String input) throws IOException {
        TokenStream ts = a.tokenStream("bogus", input);
        try {
            if (ts.incrementToken()) {
                BaseTokenStreamTestCase.fail((String)"didn't get expected exception when reset() not called");
            }
        }
        catch (IllegalStateException expected) {
        }
        catch (AssertionError expected) {
            BaseTokenStreamTestCase.assertTrue((String)((Throwable)((Object)expected)).getMessage(), (((Throwable)((Object)expected)).getMessage() != null && ((Throwable)((Object)expected)).getMessage().contains("wrong state") ? 1 : 0) != 0);
        }
        catch (Exception unexpected) {
            unexpected.printStackTrace(System.err);
            BaseTokenStreamTestCase.fail((String)("got wrong exception when reset() not called: " + unexpected));
        }
        finally {
            ts.reset();
            while (ts.incrementToken()) {
            }
            ts.end();
            ts.close();
        }
        ts = a.tokenStream("bogus", input);
        ts.reset();
        while (ts.incrementToken()) {
        }
        ts.end();
        try {
            ts = a.tokenStream("bogus", input);
            BaseTokenStreamTestCase.fail((String)"didn't get expected exception when close() not called");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            ts.close();
        }
    }

    public static void checkOneTerm(Analyzer a, String input, String expected) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, new String[]{expected});
    }

    public static void checkRandomData(Random random, Analyzer a, int iterations) throws IOException {
        BaseTokenStreamTestCase.checkRandomData(random, a, iterations, 20, false, true);
    }

    public static void checkRandomData(Random random, Analyzer a, int iterations, int maxWordLength) throws IOException {
        BaseTokenStreamTestCase.checkRandomData(random, a, iterations, maxWordLength, false, true);
    }

    public static void checkRandomData(Random random, Analyzer a, int iterations, boolean simple) throws IOException {
        BaseTokenStreamTestCase.checkRandomData(random, a, iterations, 20, simple, true);
    }

    public static void checkRandomData(Random random, Analyzer a, int iterations, int maxWordLength, boolean simple) throws IOException {
        BaseTokenStreamTestCase.checkRandomData(random, a, iterations, maxWordLength, simple, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkRandomData(Random random, Analyzer a, int iterations, int maxWordLength, boolean simple, boolean offsetsAreCorrect) throws IOException {
        block12: {
            RandomIndexWriter iw;
            BaseDirectoryWrapper dir;
            block11: {
                boolean codecOk;
                BaseTokenStreamTestCase.checkResetException(a, "best effort");
                long seed = random.nextLong();
                boolean useCharFilter = random.nextBoolean();
                dir = null;
                iw = null;
                String postingsFormat = _TestUtil.getPostingsFormat("dummy");
                boolean bl = codecOk = iterations * maxWordLength < 100000 || !postingsFormat.equals("Memory") && !postingsFormat.equals("SimpleText");
                if (BaseTokenStreamTestCase.rarely(random) && codecOk) {
                    dir = BaseTokenStreamTestCase.newFSDirectory(_TestUtil.getTempDir("bttc"));
                    iw = new RandomIndexWriter(new Random(seed), (Directory)dir, a);
                }
                boolean success = false;
                try {
                    int i;
                    BaseTokenStreamTestCase.checkRandomData(new Random(seed), a, iterations, maxWordLength, useCharFilter, simple, offsetsAreCorrect, iw);
                    int numThreads = _TestUtil.nextInt(random, 2, 4);
                    AnalysisThread[] threads = new AnalysisThread[numThreads];
                    for (i = 0; i < threads.length; ++i) {
                        threads[i] = new AnalysisThread(seed, a, iterations, maxWordLength, useCharFilter, simple, offsetsAreCorrect, iw);
                    }
                    for (i = 0; i < threads.length; ++i) {
                        threads[i].start();
                    }
                    for (i = 0; i < threads.length; ++i) {
                        try {
                            threads[i].join();
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    for (i = 0; i < threads.length; ++i) {
                        if (!threads[i].failed) continue;
                        throw new RuntimeException("some thread(s) failed");
                    }
                    success = true;
                    if (!success) break block11;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{iw, dir});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{iw, dir});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{iw, dir});
                break block12;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{iw, dir});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkRandomData(Random random, Analyzer a, int iterations, int maxWordLength, boolean useCharFilter, boolean simple, boolean offsetsAreCorrect, RandomIndexWriter iw) throws IOException {
        LineFileDocs docs = new LineFileDocs(random);
        Document doc = null;
        Field field = null;
        Field currentField = null;
        StringReader bogus = new StringReader("");
        if (iw != null) {
            String pf;
            doc = new Document();
            FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
            if (random.nextBoolean()) {
                ft.setStoreTermVectors(true);
                ft.setStoreTermVectorOffsets(random.nextBoolean());
                ft.setStoreTermVectorPositions(random.nextBoolean());
                if (ft.storeTermVectorPositions() && !PREFLEX_IMPERSONATION_IS_ACTIVE) {
                    ft.setStoreTermVectorPayloads(random.nextBoolean());
                }
            }
            if (random.nextBoolean()) {
                ft.setOmitNorms(true);
            }
            boolean supportsOffsets = !doesntSupportOffsets.contains(pf = _TestUtil.getPostingsFormat("dummy"));
            switch (random.nextInt(4)) {
                case 0: {
                    ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
                    break;
                }
                case 1: {
                    ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS);
                    break;
                }
                case 2: {
                    ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
                    break;
                }
                default: {
                    if (supportsOffsets && offsetsAreCorrect) {
                        ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
                        break;
                    }
                    ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
                }
            }
            currentField = field = new Field("dummy", (Reader)bogus, ft);
            doc.add((IndexableField)currentField);
        }
        try {
            for (int i = 0; i < iterations; ++i) {
                String text;
                if (random.nextInt(10) == 7) {
                    text = docs.nextDoc().get("body");
                    if (text.length() > maxWordLength) {
                        int startPos = random.nextInt(text.length() - maxWordLength);
                        if (startPos > 0 && Character.isLowSurrogate(text.charAt(startPos))) assert (Character.isHighSurrogate(text.charAt(--startPos)));
                        int endPos = startPos + maxWordLength - 1;
                        if (Character.isHighSurrogate(text.charAt(endPos))) {
                            --endPos;
                        }
                        text = text.substring(startPos, 1 + endPos);
                    }
                } else {
                    text = BaseTokenStreamTestCase.randomAnalysisString(random, maxWordLength, simple);
                }
                try {
                    BaseTokenStreamTestCase.checkAnalysisConsistency(random, a, useCharFilter, text, offsetsAreCorrect, currentField);
                    if (iw == null) continue;
                    if (random.nextInt(7) == 0) {
                        FieldType ft = field.fieldType();
                        currentField = new Field("dummy", (Reader)bogus, ft);
                        doc.add((IndexableField)currentField);
                        continue;
                    }
                    iw.addDocument(doc);
                    if (doc.getFields().size() <= 1) continue;
                    currentField = field;
                    doc.removeFields("dummy");
                    doc.add((IndexableField)currentField);
                    continue;
                }
                catch (Throwable t) {
                    System.err.println("TEST FAIL: useCharFilter=" + useCharFilter + " text='" + BaseTokenStreamTestCase.escape(text) + "'");
                    Rethrow.rethrow(t);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{docs});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{docs});
    }

    public static String escape(String s) {
        int c;
        StringBuilder sb = new StringBuilder();
        for (int charUpto = 0; charUpto < s.length(); charUpto += Character.charCount(c)) {
            c = s.codePointAt(charUpto);
            if (c == 10) {
                sb.append("\\n");
                continue;
            }
            if (c == 13) {
                sb.append("\\r");
                continue;
            }
            if (c == 34) {
                sb.append("\\\"");
                continue;
            }
            if (c == 92) {
                sb.append("\\\\");
                continue;
            }
            if (c >= 32 && c < 128) {
                sb.append((char)c);
                continue;
            }
            sb.append(String.format(Locale.ROOT, "\\u%04x", c));
        }
        return sb.toString();
    }

    public static void checkAnalysisConsistency(Random random, Analyzer a, boolean useCharFilter, String text) throws IOException {
        BaseTokenStreamTestCase.checkAnalysisConsistency(random, a, useCharFilter, text, true);
    }

    public static void checkAnalysisConsistency(Random random, Analyzer a, boolean useCharFilter, String text, boolean offsetsAreCorrect) throws IOException {
        BaseTokenStreamTestCase.checkAnalysisConsistency(random, a, useCharFilter, text, offsetsAreCorrect, null);
    }

    private static void checkAnalysisConsistency(Random random, Analyzer a, boolean useCharFilter, String text, boolean offsetsAreCorrect, Field field) throws IOException {
        if (VERBOSE) {
            System.out.println(Thread.currentThread().getName() + ": NOTE: BaseTokenStreamTestCase: get first token stream now text=" + text);
        }
        int remainder = random.nextInt(10);
        Reader reader = new StringReader(text);
        TokenStream ts = a.tokenStream("dummy", (Reader)(useCharFilter ? new MockCharFilter(reader, remainder) : reader));
        CharTermAttribute termAtt = ts.hasAttribute(CharTermAttribute.class) ? (CharTermAttribute)ts.getAttribute(CharTermAttribute.class) : null;
        OffsetAttribute offsetAtt = ts.hasAttribute(OffsetAttribute.class) ? (OffsetAttribute)ts.getAttribute(OffsetAttribute.class) : null;
        PositionIncrementAttribute posIncAtt = ts.hasAttribute(PositionIncrementAttribute.class) ? (PositionIncrementAttribute)ts.getAttribute(PositionIncrementAttribute.class) : null;
        PositionLengthAttribute posLengthAtt = ts.hasAttribute(PositionLengthAttribute.class) ? (PositionLengthAttribute)ts.getAttribute(PositionLengthAttribute.class) : null;
        TypeAttribute typeAtt = ts.hasAttribute(TypeAttribute.class) ? (TypeAttribute)ts.getAttribute(TypeAttribute.class) : null;
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<Integer> positions = new ArrayList<Integer>();
        ArrayList<Integer> positionLengths = new ArrayList<Integer>();
        ArrayList<Integer> startOffsets = new ArrayList<Integer>();
        ArrayList<Integer> endOffsets = new ArrayList<Integer>();
        ts.reset();
        while (ts.incrementToken()) {
            BaseTokenStreamTestCase.assertNotNull((String)"has no CharTermAttribute", (Object)termAtt);
            tokens.add(termAtt.toString());
            if (typeAtt != null) {
                types.add(typeAtt.type());
            }
            if (posIncAtt != null) {
                positions.add(posIncAtt.getPositionIncrement());
            }
            if (posLengthAtt != null) {
                positionLengths.add(posLengthAtt.getPositionLength());
            }
            if (offsetAtt == null) continue;
            startOffsets.add(offsetAtt.startOffset());
            endOffsets.add(offsetAtt.endOffset());
        }
        ts.end();
        ts.close();
        if (!tokens.isEmpty() && text.length() != 0) {
            int evilness = random.nextInt(50);
            if (evilness == 17) {
                block35: {
                    if (VERBOSE) {
                        System.out.println(Thread.currentThread().getName() + ": NOTE: BaseTokenStreamTestCase: re-run analysis w/ exception");
                    }
                    MockReaderWrapper evilReader = new MockReaderWrapper(random, new StringReader(text));
                    evilReader.throwExcAfterChar(random.nextInt(text.length() + 1));
                    reader = evilReader;
                    try {
                        ts = a.tokenStream("dummy", (Reader)(useCharFilter ? new MockCharFilter(evilReader, remainder) : evilReader));
                        ts.reset();
                        while (ts.incrementToken()) {
                        }
                        BaseTokenStreamTestCase.fail((String)"did not hit exception");
                    }
                    catch (RuntimeException re) {
                        BaseTokenStreamTestCase.assertTrue((boolean)MockReaderWrapper.isMyEvilException(re));
                    }
                    try {
                        ts.end();
                    }
                    catch (AssertionError ae) {
                        if ("end() called before incrementToken() returned false!".equals(((Throwable)((Object)ae)).getMessage())) break block35;
                        throw ae;
                    }
                }
                ts.close();
            } else if (evilness == 7) {
                block36: {
                    int numTokensToRead = random.nextInt(tokens.size());
                    if (VERBOSE) {
                        System.out.println(Thread.currentThread().getName() + ": NOTE: BaseTokenStreamTestCase: re-run analysis, only consuming " + numTokensToRead + " of " + tokens.size() + " tokens");
                    }
                    reader = new StringReader(text);
                    ts = a.tokenStream("dummy", (Reader)(useCharFilter ? new MockCharFilter(reader, remainder) : reader));
                    ts.reset();
                    for (int tokenCount = 0; tokenCount < numTokensToRead; ++tokenCount) {
                        BaseTokenStreamTestCase.assertTrue((boolean)ts.incrementToken());
                    }
                    try {
                        ts.end();
                    }
                    catch (AssertionError ae) {
                        if ("end() called before incrementToken() returned false!".equals(((Throwable)((Object)ae)).getMessage())) break block36;
                        throw ae;
                    }
                }
                ts.close();
            }
        }
        if (VERBOSE) {
            System.out.println(Thread.currentThread().getName() + ": NOTE: BaseTokenStreamTestCase: re-run analysis; " + tokens.size() + " tokens");
        }
        reader = new StringReader(text);
        long seed = random.nextLong();
        if ((random = new Random(seed)).nextInt(30) == 7) {
            if (VERBOSE) {
                System.out.println(Thread.currentThread().getName() + ": NOTE: BaseTokenStreamTestCase: using spoon-feed reader");
            }
            reader = new MockReaderWrapper(random, reader);
        }
        ts = a.tokenStream("dummy", (Reader)(useCharFilter ? new MockCharFilter(reader, remainder) : reader));
        if (typeAtt != null && posIncAtt != null && posLengthAtt != null && offsetAtt != null) {
            BaseTokenStreamTestCase.assertTokenStreamContents(ts, tokens.toArray(new String[tokens.size()]), BaseTokenStreamTestCase.toIntArray(startOffsets), BaseTokenStreamTestCase.toIntArray(endOffsets), types.toArray(new String[types.size()]), BaseTokenStreamTestCase.toIntArray(positions), BaseTokenStreamTestCase.toIntArray(positionLengths), text.length(), offsetsAreCorrect);
        } else if (typeAtt != null && posIncAtt != null && offsetAtt != null) {
            BaseTokenStreamTestCase.assertTokenStreamContents(ts, tokens.toArray(new String[tokens.size()]), BaseTokenStreamTestCase.toIntArray(startOffsets), BaseTokenStreamTestCase.toIntArray(endOffsets), types.toArray(new String[types.size()]), BaseTokenStreamTestCase.toIntArray(positions), null, text.length(), offsetsAreCorrect);
        } else if (posIncAtt != null && posLengthAtt != null && offsetAtt != null) {
            BaseTokenStreamTestCase.assertTokenStreamContents(ts, tokens.toArray(new String[tokens.size()]), BaseTokenStreamTestCase.toIntArray(startOffsets), BaseTokenStreamTestCase.toIntArray(endOffsets), null, BaseTokenStreamTestCase.toIntArray(positions), BaseTokenStreamTestCase.toIntArray(positionLengths), text.length(), offsetsAreCorrect);
        } else if (posIncAtt != null && offsetAtt != null) {
            BaseTokenStreamTestCase.assertTokenStreamContents(ts, tokens.toArray(new String[tokens.size()]), BaseTokenStreamTestCase.toIntArray(startOffsets), BaseTokenStreamTestCase.toIntArray(endOffsets), null, BaseTokenStreamTestCase.toIntArray(positions), null, text.length(), offsetsAreCorrect);
        } else if (offsetAtt != null) {
            BaseTokenStreamTestCase.assertTokenStreamContents(ts, tokens.toArray(new String[tokens.size()]), BaseTokenStreamTestCase.toIntArray(startOffsets), BaseTokenStreamTestCase.toIntArray(endOffsets), null, null, null, text.length(), offsetsAreCorrect);
        } else {
            BaseTokenStreamTestCase.assertTokenStreamContents(ts, tokens.toArray(new String[tokens.size()]));
        }
        if (field != null) {
            reader = new StringReader(text);
            random = new Random(seed);
            if (random.nextInt(30) == 7) {
                if (VERBOSE) {
                    System.out.println(Thread.currentThread().getName() + ": NOTE: BaseTokenStreamTestCase: indexing using spoon-feed reader");
                }
                reader = new MockReaderWrapper(random, reader);
            }
            field.setReaderValue((Reader)(useCharFilter ? new MockCharFilter(reader, remainder) : reader));
        }
    }

    private static String randomAnalysisString(Random random, int maxLength, boolean simple) {
        assert (maxLength >= 0);
        if (random.nextInt(31) == 0) {
            return BaseTokenStreamTestCase.randomSubString(random, random.nextInt(maxLength), simple);
        }
        maxLength = random.nextInt(maxLength);
        int avgWordLength = _TestUtil.nextInt(random, 3, 8);
        StringBuilder sb = new StringBuilder();
        while (sb.length() < maxLength) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            int wordLength = -1;
            while (wordLength < 0) {
                wordLength = (int)(random.nextGaussian() * 3.0 + (double)avgWordLength);
            }
            wordLength = Math.min(wordLength, maxLength - sb.length());
            sb.append(BaseTokenStreamTestCase.randomSubString(random, wordLength, simple));
        }
        return sb.toString();
    }

    private static String randomSubString(Random random, int wordLength, boolean simple) {
        if (wordLength == 0) {
            return "";
        }
        int evilness = _TestUtil.nextInt(random, 0, 20);
        StringBuilder sb = new StringBuilder();
        while (sb.length() < wordLength) {
            if (simple) {
                sb.append(random.nextBoolean() ? _TestUtil.randomSimpleString(random, wordLength) : _TestUtil.randomHtmlishString(random, wordLength));
                continue;
            }
            if (evilness < 10) {
                sb.append(_TestUtil.randomSimpleString(random, wordLength));
                continue;
            }
            if (evilness < 15) {
                assert (sb.length() == 0);
                sb.append(_TestUtil.randomRealisticUnicodeString(random, wordLength, wordLength));
                continue;
            }
            if (evilness == 16) {
                sb.append(_TestUtil.randomHtmlishString(random, wordLength));
                continue;
            }
            if (evilness == 17) {
                sb.append(_TestUtil.randomRegexpishString(random, wordLength));
                continue;
            }
            sb.append(_TestUtil.randomUnicodeString(random, wordLength));
        }
        if (sb.length() > wordLength) {
            sb.setLength(wordLength);
            if (Character.isHighSurrogate(sb.charAt(wordLength - 1))) {
                sb.setLength(wordLength - 1);
            }
        }
        if (random.nextInt(17) == 0) {
            String mixedUp = _TestUtil.randomlyRecaseCodePoints(random, sb.toString());
            assert (mixedUp.length() == sb.length());
            return mixedUp;
        }
        return sb.toString();
    }

    protected String toDot(Analyzer a, String inputText) throws IOException {
        StringWriter sw = new StringWriter();
        TokenStream ts = a.tokenStream("field", inputText);
        ts.reset();
        new TokenStreamToDot(inputText, ts, new PrintWriter(sw)).toDot();
        return sw.toString();
    }

    protected void toDotFile(Analyzer a, String inputText, String localFileName) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(localFileName), "UTF-8");
        TokenStream ts = a.tokenStream("field", inputText);
        ts.reset();
        new TokenStreamToDot(inputText, ts, new PrintWriter(w)).toDot();
        ((Writer)w).close();
    }

    static int[] toIntArray(List<Integer> list) {
        int[] ret = new int[list.size()];
        int offset = 0;
        for (Integer i : list) {
            ret[offset++] = i;
        }
        return ret;
    }

    static class AnalysisThread
    extends Thread {
        final int iterations;
        final int maxWordLength;
        final long seed;
        final Analyzer a;
        final boolean useCharFilter;
        final boolean simple;
        final boolean offsetsAreCorrect;
        final RandomIndexWriter iw;
        public boolean failed;

        AnalysisThread(long seed, Analyzer a, int iterations, int maxWordLength, boolean useCharFilter, boolean simple, boolean offsetsAreCorrect, RandomIndexWriter iw) {
            this.seed = seed;
            this.a = a;
            this.iterations = iterations;
            this.maxWordLength = maxWordLength;
            this.useCharFilter = useCharFilter;
            this.simple = simple;
            this.offsetsAreCorrect = offsetsAreCorrect;
            this.iw = iw;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean success = false;
            try {
                BaseTokenStreamTestCase.checkRandomData(new Random(this.seed), this.a, this.iterations, this.maxWordLength, this.useCharFilter, this.simple, this.offsetsAreCorrect, this.iw);
                success = true;
                this.failed = !success;
            }
            catch (IOException e) {
                try {
                    Rethrow.rethrow(e);
                    this.failed = !success;
                }
                catch (Throwable throwable) {
                    this.failed = !success;
                    throw throwable;
                }
            }
        }
    }

    public static final class CheckClearAttributesAttributeImpl
    extends AttributeImpl
    implements CheckClearAttributesAttribute {
        private boolean clearCalled = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getAndResetClearCalled() {
            try {
                boolean bl = this.clearCalled;
                return bl;
            }
            finally {
                this.clearCalled = false;
            }
        }

        public void clear() {
            this.clearCalled = true;
        }

        public boolean equals(Object other) {
            return other instanceof CheckClearAttributesAttributeImpl && ((CheckClearAttributesAttributeImpl)other).clearCalled == this.clearCalled;
        }

        public int hashCode() {
            return 0x489C2FD ^ Boolean.valueOf(this.clearCalled).hashCode();
        }

        public void copyTo(AttributeImpl target) {
            ((CheckClearAttributesAttributeImpl)target).clear();
        }
    }

    public static interface CheckClearAttributesAttribute
    extends Attribute {
        public boolean getAndResetClearCalled();
    }
}

