/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.maven.api.xml.Dom;
import org.apache.maven.internal.xml.Xpp3Dom;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Xpp3DomBuilder {
    private static final boolean DEFAULT_TRIM = true;

    public static Xpp3Dom build(Reader reader) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(reader, null);
    }

    public static Xpp3Dom build(Reader reader, InputLocationBuilder locationBuilder) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(reader, true, locationBuilder);
    }

    public static Xpp3Dom build(InputStream is, String encoding) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(is, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xpp3Dom build(InputStream is, String encoding, boolean trim) throws XmlPullParserException, IOException {
        try {
            MXParser parser = new MXParser();
            parser.setInput(is, encoding);
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build(parser, trim);
            is.close();
            is = null;
            Xpp3Dom xpp3Dom2 = xpp3Dom;
            return xpp3Dom2;
        }
        finally {
            IOUtil.close(is);
        }
    }

    public static Xpp3Dom build(Reader reader, boolean trim) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(reader, trim, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xpp3Dom build(Reader reader, boolean trim, InputLocationBuilder locationBuilder) throws XmlPullParserException, IOException {
        try {
            MXParser parser = new MXParser();
            parser.setInput(reader);
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build(parser, trim, locationBuilder);
            reader.close();
            reader = null;
            Xpp3Dom xpp3Dom2 = xpp3Dom;
            return xpp3Dom2;
        }
        finally {
            IOUtil.close(reader);
        }
    }

    public static Xpp3Dom build(XmlPullParser parser) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(parser, true);
    }

    public static Xpp3Dom build(XmlPullParser parser, boolean trim) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(parser, trim, null);
    }

    public static Xpp3Dom build(XmlPullParser parser, boolean trim, InputLocationBuilder locationBuilder) throws XmlPullParserException, IOException {
        boolean spacePreserve = false;
        String name = null;
        String value = null;
        Object location = null;
        HashMap<String, String> attrs = null;
        ArrayList<Dom> children = null;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (name == null) {
                    name = parser.getName();
                    location = locationBuilder != null ? locationBuilder.toInputLocation(parser) : null;
                    int attributesSize = parser.getAttributeCount();
                    if (attributesSize > 0) {
                        attrs = new HashMap<String, String>();
                        for (int i = 0; i < attributesSize; ++i) {
                            String aname = parser.getAttributeName(i);
                            String avalue = parser.getAttributeValue(i);
                            attrs.put(aname, avalue);
                            spacePreserve = spacePreserve || "xml:space".equals(aname) && "preserve".equals(avalue);
                        }
                    }
                } else {
                    if (children == null) {
                        children = new ArrayList<Dom>();
                    }
                    Xpp3Dom child = Xpp3DomBuilder.build(parser, trim, locationBuilder);
                    children.add(child);
                }
            } else if (eventType == 4) {
                String text = parser.getText();
                if (trim && !spacePreserve) {
                    text = text.trim();
                }
                value = value != null ? value + text : text;
            } else if (eventType == 3) {
                return new Xpp3Dom(name, children == null ? value : null, attrs, children, location);
            }
            eventType = parser.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }

    public static interface InputLocationBuilder {
        public Object toInputLocation(XmlPullParser var1);
    }
}

