/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Site
implements Serializable,
InputLocationTracker {
    final String id;
    final String name;
    final String url;
    final String childSiteUrlInheritAppendPath;
    final InputLocation location;
    final InputLocation idLocation;
    final InputLocation nameLocation;
    final InputLocation urlLocation;
    final InputLocation childSiteUrlInheritAppendPathLocation;
    final Map<Object, InputLocation> locations;

    Site(String id, String name, String url, String childSiteUrlInheritAppendPath, Map<Object, InputLocation> locations, InputLocation location, InputLocation idLocation, InputLocation nameLocation, InputLocation urlLocation, InputLocation childSiteUrlInheritAppendPathLocation) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.childSiteUrlInheritAppendPath = childSiteUrlInheritAppendPath;
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.idLocation = idLocation;
        this.nameLocation = nameLocation;
        this.urlLocation = urlLocation;
        this.childSiteUrlInheritAppendPathLocation = childSiteUrlInheritAppendPathLocation;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getChildSiteUrlInheritAppendPath() {
        return this.childSiteUrlInheritAppendPath;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "id": {
                    return this.idLocation;
                }
                case "name": {
                    return this.nameLocation;
                }
                case "url": {
                    return this.urlLocation;
                }
                case "childSiteUrlInheritAppendPath": {
                    return this.childSiteUrlInheritAppendPathLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Site.newBuilder(this);
    }

    @Nonnull
    public Site withId(String id) {
        return this.with().id(id).build();
    }

    @Nonnull
    public Site withName(String name) {
        return this.with().name(name).build();
    }

    @Nonnull
    public Site withUrl(String url) {
        return this.with().url(url).build();
    }

    @Nonnull
    public Site withChildSiteUrlInheritAppendPath(String childSiteUrlInheritAppendPath) {
        return this.with().childSiteUrlInheritAppendPath(childSiteUrlInheritAppendPath).build();
    }

    @Nonnull
    public static Site newInstance() {
        return Site.newInstance(true);
    }

    @Nonnull
    public static Site newInstance(boolean withDefaults) {
        return Site.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Site.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Site from) {
        return Site.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Site from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isChildSiteUrlInheritAppendPath() {
        return this.getChildSiteUrlInheritAppendPath() != null ? Boolean.parseBoolean(this.getChildSiteUrlInheritAppendPath()) : true;
    }

    @NotThreadSafe
    public static class Builder {
        Site base;
        String id;
        String name;
        String url;
        String childSiteUrlInheritAppendPath;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Site base, boolean forceCopy) {
            if (forceCopy) {
                this.id = base.id;
                this.name = base.name;
                this.url = base.url;
                this.childSiteUrlInheritAppendPath = base.childSiteUrlInheritAppendPath;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder childSiteUrlInheritAppendPath(String childSiteUrlInheritAppendPath) {
            this.childSiteUrlInheritAppendPath = childSiteUrlInheritAppendPath;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Site build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.childSiteUrlInheritAppendPath != null && this.childSiteUrlInheritAppendPath != this.base.childSiteUrlInheritAppendPath)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation idLocation = null;
            InputLocation nameLocation = null;
            InputLocation urlLocation = null;
            InputLocation childSiteUrlInheritAppendPathLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                idLocation = locations.remove("id");
                nameLocation = locations.remove("name");
                urlLocation = locations.remove("url");
                childSiteUrlInheritAppendPathLocation = locations.remove("childSiteUrlInheritAppendPath");
            }
            return new Site(this.id != null ? this.id : (this.base != null ? this.base.id : null), this.name != null ? this.name : (this.base != null ? this.base.name : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.childSiteUrlInheritAppendPath != null ? this.childSiteUrlInheritAppendPath : (this.base != null ? this.base.childSiteUrlInheritAppendPath : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), idLocation != null ? idLocation : (this.base != null ? this.base.idLocation : null), nameLocation != null ? nameLocation : (this.base != null ? this.base.nameLocation : null), urlLocation != null ? urlLocation : (this.base != null ? this.base.urlLocation : null), childSiteUrlInheritAppendPathLocation != null ? childSiteUrlInheritAppendPathLocation : (this.base != null ? this.base.childSiteUrlInheritAppendPathLocation : null));
        }
    }
}

