/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

class PropertiesAsMap
extends AbstractMap<String, String> {
    private final Map<Object, Object> properties;

    PropertiesAsMap(Map<Object, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new AbstractSet<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                final Iterator iterator = PropertiesAsMap.this.properties.entrySet().iterator();
                return new Iterator<Map.Entry<String, String>>(){
                    Map.Entry<Object, Object> next;

                    @Override
                    public boolean hasNext() {
                        while (this.next == null && iterator.hasNext()) {
                            Map.Entry e = (Map.Entry)iterator.next();
                            if (!PropertiesAsMap.matches(e)) continue;
                            this.next = e;
                            break;
                        }
                        return this.next != null;
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        return new Map.Entry<String, String>(){

                            @Override
                            public String getKey() {
                                return (String)next.getKey();
                            }

                            @Override
                            public String getValue() {
                                return (String)next.getValue();
                            }

                            @Override
                            public String setValue(String value) {
                                return (String)next.setValue(value);
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return (int)PropertiesAsMap.this.properties.entrySet().stream().filter(x$0 -> PropertiesAsMap.matches(x$0)).count();
            }
        };
    }

    private static boolean matches(Map.Entry<Object, Object> entry) {
        return entry.getKey() instanceof String && entry.getValue() instanceof String;
    }
}

