/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactsCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceRepository;

@Named
@Singleton
public class DefaultProjectArtifactsCache
implements ProjectArtifactsCache {
    protected final Map<ProjectArtifactsCache.Key, ProjectArtifactsCache.CacheRecord> cache = new ConcurrentHashMap<ProjectArtifactsCache.Key, ProjectArtifactsCache.CacheRecord>();

    @Override
    public ProjectArtifactsCache.Key createKey(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating, RepositorySystemSession session) {
        return new CacheKey(project, project.getRemoteProjectRepositories(), scopesToCollect, scopesToResolve, aggregating, session);
    }

    @Override
    public ProjectArtifactsCache.CacheRecord get(ProjectArtifactsCache.Key key) throws LifecycleExecutionException {
        ProjectArtifactsCache.CacheRecord cacheRecord = this.cache.get(key);
        if (cacheRecord != null && cacheRecord.getException() != null) {
            throw cacheRecord.getException();
        }
        return cacheRecord;
    }

    @Override
    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key, Set<Artifact> projectArtifacts) {
        Objects.requireNonNull(projectArtifacts, "projectArtifacts cannot be null");
        this.assertUniqueKey(key);
        ProjectArtifactsCache.CacheRecord record = new ProjectArtifactsCache.CacheRecord(Collections.unmodifiableSet(new LinkedHashSet<Artifact>(projectArtifacts)));
        this.cache.put(key, record);
        return record;
    }

    protected void assertUniqueKey(ProjectArtifactsCache.Key key) {
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("Duplicate artifact resolution result for project " + key);
        }
    }

    @Override
    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key, LifecycleExecutionException exception) {
        Objects.requireNonNull(exception, "exception cannot be null");
        this.assertUniqueKey(key);
        ProjectArtifactsCache.CacheRecord record = new ProjectArtifactsCache.CacheRecord(exception);
        this.cache.put(key, record);
        return record;
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    @Override
    public void register(MavenProject project, ProjectArtifactsCache.Key cacheKey, ProjectArtifactsCache.CacheRecord record) {
    }

    protected static class CacheKey
    implements ProjectArtifactsCache.Key {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final Set<String> dependencyArtifacts;
        private final WorkspaceRepository workspace;
        private final LocalRepository localRepo;
        private final List<RemoteRepository> repositories;
        private final Set<String> collect;
        private final Set<String> resolve;
        private boolean aggregating;
        private final int hashCode;

        public CacheKey(MavenProject project, List<RemoteRepository> repositories, Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating, RepositorySystemSession session) {
            this.groupId = project.getGroupId();
            this.artifactId = project.getArtifactId();
            this.version = project.getVersion();
            LinkedHashSet<String> deps = new LinkedHashSet<String>();
            if (project.getDependencyArtifacts() != null) {
                for (Artifact dep : project.getDependencyArtifacts()) {
                    deps.add(dep.toString());
                }
            }
            this.dependencyArtifacts = Collections.unmodifiableSet(deps);
            this.workspace = RepositoryUtils.getWorkspace(session);
            this.localRepo = session.getLocalRepository();
            this.repositories = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.collect = scopesToCollect == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scopesToCollect));
            this.resolve = scopesToResolve == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scopesToResolve));
            this.aggregating = aggregating;
            int hash = 17;
            hash = hash * 31 + Objects.hashCode(this.groupId);
            hash = hash * 31 + Objects.hashCode(this.artifactId);
            hash = hash * 31 + Objects.hashCode(this.version);
            hash = hash * 31 + Objects.hashCode(this.dependencyArtifacts);
            hash = hash * 31 + Objects.hashCode(this.workspace);
            hash = hash * 31 + Objects.hashCode(this.localRepo);
            hash = hash * 31 + RepositoryUtils.repositoriesHashCode(repositories);
            hash = hash * 31 + Objects.hashCode(this.collect);
            hash = hash * 31 + Objects.hashCode(this.resolve);
            this.hashCode = hash = hash * 31 + Objects.hashCode(aggregating);
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.dependencyArtifacts, that.dependencyArtifacts) && Objects.equals(this.workspace, that.workspace) && Objects.equals(this.localRepo, that.localRepo) && RepositoryUtils.repositoriesEquals(this.repositories, that.repositories) && Objects.equals(this.collect, that.collect) && Objects.equals(this.resolve, that.resolve) && this.aggregating == that.aggregating;
        }
    }
}

