/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryPolicy;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Profile;
import org.apache.maven.settings.merge.MavenSettingsMerger;

public final class SettingsUtils {
    private SettingsUtils() {
    }

    public static Settings merge(Settings dominant, Settings recessive, String recessiveSourceLevel) {
        return new MavenSettingsMerger().merge(dominant, recessive, recessiveSourceLevel);
    }

    public static org.apache.maven.api.settings.Profile convertToSettingsProfile(Profile modelProfile) {
        List pluginRepos;
        Profile.Builder profile = org.apache.maven.api.settings.Profile.newBuilder();
        profile.id(modelProfile.getId());
        Activation modelActivation = modelProfile.getActivation();
        if (modelActivation != null) {
            org.apache.maven.model.ActivationFile modelFile;
            Object modelOs;
            Activation.Builder activation = org.apache.maven.api.settings.Activation.newBuilder();
            activation.activeByDefault(modelActivation.isActiveByDefault());
            activation.jdk(modelActivation.getJdk());
            org.apache.maven.model.ActivationProperty modelProp = modelActivation.getProperty();
            if (modelProp != null) {
                org.apache.maven.api.settings.ActivationProperty prop = org.apache.maven.api.settings.ActivationProperty.newBuilder().name(modelProp.getName()).value(modelProp.getValue()).build();
                activation.property(prop);
            }
            if ((modelOs = modelActivation.getOs()) != null) {
                ActivationOS os = ActivationOS.newBuilder().arch(modelOs.getArch()).family(modelOs.getFamily()).name(modelOs.getName()).version(modelOs.getVersion()).build();
                activation.os(os);
            }
            if ((modelFile = modelActivation.getFile()) != null) {
                ActivationFile file = ActivationFile.newBuilder().exists(modelFile.getExists()).missing(modelFile.getMissing()).build();
                activation.file(file);
            }
            profile.activation(activation.build());
        }
        profile.properties(modelProfile.getProperties().entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString())));
        List repos = modelProfile.getRepositories();
        if (repos != null) {
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            for (org.apache.maven.model.Repository repo : repos) {
                repositories.add(SettingsUtils.convertToSettingsRepository(repo));
            }
            profile.repositories(repositories);
        }
        if ((pluginRepos = modelProfile.getPluginRepositories()) != null) {
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            for (org.apache.maven.model.Repository pluginRepo : pluginRepos) {
                repositories.add(SettingsUtils.convertToSettingsRepository(pluginRepo));
            }
            profile.pluginRepositories(repositories);
        }
        return profile.build();
    }

    public static Profile convertFromSettingsProfile(org.apache.maven.api.settings.Profile settingsProfile) {
        List pluginRepos;
        Profile.Builder profile = org.apache.maven.api.model.Profile.newBuilder();
        profile.id(settingsProfile.getId());
        org.apache.maven.api.settings.Activation settingsActivation = settingsProfile.getActivation();
        if (settingsActivation != null) {
            ActivationFile settingsFile;
            ActivationOS settingsOs;
            Activation.Builder activation = org.apache.maven.api.model.Activation.newBuilder();
            activation.activeByDefault(settingsActivation.isActiveByDefault());
            activation.jdk(settingsActivation.getJdk());
            org.apache.maven.api.settings.ActivationProperty settingsProp = settingsActivation.getProperty();
            if (settingsProp != null) {
                activation.property(ActivationProperty.newBuilder().name(settingsProp.getName()).value(settingsProp.getValue()).build());
            }
            if ((settingsOs = settingsActivation.getOs()) != null) {
                activation.os(org.apache.maven.api.model.ActivationOS.newBuilder().arch(settingsOs.getArch()).family(settingsOs.getFamily()).name(settingsOs.getName()).version(settingsOs.getVersion()).build());
            }
            if ((settingsFile = settingsActivation.getFile()) != null) {
                activation.file(org.apache.maven.api.model.ActivationFile.newBuilder().exists(settingsFile.getExists()).missing(settingsFile.getMissing()).build());
            }
            profile.activation(activation.build());
        }
        profile.properties(settingsProfile.getProperties());
        List repos = settingsProfile.getRepositories();
        if (repos != null) {
            profile.repositories((Collection)repos.stream().map(SettingsUtils::convertFromSettingsRepository).collect(Collectors.toList()));
        }
        if ((pluginRepos = settingsProfile.getPluginRepositories()) != null) {
            profile.pluginRepositories((Collection)pluginRepos.stream().map(SettingsUtils::convertFromSettingsRepository).collect(Collectors.toList()));
        }
        Profile value = new Profile(profile.build());
        value.setSource("settings.xml");
        return value;
    }

    private static org.apache.maven.api.model.Repository convertFromSettingsRepository(Repository settingsRepo) {
        Repository.Builder repo = org.apache.maven.api.model.Repository.newBuilder();
        repo.id(settingsRepo.getId());
        repo.layout(settingsRepo.getLayout());
        repo.name(settingsRepo.getName());
        repo.url(settingsRepo.getUrl());
        if (settingsRepo.getSnapshots() != null) {
            repo.snapshots(SettingsUtils.convertRepositoryPolicy(settingsRepo.getSnapshots()));
        }
        if (settingsRepo.getReleases() != null) {
            repo.releases(SettingsUtils.convertRepositoryPolicy(settingsRepo.getReleases()));
        }
        return repo.build();
    }

    private static RepositoryPolicy convertRepositoryPolicy(org.apache.maven.api.settings.RepositoryPolicy settingsPolicy) {
        RepositoryPolicy policy = RepositoryPolicy.newBuilder().enabled(Boolean.toString(settingsPolicy.isEnabled())).updatePolicy(settingsPolicy.getUpdatePolicy()).checksumPolicy(settingsPolicy.getChecksumPolicy()).build();
        return policy;
    }

    private static Repository convertToSettingsRepository(org.apache.maven.model.Repository modelRepo) {
        Repository repo = Repository.newBuilder().id(modelRepo.getId()).layout(modelRepo.getLayout()).name(modelRepo.getName()).url(modelRepo.getUrl()).snapshots(modelRepo.getSnapshots() != null ? SettingsUtils.convertRepositoryPolicy(modelRepo.getSnapshots()) : null).releases(modelRepo.getReleases() != null ? SettingsUtils.convertRepositoryPolicy(modelRepo.getReleases()) : null).build();
        return repo;
    }

    private static org.apache.maven.api.settings.RepositoryPolicy convertRepositoryPolicy(org.apache.maven.model.RepositoryPolicy modelPolicy) {
        org.apache.maven.api.settings.RepositoryPolicy policy = org.apache.maven.api.settings.RepositoryPolicy.newBuilder().enabled(modelPolicy.isEnabled()).updatePolicy(modelPolicy.getUpdatePolicy()).checksumPolicy(modelPolicy.getUpdatePolicy()).build();
        return policy;
    }
}

