/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.ImmutableCollections;
import org.apache.maven.api.settings.Repository;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Profile
extends IdentifiableBase
implements Serializable {
    final Activation activation;
    final Map<String, String> properties;
    final List<Repository> repositories;
    final List<Repository> pluginRepositories;

    Profile(String id, Activation activation, Map<String, String> properties, Collection<Repository> repositories, Collection<Repository> pluginRepositories) {
        super(id);
        this.activation = activation;
        this.properties = ImmutableCollections.copy(properties);
        this.repositories = ImmutableCollections.copy(repositories);
        this.pluginRepositories = ImmutableCollections.copy(pluginRepositories);
    }

    public Activation getActivation() {
        return this.activation;
    }

    @Nonnull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Nonnull
    public List<Repository> getRepositories() {
        return this.repositories;
    }

    @Nonnull
    public List<Repository> getPluginRepositories() {
        return this.pluginRepositories;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Profile.newBuilder(this);
    }

    @Override
    @Nonnull
    public Profile withId(String id) {
        return Profile.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public Profile withActivation(Activation activation) {
        return Profile.newBuilder(this, true).activation(activation).build();
    }

    @Nonnull
    public Profile withProperties(Map<String, String> properties) {
        return Profile.newBuilder(this, true).properties(properties).build();
    }

    @Nonnull
    public Profile withRepositories(Collection<Repository> repositories) {
        return Profile.newBuilder(this, true).repositories(repositories).build();
    }

    @Nonnull
    public Profile withPluginRepositories(Collection<Repository> pluginRepositories) {
        return Profile.newBuilder(this, true).pluginRepositories(pluginRepositories).build();
    }

    @Nonnull
    public static Profile newInstance() {
        return Profile.newInstance(true);
    }

    @Nonnull
    public static Profile newInstance(boolean withDefaults) {
        return Profile.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Profile.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Profile from) {
        return Profile.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Profile from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends IdentifiableBase.Builder {
        Profile base;
        Activation activation;
        Map<String, String> properties;
        Collection<Repository> repositories;
        Collection<Repository> pluginRepositories;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Profile base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.activation = base.activation;
                this.properties = base.properties;
                this.repositories = base.repositories;
                this.pluginRepositories = base.pluginRepositories;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder activation(Activation activation) {
            this.activation = activation;
            return this;
        }

        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder repositories(Collection<Repository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public Builder pluginRepositories(Collection<Repository> pluginRepositories) {
            this.pluginRepositories = pluginRepositories;
            return this;
        }

        @Override
        @Nonnull
        public Profile build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.activation != null && this.activation != this.base.activation || this.properties != null && this.properties != this.base.properties || this.repositories != null && this.repositories != this.base.repositories || this.pluginRepositories != null && this.pluginRepositories != this.base.pluginRepositories)) {
                return this.base;
            }
            return new Profile(this.id != null ? this.id : (this.base != null ? this.base.id : null), this.activation != null ? this.activation : (this.base != null ? this.base.activation : null), this.properties != null ? this.properties : (this.base != null ? this.base.properties : null), this.repositories != null ? this.repositories : (this.base != null ? this.base.repositories : null), this.pluginRepositories != null ? this.pluginRepositories : (this.base != null ? this.base.pluginRepositories : null));
        }
    }
}

