/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.internal.extension.io;

import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.internal.extension.model.CoreExtensions;

@Generated
public class CoreExtensionsStaxWriter {
    private static final String NAMESPACE = "http://maven.apache.org/EXTENSIONS/1.1.0";
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, CoreExtensions coreExtensions) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        XMLStreamWriter serializer = factory.createXMLStreamWriter(writer);
        serializer.writeStartDocument(coreExtensions.getModelEncoding(), null);
        this.writeCoreExtensions("extensions", coreExtensions, serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, CoreExtensions coreExtensions) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        XMLStreamWriter serializer = factory.createXMLStreamWriter(stream, coreExtensions.getModelEncoding());
        serializer.writeStartDocument(coreExtensions.getModelEncoding(), null);
        this.writeCoreExtensions("extensions", coreExtensions, serializer);
        serializer.writeEndDocument();
    }

    protected void writeDomToSerializer(XmlNode dom, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        serializer.writeStartElement(NAMESPACE, dom.getName());
        for (Map.Entry attribute : dom.getAttributes().entrySet()) {
            serializer.writeAttribute(NAMESPACE, (String)attribute.getKey(), (String)attribute.getValue());
        }
        for (XmlNode aChild : dom.getChildren()) {
            this.writeDomToSerializer(aChild, serializer);
        }
        String value = dom.getValue();
        if (value != null) {
            serializer.writeCharacters(value);
        }
        serializer.writeEndElement();
    }

    private void writeCoreExtensions(String tagName, CoreExtensions coreExtensions, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (coreExtensions != null) {
            if (this.fileComment != null) {
                serializer.writeComment(this.fileComment);
            }
            serializer.writeStartElement("", tagName, NAMESPACE);
            serializer.writeNamespace("", NAMESPACE);
            serializer.writeNamespace("xsi", XSI_NAMESPACE);
            serializer.writeAttribute(XSI_NAMESPACE, "schemaLocation", "http://maven.apache.org/EXTENSIONS/1.1.0 http://maven.apache.org/xsd/core-extensions-1.1.0.xsd");
            this.writeList("extensions", true, coreExtensions.getExtensions(), serializer, t -> this.writeCoreExtension("extension", (CoreExtension)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeCoreExtension(String tagName, CoreExtension coreExtension, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (coreExtension != null) {
            serializer.writeStartElement(NAMESPACE, tagName);
            this.writeTag("groupId", null, coreExtension.getGroupId(), serializer);
            this.writeTag("artifactId", null, coreExtension.getArtifactId(), serializer);
            this.writeTag("version", null, coreExtension.getVersion(), serializer);
            this.writeTag("classLoadingStrategy", "self-first", coreExtension.getClassLoadingStrategy(), serializer);
            serializer.writeEndElement();
        }
    }

    private <T> void writeList(String tagName, List<T> list, XMLStreamWriter serializer, ElementWriter<T> writer) throws IOException, XMLStreamException {
        this.writeList(tagName, false, list, serializer, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XMLStreamWriter serializer, ElementWriter<T> writer) throws IOException, XMLStreamException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.writeStartElement(NAMESPACE, tagName);
            }
            boolean index = false;
            for (T t : list) {
                writer.write(t);
            }
            if (!flat) {
                serializer.writeEndElement();
            }
        }
    }

    private <T> void writeProperties(String tagName, Map<String, String> props, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (props != null && !props.isEmpty()) {
            serializer.writeStartElement(NAMESPACE, tagName);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                this.writeTag(key, null, entry.getValue(), serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeDom(XmlNode dom, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dom != null) {
            serializer.writeStartElement(NAMESPACE, dom.getName());
            for (Map.Entry attr : dom.getAttributes().entrySet()) {
                serializer.writeAttribute(NAMESPACE, (String)attr.getKey(), (String)attr.getValue());
            }
            for (XmlNode child : dom.getChildren()) {
                this.writeDom(child, serializer);
            }
            String value = dom.getValue();
            if (value != null) {
                serializer.writeCharacters(value);
            }
            serializer.writeEndElement();
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.writeStartElement(NAMESPACE, tagName);
            serializer.writeCharacters(value);
            serializer.writeEndElement();
        }
    }

    private void writeAttr(String attrName, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null) {
            serializer.writeAttribute(attrName, value);
        }
    }

    @FunctionalInterface
    private static interface ElementWriter<T> {
        public void write(T var1) throws IOException, XMLStreamException;
    }
}

