/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.internal.extension.model;

import java.io.Serializable;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class CoreExtension
implements Serializable {
    final String groupId;
    final String artifactId;
    final String version;
    final String classLoadingStrategy;

    CoreExtension(String groupId, String artifactId, String version, String classLoadingStrategy) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classLoadingStrategy = classLoadingStrategy;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassLoadingStrategy() {
        return this.classLoadingStrategy;
    }

    @Nonnull
    public Builder with() {
        return CoreExtension.newBuilder(this);
    }

    @Nonnull
    public CoreExtension withGroupId(String groupId) {
        return CoreExtension.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public CoreExtension withArtifactId(String artifactId) {
        return CoreExtension.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public CoreExtension withVersion(String version) {
        return CoreExtension.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public CoreExtension withClassLoadingStrategy(String classLoadingStrategy) {
        return CoreExtension.newBuilder(this, true).classLoadingStrategy(classLoadingStrategy).build();
    }

    @Nonnull
    public static CoreExtension newInstance() {
        return CoreExtension.newInstance(true);
    }

    @Nonnull
    public static CoreExtension newInstance(boolean withDefaults) {
        return CoreExtension.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return CoreExtension.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(CoreExtension from) {
        return CoreExtension.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(CoreExtension from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String getId() {
        StringBuilder id = new StringBuilder(128);
        id.append(this.getGroupId() == null ? "[unknown-group-id]" : this.getGroupId());
        id.append(":");
        id.append(this.getArtifactId() == null ? "[unknown-artifact-id]" : this.getArtifactId());
        id.append(":");
        id.append(this.getVersion() == null ? "[unknown-version]" : this.getVersion());
        return id.toString();
    }

    @NotThreadSafe
    public static class Builder {
        CoreExtension base;
        String groupId;
        String artifactId;
        String version;
        String classLoadingStrategy;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.classLoadingStrategy = "self-first";
            }
        }

        Builder(CoreExtension base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.classLoadingStrategy = base.classLoadingStrategy;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder classLoadingStrategy(String classLoadingStrategy) {
            this.classLoadingStrategy = classLoadingStrategy;
            return this;
        }

        @Nonnull
        public CoreExtension build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.classLoadingStrategy != null && this.classLoadingStrategy != this.base.classLoadingStrategy)) {
                return this.base;
            }
            return new CoreExtension(this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.classLoadingStrategy != null ? this.classLoadingStrategy : (this.base != null ? this.base.classLoadingStrategy : null));
        }
    }
}

