/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.FileManager;
import org.apache.maven.jxr.pacman.ImportType;
import org.apache.maven.jxr.pacman.JavaFile;
import org.apache.maven.jxr.pacman.PackageManager;
import org.apache.maven.jxr.pacman.PackageType;
import org.apache.maven.jxr.util.SimpleWordTokenizer;
import org.apache.maven.jxr.util.StringEntry;

public class JavaCodeTransform
implements Serializable {
    public static final boolean LINE_NUMBERS = true;
    public static final String COMMENT_START = "<em class=\"jxr_comment\">";
    public static final String COMMENT_END = "</em>";
    public static final String JAVADOC_COMMENT_START = "<em class=\"jxr_javadoccomment\">";
    public static final String JAVADOC_COMMENT_END = "</em>";
    public static final String STRING_START = "<span class=\"jxr_string\">";
    public static final String STRING_END = "</span>";
    public static final String RESERVED_WORD_START = "<strong class=\"jxr_keyword\">";
    public static final String RESERVED_WORD_END = "</strong>";
    public static final String STYLESHEET_FILENAME = "stylesheet.css";
    public static final String[] VALID_URI_SCHEMES = new String[]{"http://", "mailto:"};
    public static final char[] VALID_URI_CHARS = new char[]{'?', '+', '%', '&', ':', '/', '.', '@', '_', ';', '=', '$', ',', '-', '!', '~', '*', '\'', '(', ')'};
    private Hashtable reservedWords = new Hashtable();
    private boolean inMultiLineComment = false;
    private boolean inJavadocComment = false;
    private String currentFilename = null;
    private String revision = null;
    private String sourcefile = null;
    private String destfile = null;
    private String sourcedir = null;
    private String inputEncoding = null;
    private String outputEncoding = null;
    private Locale locale = null;
    private String javadocLinkDir;
    private PackageManager packageManager;
    private FileManager fileManager;

    public JavaCodeTransform(PackageManager packageManager) {
        this.packageManager = packageManager;
        this.loadHash();
        this.fileManager = packageManager.getFileManager();
    }

    public final String syntaxHighlight(String line) {
        return this.htmlFilter(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader() {
        StringBuffer buffer = new StringBuffer();
        String outputEncoding = this.outputEncoding;
        if (outputEncoding == null) {
            outputEncoding = "ISO-8859-1";
        }
        buffer.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n").append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"").append(this.locale).append("\" lang=\"").append(this.locale).append("\">\n").append("<head>\n").append("<meta http-equiv=\"content-type\" content=\"text/html; charset=").append(outputEncoding).append("\" />\n");
        buffer.append("<title>");
        try {
            JavaFile javaFile = this.fileManager.getFile(this.getCurrentFilename());
            if (javaFile.getClassType() != null && javaFile.getClassType().getFilename() != null) {
                buffer.append(javaFile.getClassType().getFilename());
            } else {
                buffer.append(this.getCurrentFilename());
            }
            buffer.append(" ");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            buffer.append("xref</title>\n");
        }
        buffer.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"").append(this.getPackageRoot()).append(STYLESHEET_FILENAME).append("\" />\n");
        buffer.append("</head>\n").append("<body>\n").append(this.getFileOverview());
        buffer.append("<pre>\n");
        return buffer.toString();
    }

    public final String getFooter() {
        return "</pre>\n<hr/><div id=\"footer\">This page was automatically generated by <a href=\"http://maven.apache.org/\">Maven</a></div></body>\n</html>\n";
    }

    public final void transform(Reader sourceReader, Writer destWriter, Locale locale, String inputEncoding, String outputEncoding, String javadocLinkDir, String revision, boolean showHeader, boolean showFooter) throws IOException {
        this.locale = locale;
        this.inputEncoding = inputEncoding;
        this.outputEncoding = outputEncoding;
        this.javadocLinkDir = javadocLinkDir;
        this.revision = revision;
        BufferedReader in = new BufferedReader(sourceReader);
        PrintWriter out = new PrintWriter(destWriter);
        String line = "";
        if (showHeader) {
            out.println(this.getHeader());
        }
        int linenumber = 1;
        while ((line = in.readLine()) != null) {
            out.print("<a class=\"jxr_linenumber\" name=\"" + linenumber + "\" " + "href=\"#" + linenumber + "\">" + linenumber + "</a>" + this.getLineWidth(linenumber));
            out.println(this.syntaxHighlight(line));
            ++linenumber;
        }
        if (showFooter) {
            out.println(this.getFooter());
        }
        out.flush();
    }

    public final void transform(String sourcefile, String destfile, Locale locale, String inputEncoding, String outputEncoding, String javadocLinkDir, String revision) throws IOException {
        this.setCurrentFilename(sourcefile);
        this.sourcefile = sourcefile;
        this.destfile = destfile;
        new File(new File(destfile).getParent()).mkdirs();
        InputStreamReader fr = null;
        Writer fw = null;
        try {
            fr = inputEncoding != null ? new InputStreamReader((InputStream)new FileInputStream(sourcefile), inputEncoding) : new FileReader(sourcefile);
            fw = outputEncoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(destfile), outputEncoding) : new FileWriter(destfile);
            this.transform(fr, fw, locale, inputEncoding, outputEncoding, javadocLinkDir, revision, true, true);
        }
        catch (RuntimeException e) {
            System.out.println("Unable to processPath " + sourcefile + " => " + destfile);
            throw e;
        }
        finally {
            if (fr != null) {
                try {
                    ((Reader)fr).close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public final String getCurrentFilename() {
        return this.currentFilename;
    }

    public final void setCurrentFilename(String filename) {
        this.currentFilename = filename;
    }

    public final String getPackageRoot() {
        StringBuffer buff = new StringBuffer();
        JavaFile jf = null;
        try {
            jf = this.fileManager.getFile(this.getCurrentFilename());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        String current = jf.getPackageType().getName();
        int count = this.getPackageCount(current);
        for (int i = 0; i < count; ++i) {
            buff.append("../");
        }
        return buff.toString();
    }

    public final String uriFilter(String line) {
        for (int i = 0; i < VALID_URI_SCHEMES.length; ++i) {
            String scheme = VALID_URI_SCHEMES[i];
            int index = line.indexOf(scheme);
            if (index == -1) continue;
            int start = index;
            int end = -1;
            int j = start;
            while (j < line.length()) {
                char current = line.charAt(j);
                if (!Character.isLetterOrDigit(current) && this.isInvalidURICharacter(current)) {
                    end = j;
                    break;
                }
                end = j++;
            }
            if (end == -1) continue;
            String uri = line.substring(start, end);
            line = StringUtils.replace((String)line, (String)uri, (String)("<a href=\"" + uri + "\" target=\"alexandria_uri\">" + uri + "</a>"));
        }
        if (!this.inMultiLineComment && !this.inJavadocComment) {
            return this.jxrFilter(line);
        }
        return line;
    }

    public final String getRevision() {
        return this.revision;
    }

    public final String getSourcefile() {
        return this.sourcefile;
    }

    public final String getDestfile() {
        return this.destfile;
    }

    public final String getSourceDirectory() {
        return this.sourcedir;
    }

    public final String xrLine(String line, String packageName, ClassType classType) {
        StringBuffer buff = new StringBuffer(line);
        String link = null;
        String find = null;
        String href = null;
        if (classType != null) {
            href = this.getHREF(packageName, classType);
            find = classType.getName();
        } else {
            href = this.getHREF(packageName);
            find = packageName;
        }
        String replace = link = "<a href=\"" + href + "\">" + find + "</a>";
        StringEntry[] tokens = SimpleWordTokenizer.tokenize(buff.toString(), find);
        for (int l = 0; l < tokens.length; ++l) {
            int start = tokens[l].getIndex();
            int end = tokens[l].getIndex() + find.length();
            buff.replace(start, end, replace);
        }
        return buff.toString();
    }

    public final String xrLine(String line, String packageName) {
        String href = this.getHREF(packageName);
        String find = packageName;
        String link = "<a href=\"" + href + "\">" + find + "</a>";
        return StringUtils.replace((String)line, (String)find, (String)link);
    }

    private final String htmlFilter(String line) {
        if (line == null || line.equals("")) {
            return "";
        }
        line = this.replace(line, "&", "&amp;");
        line = this.replace(line, "<", "&lt;");
        line = this.replace(line, ">", "&gt;");
        line = this.replace(line, "\\\\", "&#92;&#92;");
        line = this.replace(line, "\\\"", "\\&quot;");
        line = this.replace(line, "'\"'", "'&quot;'");
        return this.multiLineCommentFilter(line);
    }

    private final String multiLineCommentFilter(String line) {
        int index;
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (this.inJavadocComment && (index = line.indexOf("*/")) > -1 && !this.isInsideString(line, index)) {
            this.inJavadocComment = false;
            buf.append(JAVADOC_COMMENT_START);
            buf.append(line.substring(0, index));
            buf.append("*/").append("</em>");
            if (line.length() > index + 2) {
                buf.append(this.inlineCommentFilter(line.substring(index + 2)));
            }
            return this.uriFilter(buf.toString());
        }
        if (this.inMultiLineComment && (index = line.indexOf("*/")) > -1 && !this.isInsideString(line, index)) {
            this.inMultiLineComment = false;
            buf.append(COMMENT_START);
            buf.append(line.substring(0, index));
            buf.append("*/").append("</em>");
            if (line.length() > index + 2) {
                buf.append(this.inlineCommentFilter(line.substring(index + 2)));
            }
            return this.uriFilter(buf.toString());
        }
        if (this.inMultiLineComment) {
            StringBuffer buffer = new StringBuffer(line);
            buffer.insert(0, COMMENT_START);
            buffer.append("</em>");
            return this.uriFilter(buffer.toString());
        }
        if (this.inJavadocComment) {
            StringBuffer buffer = new StringBuffer(line);
            buffer.insert(0, JAVADOC_COMMENT_START);
            buffer.append("</em>");
            return this.uriFilter(buffer.toString());
        }
        index = line.indexOf("/**");
        if (index > -1 && !this.isInsideString(line, index)) {
            this.inJavadocComment = true;
            buf.append(this.inlineCommentFilter(line.substring(0, index)));
            buf.append(JAVADOC_COMMENT_START).append("/**");
            buf.append("</em>");
            buf.append(this.multiLineCommentFilter(line.substring(index + 3)));
            return this.uriFilter(buf.toString());
        }
        index = line.indexOf("/*");
        if (index > -1 && !this.isInsideString(line, index)) {
            this.inMultiLineComment = true;
            buf.append(this.inlineCommentFilter(line.substring(0, index)));
            buf.append(COMMENT_START).append("/*");
            buf.append(this.multiLineCommentFilter(line.substring(index + 2)));
            buf.append("</em>");
            return this.uriFilter(buf.toString());
        }
        return this.inlineCommentFilter(line);
    }

    private final String inlineCommentFilter(String line) {
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int index = line.indexOf("//");
        if (index > -1 && !this.isInsideString(line, index)) {
            buf.append(this.stringFilter(line.substring(0, index)));
            buf.append(COMMENT_START);
            buf.append(line.substring(index));
            buf.append("</em>");
        } else {
            buf.append(this.stringFilter(line));
        }
        return buf.toString();
    }

    private final String stringFilter(String line) {
        int tempIndex;
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (line.indexOf("\"") <= -1) {
            return this.keywordFilter(line);
        }
        int start = 0;
        int startStringIndex = -1;
        int endStringIndex = -1;
        while ((tempIndex = line.indexOf("\"")) > -1) {
            if (startStringIndex == -1) {
                startStringIndex = 0;
                buf.append(this.stringFilter(line.substring(start, tempIndex)));
                buf.append(STRING_START).append("\"");
                line = line.substring(tempIndex + 1);
                continue;
            }
            startStringIndex = -1;
            endStringIndex = tempIndex;
            buf.append(line.substring(0, endStringIndex + 1));
            buf.append(STRING_END);
            line = line.substring(endStringIndex + 1);
        }
        buf.append(this.keywordFilter(line));
        return buf.toString();
    }

    private final String keywordFilter(String line) {
        String CLASS_KEYWORD = "class";
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        StringBuffer temp = new StringBuffer();
        while (i < line.length()) {
            temp.setLength(0);
            char ch = line.charAt(i);
            while (i < line.length() && (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                temp.append(ch);
                if (++i >= line.length()) continue;
                ch = line.charAt(i);
            }
            String tempString = temp.toString();
            if ("class".equals(tempString) && ch == '=') {
                ++i;
                continue;
            }
            if (this.reservedWords.containsKey(tempString)) {
                StringBuffer newLine = new StringBuffer(line.substring(0, i - tempString.length()));
                newLine.append(RESERVED_WORD_START);
                newLine.append(tempString);
                newLine.append(RESERVED_WORD_END);
                newLine.append(line.substring(i));
                line = newLine.toString();
                i += RESERVED_WORD_START.length() + RESERVED_WORD_END.length();
                continue;
            }
            ++i;
        }
        buf.append(line);
        return this.uriFilter(buf.toString());
    }

    private final String replace(String line, String oldString, String newString) {
        int i = 0;
        while ((i = line.indexOf(oldString, i)) >= 0) {
            line = line.substring(0, i) + newString + line.substring(i + oldString.length());
            i += newString.length();
        }
        return line;
    }

    private final boolean isInsideString(String line, int position) {
        int index;
        if (line.indexOf(34) < 0) {
            return false;
        }
        String left = line.substring(0, position);
        String right = line.substring(position);
        int leftCount = 0;
        int rightCount = 0;
        while ((index = left.indexOf(34)) > -1) {
            ++leftCount;
            left = left.substring(index + 1);
        }
        while ((index = right.indexOf(34)) > -1) {
            ++rightCount;
            right = right.substring(index + 1);
        }
        return rightCount % 2 != 0 && leftCount % 2 != 0;
    }

    private final void loadHash() {
        this.reservedWords.put("abstract", "abstract");
        this.reservedWords.put("do", "do");
        this.reservedWords.put("inner", "inner");
        this.reservedWords.put("public", "public");
        this.reservedWords.put("var", "var");
        this.reservedWords.put("boolean", "boolean");
        this.reservedWords.put("continue", "continue");
        this.reservedWords.put("int", "int");
        this.reservedWords.put("return", "return");
        this.reservedWords.put("void", "void");
        this.reservedWords.put("break", "break");
        this.reservedWords.put("else", "else");
        this.reservedWords.put("interface", "interface");
        this.reservedWords.put("short", "short");
        this.reservedWords.put("volatile", "volatile");
        this.reservedWords.put("byvalue", "byvalue");
        this.reservedWords.put("extends", "extends");
        this.reservedWords.put("long", "long");
        this.reservedWords.put("static", "static");
        this.reservedWords.put("while", "while");
        this.reservedWords.put("case", "case");
        this.reservedWords.put("final", "final");
        this.reservedWords.put("native", "native");
        this.reservedWords.put("super", "super");
        this.reservedWords.put("transient", "transient");
        this.reservedWords.put("cast", "cast");
        this.reservedWords.put("float", "float");
        this.reservedWords.put("new", "new");
        this.reservedWords.put("rest", "rest");
        this.reservedWords.put("catch", "catch");
        this.reservedWords.put("for", "for");
        this.reservedWords.put("null", "null");
        this.reservedWords.put("synchronized", "synchronized");
        this.reservedWords.put("char", "char");
        this.reservedWords.put("finally", "finally");
        this.reservedWords.put("operator", "operator");
        this.reservedWords.put("this", "this");
        this.reservedWords.put("class", "class");
        this.reservedWords.put("generic", "generic");
        this.reservedWords.put("outer", "outer");
        this.reservedWords.put("switch", "switch");
        this.reservedWords.put("const", "const");
        this.reservedWords.put("goto", "goto");
        this.reservedWords.put("package", "package");
        this.reservedWords.put("throw", "throw");
        this.reservedWords.put("double", "double");
        this.reservedWords.put("if", "if");
        this.reservedWords.put("private", "private");
        this.reservedWords.put("true", "true");
        this.reservedWords.put("default", "default");
        this.reservedWords.put("import", "import");
        this.reservedWords.put("protected", "protected");
        this.reservedWords.put("try", "try");
        this.reservedWords.put("throws", "throws");
        this.reservedWords.put("implements", "implements");
    }

    final void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    final void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    private final String getFileOverview() {
        StringBuffer overview = new StringBuffer();
        if (this.javadocLinkDir != null) {
            overview.append("<div id=\"overview\">");
            StringBuffer javadocURI = new StringBuffer().append(this.javadocLinkDir);
            try {
                JavaFile jf = this.fileManager.getFile(this.getCurrentFilename());
                javadocURI.append(StringUtils.replace((String)jf.getPackageType().getName(), (String)".", (String)"/"));
                javadocURI.append("/");
                if (jf.getClassType() == null || jf.getClassType().getFilename() == null) {
                    return "";
                }
                javadocURI.append(jf.getClassType().getFilename());
                javadocURI.append(".html");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String javadocHREF = "<a href=\"" + javadocURI + "\">View Javadoc</a>";
            overview.append(javadocHREF);
            overview.append("</div>");
        }
        return overview.toString();
    }

    private final String getLineWidth(int linenumber) {
        if (linenumber < 10) {
            return "   ";
        }
        if (linenumber < 100) {
            return "  ";
        }
        return " ";
    }

    private final String jxrFilter(String line) {
        JavaFile jf = null;
        try {
            if (this.getCurrentFilename() == null) {
                return line;
            }
            jf = this.fileManager.getFile(this.getCurrentFilename());
        }
        catch (IOException e) {
            e.printStackTrace();
            return line;
        }
        Vector<String> v = new Vector<String>();
        ImportType[] imports = jf.getImportTypes();
        for (int j = 0; j < imports.length; ++j) {
            v.addElement(imports[j].getPackage());
        }
        v.addElement(jf.getPackageType().getName());
        Object[] packages = new String[v.size()];
        v.copyInto(packages);
        StringEntry[] words = SimpleWordTokenizer.tokenize(line);
        for (int i = 0; i < words.length; ++i) {
            StringEntry word = words[i];
            for (int j = 0; j < packages.length; ++j) {
                PackageType currentImport = this.packageManager.getPackageType((String)packages[j]);
                if (currentImport == null) continue;
                String wordName = word.toString();
                if (wordName.indexOf(".") != -1) {
                    ClassType ct;
                    String fqpn_package = null;
                    String fqpn_class = null;
                    fqpn_package = wordName.substring(0, wordName.lastIndexOf("."));
                    fqpn_class = wordName.substring(wordName.lastIndexOf(".") + 1, wordName.length());
                    PackageType pt = this.packageManager.getPackageType(fqpn_package);
                    if (pt != null && (ct = pt.getClassType(fqpn_class)) != null) {
                        line = this.xrLine(line, pt.getName(), ct);
                    }
                    if (!fqpn_package.equals(currentImport.getName()) || currentImport.getClassType(fqpn_class) == null) continue;
                    line = this.xrLine(line, (String)packages[j], currentImport.getClassType(fqpn_class));
                    continue;
                }
                if (currentImport.getClassType(wordName) == null) continue;
                line = this.xrLine(line, (String)packages[j], currentImport.getClassType(wordName));
            }
        }
        return this.importFilter(line);
    }

    private final String getHREF(String dest, ClassType jc) {
        StringBuffer href = new StringBuffer();
        href.append(this.getPackageRoot());
        dest = StringUtils.replace((String)dest, (String)".*", (String)"");
        dest = StringUtils.replace((String)dest, (String)".", (String)"/");
        href.append(dest);
        if (jc != null) {
            href.append("/");
            href.append(jc.getFilename());
            href.append(".html");
        }
        return href.toString();
    }

    private final String getHREF(String dest) {
        return this.getHREF(dest, null);
    }

    private final int getPackageCount(String packageName) {
        if (packageName == null) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = packageName.indexOf(46, index)) != -1) {
            ++index;
            ++count;
        }
        return ++count;
    }

    private final String importFilter(String line) {
        int start = -1;
        boolean isPackage = line.trim().startsWith("package ");
        boolean isImport = line.trim().startsWith("import ");
        if (isImport || isPackage) {
            start = line.trim().indexOf(" ");
        }
        if (start != -1) {
            int b;
            String packageLine;
            int a;
            String pkg = line.substring(start, line.length()).trim();
            String classname = null;
            if (pkg.indexOf(".*") != -1) {
                pkg = StringUtils.replace((String)pkg, (String)".*", (String)"");
            } else if (!isPackage && (a = (packageLine = pkg.toString()).lastIndexOf(".") + 1) > (b = packageLine.length() - 1) + 1) {
                classname = packageLine.substring(packageLine.lastIndexOf(".") + 1, packageLine.length() - 1);
                int end = pkg.lastIndexOf(".");
                if (end == -1) {
                    end = pkg.length() - 1;
                }
                pkg = pkg.substring(0, end);
            }
            pkg = StringUtils.replace((String)pkg, (String)";", (String)"");
            String pkgHREF = this.getHREF(pkg);
            if (this.packageManager.getPackageType(pkg) != null || isPackage) {
                if (classname != null) {
                    line = StringUtils.replace((String)line, (String)classname, (String)("<a href=\"" + pkgHREF + "/" + classname + ".html" + "\">" + classname + "</a>"));
                }
                line = StringUtils.replace((String)line, (String)pkg, (String)("<a href=\"" + pkgHREF + "/" + "package-summary.html" + "\">" + pkg + "</a>"));
            }
        }
        return line;
    }

    private final boolean isInvalidURICharacter(char c) {
        for (int i = 0; i < VALID_URI_CHARS.length; ++i) {
            if (VALID_URI_CHARS[i] != c) continue;
            return false;
        }
        return true;
    }
}

