/*
 * $Id$
 */

package org.apache.maven.plugin.lifecycle;

/**
 * A phase mapping definition.
 * 
 * @version $Revision$ $Date$
 */
public class Phase implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field executions
     */
    private java.util.List executions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExecution
     * 
     * @param execution
     */
    public void addExecution(Execution execution)
    {
        getExecutions().add( execution );
    } //-- void addExecution(Execution) 

    /**
     * Method getExecutions
     */
    public java.util.List getExecutions()
    {
        if ( this.executions == null )
        {
            this.executions = new java.util.ArrayList();
        }
        
        return this.executions;
    } //-- java.util.List getExecutions() 

    /**
     * Get The ID of this phase, eg <code>generate-sources</code>.
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method removeExecution
     * 
     * @param execution
     */
    public void removeExecution(Execution execution)
    {
        getExecutions().remove( execution );
    } //-- void removeExecution(Execution) 

    /**
     * Set The goals to execute within the phase.
     * 
     * @param executions
     */
    public void setExecutions(java.util.List executions)
    {
        this.executions = executions;
    } //-- void setExecutions(java.util.List) 

    /**
     * Set The ID of this phase, eg <code>generate-sources</code>.
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
