/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.settings.InputSource;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.SettingsParseException;
import org.apache.maven.settings.io.SettingsReader;
import org.apache.maven.settings.v4.SettingsStaxReader;

@Named
@Singleton
public class DefaultSettingsReader
implements SettingsReader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Settings read(File input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (InputStream in = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            InputSource source = new InputSource(input.toString());
            Settings settings = new Settings(new SettingsStaxReader().read(in, this.isStrict(options), source));
            return settings;
        }
        catch (XMLStreamException e) {
            throw new SettingsParseException(e.getMessage(), e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Settings read(Reader input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (Reader in = input;){
            InputSource source = (InputSource)options.get(InputSource.class.getName());
            Settings settings = new Settings(new SettingsStaxReader().read(in, this.isStrict(options), source));
            return settings;
        }
        catch (XMLStreamException e) {
            throw new SettingsParseException(e.getMessage(), e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Settings read(InputStream input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (InputStream in = input;){
            InputSource source = (InputSource)options.get(InputSource.class.getName());
            Settings settings = new Settings(new SettingsStaxReader().read(in, this.isStrict(options), source));
            return settings;
        }
        catch (XMLStreamException e) {
            throw new SettingsParseException(e.getMessage(), e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("org.apache.maven.settings.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

