/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.v4;

import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.toolchain.PersistedToolchains;
import org.apache.maven.api.toolchain.ToolchainModel;
import org.apache.maven.api.toolchain.TrackableBase;
import org.apache.maven.api.xml.XmlNode;

@Generated
public class MavenToolchainsStaxWriter {
    private static final String NAMESPACE = "http://maven.apache.org/TOOLCHAINS/1.1.0";
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, PersistedToolchains persistedToolchains) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        XMLStreamWriter serializer = factory.createXMLStreamWriter(writer);
        serializer.writeStartDocument(persistedToolchains.getModelEncoding(), null);
        this.writePersistedToolchains("toolchains", persistedToolchains, serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, PersistedToolchains persistedToolchains) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        XMLStreamWriter serializer = factory.createXMLStreamWriter(stream, persistedToolchains.getModelEncoding());
        serializer.writeStartDocument(persistedToolchains.getModelEncoding(), null);
        this.writePersistedToolchains("toolchains", persistedToolchains, serializer);
        serializer.writeEndDocument();
    }

    protected void writeDomToSerializer(XmlNode dom, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        serializer.writeStartElement(NAMESPACE, dom.getName());
        for (Map.Entry attribute : dom.getAttributes().entrySet()) {
            serializer.writeAttribute(NAMESPACE, (String)attribute.getKey(), (String)attribute.getValue());
        }
        for (XmlNode aChild : dom.getChildren()) {
            this.writeDomToSerializer(aChild, serializer);
        }
        String value = dom.getValue();
        if (value != null) {
            serializer.writeCharacters(value);
        }
        serializer.writeEndElement();
    }

    private void writeTrackableBase(String tagName, TrackableBase trackableBase, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (trackableBase != null) {
            serializer.writeStartElement(NAMESPACE, tagName);
            serializer.writeEndElement();
        }
    }

    private void writePersistedToolchains(String tagName, PersistedToolchains persistedToolchains, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (persistedToolchains != null) {
            if (this.fileComment != null) {
                serializer.writeComment(this.fileComment);
            }
            serializer.writeStartElement("", tagName, NAMESPACE);
            serializer.writeNamespace("", NAMESPACE);
            serializer.writeNamespace("xsi", XSI_NAMESPACE);
            serializer.writeAttribute(XSI_NAMESPACE, "schemaLocation", "http://maven.apache.org/TOOLCHAINS/1.1.0 http://maven.apache.org/xsd/toolchains-1.1.0.xsd");
            this.writeList("toolchains", true, persistedToolchains.getToolchains(), serializer, t -> this.writeToolchainModel("toolchain", (ToolchainModel)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeToolchainModel(String tagName, ToolchainModel toolchainModel, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (toolchainModel != null) {
            serializer.writeStartElement(NAMESPACE, tagName);
            this.writeTag("type", null, toolchainModel.getType(), serializer);
            this.writeProperties("provides", toolchainModel.getProvides(), serializer);
            this.writeDom(toolchainModel.getConfiguration(), serializer);
            serializer.writeEndElement();
        }
    }

    private <T> void writeList(String tagName, List<T> list, XMLStreamWriter serializer, ElementWriter<T> writer) throws IOException, XMLStreamException {
        this.writeList(tagName, false, list, serializer, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XMLStreamWriter serializer, ElementWriter<T> writer) throws IOException, XMLStreamException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.writeStartElement(NAMESPACE, tagName);
            }
            boolean index = false;
            for (T t : list) {
                writer.write(t);
            }
            if (!flat) {
                serializer.writeEndElement();
            }
        }
    }

    private <T> void writeProperties(String tagName, Map<String, String> props, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (props != null && !props.isEmpty()) {
            serializer.writeStartElement(NAMESPACE, tagName);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                this.writeTag(key, null, entry.getValue(), serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeDom(XmlNode dom, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dom != null) {
            serializer.writeStartElement(NAMESPACE, dom.getName());
            for (Map.Entry attr : dom.getAttributes().entrySet()) {
                serializer.writeAttribute(NAMESPACE, (String)attr.getKey(), (String)attr.getValue());
            }
            for (XmlNode child : dom.getChildren()) {
                this.writeDom(child, serializer);
            }
            String value = dom.getValue();
            if (value != null) {
                serializer.writeCharacters(value);
            }
            serializer.writeEndElement();
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.writeStartElement(NAMESPACE, tagName);
            serializer.writeCharacters(value);
            serializer.writeEndElement();
        }
    }

    private void writeAttr(String attrName, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null) {
            serializer.writeAttribute(attrName, value);
        }
    }

    @FunctionalInterface
    private static interface ElementWriter<T> {
        public void write(T var1) throws IOException, XMLStreamException;
    }
}

