/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.phase;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.archive.phase.PhaseOrder;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.format.ReaderFormatter;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.ResourceFactory;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=AssemblyArchiverPhase.class, hint="file-items")
public class FileItemAssemblyPhase
extends AbstractLogEnabled
implements AssemblyArchiverPhase,
PhaseOrder {
    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        List<FileItem> fileList = assembly.getFiles();
        File basedir = configSource.getBasedir();
        for (FileItem fileItem : fileList) {
            String outputDirectory1;
            String outputDirectory;
            String destName;
            String sourcePath = fileItem.getSource();
            File source = new File(sourcePath);
            String sourceName = source.getName();
            if (!source.isAbsolute()) {
                source = new File(basedir, sourcePath);
            }
            if ((destName = fileItem.getDestName()) == null) {
                destName = sourceName;
            }
            String target = (outputDirectory = AssemblyFormatUtils.getOutputDirectory(outputDirectory1 = fileItem.getOutputDirectory(), configSource.getFinalName(), configSource, AssemblyFormatUtils.moduleProjectInterpolator(configSource.getProject()), AssemblyFormatUtils.artifactProjectInterpolator(null))).endsWith("/") || outputDirectory.endsWith("\\") ? outputDirectory + destName : (outputDirectory.length() < 1 ? destName : outputDirectory + "/" + destName);
            try {
                InputStreamTransformer fileSetTransformers = ReaderFormatter.getFileSetTransformers(configSource, fileItem.isFiltered(), fileItem.getLineEnding());
                PlexusIoResource restoUse = ResourceFactory.createResource((File)source, (InputStreamTransformer)fileSetTransformers);
                int mode = TypeConversionUtils.modeToInt(fileItem.getFileMode(), this.getLogger());
                archiver.addResource(restoUse, target, mode);
            }
            catch (ArchiverException e) {
                throw new ArchiveCreationException("Error adding file to archive: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ArchiveCreationException("Error adding file to archive: " + e.getMessage(), e);
            }
        }
    }

    public int order() {
        return 10;
    }
}

