/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Release;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueAdapter {
    public static List<Release> getReleases(List<Issue> issues) {
        HashMap<String, Release> releasesMap = new HashMap<String, Release>();
        for (Issue issue : issues) {
            if (issue.getFixVersions() == null) continue;
            for (String fixVersion : issue.getFixVersions()) {
                Release release = (Release)releasesMap.get(fixVersion);
                if (release == null) {
                    release = new Release();
                    release.setVersion(fixVersion);
                    releasesMap.put(fixVersion, release);
                }
                Action action = IssueAdapter.createAction(issue);
                release.addAction(action);
            }
        }
        ArrayList<Release> releasesList = new ArrayList<Release>();
        for (Release release : releasesMap.values()) {
            releasesList.add(release);
        }
        return releasesList;
    }

    public static Action createAction(Issue issue) {
        Action action = new Action();
        action.setIssue(issue.getKey());
        String type = "";
        if (issue.getType().equals("Bug")) {
            type = "fix";
        } else if (issue.getType().equals("New Feature")) {
            type = "add";
        } else if (issue.getType().equals("Improvement")) {
            type = "update";
        }
        action.setType(type);
        action.setDev(issue.getAssignee());
        action.setDueTo("");
        action.setAction(issue.getSummary());
        return action;
    }
}

