/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class ProjectUtils {
    public static boolean validateIfIssueManagementComplete(MavenProject project, String issueManagementSystem, String mojoResult, Log log) {
        if (project.getIssueManagement() == null) {
            log.error((CharSequence)("No Issue Management set. No " + mojoResult + " will be generated."));
            return false;
        }
        if (project.getIssueManagement().getUrl() == null || project.getIssueManagement().getUrl().trim().equals("")) {
            log.error((CharSequence)("No URL set in Issue Management. No " + mojoResult + " will be generated."));
            return false;
        }
        if (project.getIssueManagement().getSystem() != null && !project.getIssueManagement().getSystem().equalsIgnoreCase(issueManagementSystem)) {
            log.error((CharSequence)("The " + mojoResult + " only supports " + issueManagementSystem + ".  No " + mojoResult + " will be generated."));
            return false;
        }
        return true;
    }
}

