/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.jira.AbstractJiraDownloader;
import org.apache.maven.plugin.jira.ClassicJiraDownloader;
import org.apache.maven.plugin.jira.RestJiraDownloader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptiveJiraDownloader
extends AbstractJiraDownloader {
    private AbstractJiraDownloader effectiveDownloader;
    private boolean forceClassic;

    @Override
    public void doExecute() throws Exception {
        this.effectiveDownloader = new RestJiraDownloader();
        this.copySettings(this.effectiveDownloader);
        try {
            this.effectiveDownloader.doExecute();
        }
        catch (RestJiraDownloader.NoRest nre) {
            this.getLog().info((CharSequence)("Falling back to RSS for issue download: " + nre.getMessage()));
            this.effectiveDownloader = new ClassicJiraDownloader();
            this.copySettings(this.effectiveDownloader);
            this.effectiveDownloader.doExecute();
        }
    }

    private void copySettings(AbstractJiraDownloader target) {
        target.setLog(this.getLog());
        target.setMavenProject(this.project);
        target.setOutput(this.output);
        target.setNbEntries(this.nbEntriesMax);
        target.setComponent(this.component);
        target.setFixVersionIds(this.fixVersionIds);
        target.setStatusIds(this.statusIds);
        target.setResolutionIds(this.resolutionIds);
        target.setPriorityIds(this.priorityIds);
        target.setSortColumnNames(this.sortColumnNames);
        target.setFilter(this.filter);
        target.setJiraDatePattern(this.jiraDatePattern);
        target.setJiraUser(this.jiraUser);
        target.setJiraPassword(this.jiraPassword);
        target.setTypeIds(this.typeIds);
        target.setWebUser(this.webUser);
        target.setWebPassword(this.webPassword);
        target.setSettings(this.settings);
        target.setUseJql(this.useJql);
        target.setOnlyCurrentVersion(this.onlyCurrentVersion);
        target.setVersionPrefix(this.versionPrefix);
    }

    @Override
    public List<Issue> getIssueList() throws MojoExecutionException {
        return this.effectiveDownloader.getIssueList();
    }

    public boolean isForceClassic() {
        return this.forceClassic;
    }

    public void setForceClassic(boolean forceClassic) {
        this.forceClassic = forceClassic;
    }
}

