/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.checkstyle.AbstractCheckstyleReport;
import org.apache.maven.plugin.checkstyle.exec.CheckstyleExecutorRequest;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="checkstyle", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CheckstyleReport
extends AbstractCheckstyleReport {
    private static final Map<String, String> FORMAT_TO_CONFIG_LOCATION;
    @Parameter(defaultValue="sun")
    private String format;
    @Parameter
    private File propertiesFile;
    @Parameter
    private URL propertiesURL;
    @Parameter(defaultValue="${basedir}/LICENSE.txt")
    private File headerFile;
    @Parameter
    private String suppressionsFile;
    @Parameter
    private String packageNamesLocation;
    @Parameter
    private String packageNamesFile;

    protected MavenProject getProject() {
        return this.project;
    }

    @Override
    public void executeReport(Locale locale) throws MavenReportException {
        this.mergeDeprecatedInfo();
        super.executeReport(locale);
    }

    @Override
    protected CheckstyleExecutorRequest createRequest() throws MavenReportException {
        CheckstyleExecutorRequest request = new CheckstyleExecutorRequest();
        request.setConsoleListener(this.getConsoleListener()).setConsoleOutput(this.consoleOutput).setExcludes(this.excludes).setFailsOnError(this.failsOnError).setIncludes(this.includes).setResourceIncludes(this.resourceIncludes).setResourceExcludes(this.resourceExcludes).setIncludeResources(this.includeResources).setIncludeTestResources(this.includeTestResources).setIncludeTestSourceDirectory(this.includeTestSourceDirectory).setListener(this.getListener()).setProject(this.project).setSourceDirectories(this.getSourceDirectories()).setResources(this.resources).setStringOutputStream(this.stringOutputStream).setSuppressionsLocation(this.suppressionsLocation).setTestSourceDirectories(this.getTestSourceDirectories()).setConfigLocation(this.configLocation).setPropertyExpansion(this.propertyExpansion).setHeaderLocation(this.headerLocation).setCacheFile(this.cacheFile).setSuppressionsFileExpression(this.suppressionsFileExpression).setEncoding(this.encoding).setPropertiesLocation(this.propertiesLocation);
        return request;
    }

    public String getOutputName() {
        return "checkstyle";
    }

    public boolean canGenerateReport() {
        if (this.skip) {
            return false;
        }
        for (File sourceDirectory : this.getSourceDirectories()) {
            if (!sourceDirectory.exists()) continue;
            return true;
        }
        if (this.includeTestSourceDirectory) {
            for (File testSourceDirectory : this.getTestSourceDirectories()) {
                if (!testSourceDirectory.exists()) continue;
                return true;
            }
        }
        return this.includeResources && this.hasResources(this.resources) || this.includeTestResources && this.hasResources(this.testResources);
    }

    private boolean hasResources(List<Resource> resources) {
        for (Resource resource : resources) {
            if (!new File(resource.getDirectory()).exists()) continue;
            return true;
        }
        return false;
    }

    private void mergeDeprecatedInfo() throws MavenReportException {
        File defaultHeaderFile;
        if ("config/sun_checks.xml".equals(this.configLocation) && !"sun".equals(this.format)) {
            this.configLocation = FORMAT_TO_CONFIG_LOCATION.get(this.format);
            throw new MavenReportException("'format' parameter is deprecated: please replace with <configLocation>" + this.configLocation + "</configLocation>.");
        }
        if (StringUtils.isEmpty((String)this.propertiesLocation)) {
            if (this.propertiesFile != null) {
                this.propertiesLocation = this.propertiesFile.getPath();
                throw new MavenReportException("'propertiesFile' parameter is deprecated: please replace with <propertiesLocation>" + this.propertiesLocation + "</propertiesLocation>.");
            }
            if (this.propertiesURL != null) {
                this.propertiesLocation = this.propertiesURL.toExternalForm();
                throw new MavenReportException("'propertiesURL' parameter is deprecated: please replace with <propertiesLocation>" + this.propertiesLocation + "</propertiesLocation>.");
            }
        }
        if ("LICENSE.txt".equals(this.headerLocation) && !(defaultHeaderFile = new File(this.project.getBasedir(), "LICENSE.txt")).equals(this.headerFile)) {
            this.headerLocation = this.headerFile.getPath();
        }
        if (StringUtils.isEmpty((String)this.suppressionsLocation)) {
            this.suppressionsLocation = this.suppressionsFile;
            if (StringUtils.isNotEmpty((String)this.suppressionsFile)) {
                throw new MavenReportException("'suppressionsFile' parameter is deprecated: please replace with <suppressionsLocation>" + this.suppressionsLocation + "</suppressionsLocation>.");
            }
        }
        if (StringUtils.isEmpty((String)this.packageNamesLocation)) {
            this.packageNamesLocation = this.packageNamesFile;
            if (StringUtils.isNotEmpty((String)this.packageNamesFile)) {
                throw new MavenReportException("'packageNamesFile' parameter is deprecated: please replace with <packageNamesFile>" + this.suppressionsLocation + "</packageNamesFile>.");
            }
        }
    }

    static {
        HashMap<String, String> fmt2Cfg = new HashMap<String, String>();
        fmt2Cfg.put("sun", "config/sun_checks.xml");
        fmt2Cfg.put("turbine", "config/turbine_checks.xml");
        fmt2Cfg.put("maven", "config/maven_checks.xml");
        FORMAT_TO_CONFIG_LOCATION = Collections.unmodifiableMap(fmt2Cfg);
    }
}

