/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.io.download;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.shared.io.download.DownloadFailedException;
import org.apache.maven.shared.io.download.DownloadManager;
import org.apache.maven.shared.io.logging.MessageHolder;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.repository.Repository;

public class DefaultDownloadManager
implements DownloadManager {
    public static final String ROLE_HINT = "default";
    private WagonManager wagonManager;
    private Map cache = new HashMap();

    public DefaultDownloadManager() {
    }

    public DefaultDownloadManager(WagonManager wagonManager) {
        this.wagonManager = wagonManager;
    }

    public File download(String url, MessageHolder messageHolder) throws DownloadFailedException {
        return this.download(url, Collections.EMPTY_LIST, messageHolder);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File download(String url, List transferListeners, MessageHolder messageHolder) throws DownloadFailedException {
        block26: {
            block24: {
                downloaded = (File)this.cache.get(url);
                if (downloaded != null && downloaded.exists()) {
                    messageHolder.addMessage("Using cached download: " + downloaded.getAbsolutePath());
                    return downloaded;
                }
                try {
                    sourceUrl = new URL(url);
                }
                catch (MalformedURLException e) {
                    throw new DownloadFailedException(url, "Download failed due to invalid URL. Reason: " + e.getMessage(), e);
                }
                wagon = null;
                try {
                    wagon = this.wagonManager.getWagon(sourceUrl.getProtocol());
                }
                catch (UnsupportedProtocolException e) {
                    throw new DownloadFailedException(url, "Download failed. Reason: " + e.getMessage(), e);
                }
                messageHolder.addMessage("Using wagon: " + wagon + " to download: " + url);
                try {
                    downloaded = File.createTempFile("download-", null);
                    downloaded.deleteOnExit();
                }
                catch (IOException e) {
                    throw new DownloadFailedException(url, "Failed to create temporary file target for download. Reason: " + e.getMessage(), e);
                }
                messageHolder.addMessage("Download target is: " + downloaded.getAbsolutePath());
                remotePath = sourceUrl.getPath();
                baseUrl = url.substring(0, url.length() - remotePath.length());
                it = transferListeners.iterator();
                while (it.hasNext()) {
                    listener = (TransferListener)it.next();
                    wagon.addTransferListener(listener);
                }
                repo = new Repository(sourceUrl.getHost(), baseUrl);
                messageHolder.addMessage("Connecting to: " + repo.getHost() + "(baseUrl: " + repo.getUrl() + ")");
                try {
                    wagon.connect(repo, this.wagonManager.getAuthenticationInfo(repo.getId()), this.wagonManager.getProxy(sourceUrl.getProtocol()));
                }
                catch (ConnectionException e) {
                    throw new DownloadFailedException(url, "Download failed. Reason: " + e.getMessage(), e);
                }
                catch (AuthenticationException e) {
                    throw new DownloadFailedException(url, "Download failed. Reason: " + e.getMessage(), e);
                }
                messageHolder.addMessage("Getting: " + remotePath);
                try {
                    try {
                        wagon.get(remotePath, downloaded);
                        this.cache.put(url, downloaded);
                        e = downloaded;
                        var12_19 = null;
                        if (wagon == null) return e;
                        break block24;
                    }
                    catch (TransferFailedException e) {
                        throw new DownloadFailedException(url, "Download failed. Reason: " + e.getMessage(), e);
                    }
                    catch (ResourceDoesNotExistException e) {
                        throw new DownloadFailedException(url, "Download failed. Reason: " + e.getMessage(), e);
                    }
                    catch (AuthorizationException e) {
                        throw new DownloadFailedException(url, "Download failed. Reason: " + e.getMessage(), e);
                    }
                    return e;
                }
                catch (Throwable var11_25) {
                    var12_20 = null;
                    if (wagon != null) {
                        try {
                            messageHolder.addMessage("Disconnecting.");
                            wagon.disconnect();
                        }
                        catch (ConnectionException e) {
                            messageHolder.addMessage("Failed to disconnect wagon for: " + url, e);
                        }
                        it = transferListeners.iterator();
                        while (it.hasNext()) {
                            listener = (TransferListener)it.next();
                            wagon.removeTransferListener(listener);
                        }
                    }
                    throw var11_25;
                }
            }
            ** try [egrp 6[TRYBLOCK] [10 : 712->731)] { 
lbl85:
            // 1 sources

            messageHolder.addMessage("Disconnecting.");
            wagon.disconnect();
            break block26;
lbl89:
            // 1 sources

            catch (ConnectionException e) {
                messageHolder.addMessage("Failed to disconnect wagon for: " + url, e);
            }
        }
        it = transferListeners.iterator();
        while (true) {
            if (!it.hasNext()) ** continue;
            listener = (TransferListener)it.next();
            wagon.removeTransferListener(listener);
        }
    }
}

