/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import org.apache.maven.wagon.FileTestUtils;
import org.apache.maven.wagon.LazyFileOutputStream;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamingWagon;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonTestCase;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class StreamingWagonTestCase
extends WagonTestCase {
    public void testStreamingWagon() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupRepositories();
            this.setupWagonTestingFixtures();
            this.streamRoundTripTesting();
            this.tearDownWagonTestingFixtures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailedGetToStream() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        this.message("Getting test artifact from test repository " + this.testRepository);
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        wagon.addTransferListener((TransferListener)this.checksumObserver);
        wagon.connect(this.testRepository, this.getAuthInfo());
        this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
        this.destFile.deleteOnExit();
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(this.destFile);
            wagon.getToStream("fubar.txt", (OutputStream)stream);
            StreamingWagonTestCase.fail((String)"File was found when it shouldn't have been");
        }
        catch (ResourceDoesNotExistException e) {
            StreamingWagonTestCase.assertTrue((boolean)true);
        }
        finally {
            wagon.removeTransferListener((TransferListener)this.checksumObserver);
            wagon.disconnect();
            IOUtil.close((OutputStream)stream);
            this.tearDownWagonTestingFixtures();
        }
    }

    public void testWagonGetIfNewerToStreamIsNewer() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupRepositories();
            this.setupWagonTestingFixtures();
            int expectedSize = this.putFile();
            this.getIfNewerToStream(this.getExpectedLastModifiedOnGet(this.testRepository, new Resource(this.resource)) + 30000L, false, expectedSize);
        }
    }

    public void testWagonGetIfNewerToStreamIsOlder() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupRepositories();
            this.setupWagonTestingFixtures();
            int expectedSize = this.putFile();
            this.getIfNewerToStream(new SimpleDateFormat("yyyy-MM-dd").parse("2006-01-01").getTime(), true, expectedSize);
        }
    }

    public void testWagonGetIfNewerToStreamIsSame() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupRepositories();
            this.setupWagonTestingFixtures();
            int expectedSize = this.putFile();
            this.getIfNewerToStream(this.getExpectedLastModifiedOnGet(this.testRepository, new Resource(this.resource)), false, expectedSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getIfNewerToStream(long timestamp, boolean expectedResult, int expectedSize) throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        WagonTestCase.ProgressAnswer progressAnswer = this.setupGetIfNewerTest((Wagon)wagon, expectedResult, expectedSize);
        this.connectWagon((Wagon)wagon);
        LazyFileOutputStream stream = new LazyFileOutputStream(this.destFile);
        try {
            boolean result = wagon.getIfNewerToStream(this.resource, (OutputStream)stream, timestamp);
            StreamingWagonTestCase.assertEquals((boolean)expectedResult, (boolean)result);
        }
        finally {
            IOUtil.close((OutputStream)stream);
        }
        this.disconnectWagon((Wagon)wagon);
        this.assertGetIfNewerTest(progressAnswer, expectedResult, expectedSize);
        this.tearDownWagonTestingFixtures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailedGetIfNewerToStream() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupRepositories();
            this.setupWagonTestingFixtures();
            this.message("Getting test artifact from test repository " + this.testRepository);
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            wagon.addTransferListener((TransferListener)this.checksumObserver);
            wagon.connect(this.testRepository, this.getAuthInfo());
            this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            this.destFile.deleteOnExit();
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(this.destFile);
                wagon.getIfNewerToStream("fubar.txt", (OutputStream)stream, 0L);
                StreamingWagonTestCase.fail((String)"File was found when it shouldn't have been");
            }
            catch (ResourceDoesNotExistException e) {
                StreamingWagonTestCase.assertTrue((boolean)true);
            }
            finally {
                wagon.removeTransferListener((TransferListener)this.checksumObserver);
                wagon.disconnect();
                IOUtil.close((OutputStream)stream);
                this.tearDownWagonTestingFixtures();
            }
        }
    }

    protected void streamRoundTripTesting() throws Exception {
        this.message("Stream round trip testing ...");
        int expectedSize = this.putStream();
        StreamingWagonTestCase.assertNotNull((String)"check checksum is not null", (Object)this.checksumObserver.getActualChecksum());
        StreamingWagonTestCase.assertEquals((String)"compare checksums", (String)"6b144b7285ffd6b0bc8300da162120b9", (String)this.checksumObserver.getActualChecksum());
        this.checksumObserver = new ChecksumObserver();
        this.getStream(expectedSize);
        StreamingWagonTestCase.assertNotNull((String)"check checksum is not null", (Object)this.checksumObserver.getActualChecksum());
        StreamingWagonTestCase.assertEquals((String)"compare checksums", (String)"6b144b7285ffd6b0bc8300da162120b9", (String)this.checksumObserver.getActualChecksum());
        String sourceContent = FileUtils.fileRead((File)this.sourceFile);
        String destContent = FileUtils.fileRead((File)this.destFile);
        StreamingWagonTestCase.assertEquals((String)sourceContent, (String)destContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putStream() throws Exception {
        String content = "test-resource.txt\n";
        this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "test-resource");
        this.sourceFile.getParentFile().mkdirs();
        FileUtils.fileWrite((String)this.sourceFile.getAbsolutePath(), (String)content);
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        WagonTestCase.ProgressAnswer progressAnswer = this.replayMockForPut(this.resource, content, (Wagon)wagon);
        this.message("Putting test artifact: " + this.resource + " into test repository " + this.testRepository);
        this.connectWagon((Wagon)wagon);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.sourceFile);
            wagon.putFromStream((InputStream)stream, this.resource, this.sourceFile.length(), this.sourceFile.lastModified());
        }
        catch (Exception e) {
            try {
                logger.error((Object)"error while putting resources to the FTP Server", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(stream);
                throw throwable;
            }
            IOUtil.close((InputStream)stream);
        }
        IOUtil.close((InputStream)stream);
        this.disconnectWagon((Wagon)wagon);
        this.verifyMock(progressAnswer, content.length());
        return content.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getStream(int expectedSize) throws Exception {
        this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
        this.destFile.deleteOnExit();
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        WagonTestCase.ProgressAnswer progressAnswer = this.replaceMockForGet((Wagon)wagon, expectedSize);
        this.message("Getting test artifact from test repository " + this.testRepository);
        this.connectWagon((Wagon)wagon);
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(this.destFile);
            wagon.getToStream(this.resource, (OutputStream)stream);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"error while reading resources from the FTP Server", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(stream);
                throw throwable;
            }
            IOUtil.close((OutputStream)stream);
        }
        IOUtil.close((OutputStream)stream);
        this.disconnectWagon((Wagon)wagon);
        this.verifyMock(progressAnswer, expectedSize);
    }
}

