/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.maven.wagon.FileTestUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamingWagon;
import org.apache.maven.wagon.StreamingWagonTestCase;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpWagonTestCase
extends StreamingWagonTestCase {
    public static final int SC_TOO_MANY_REQUESTS = 429;
    private Server server;

    @Override
    protected void setupWagonTestingFixtures() throws Exception {
        File file = FileTestUtils.createUniqueFile("local-repository", "test-resource");
        file.delete();
        file.getParentFile().mkdirs();
        File repositoryDirectory = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)repositoryDirectory);
        repositoryDirectory.mkdirs();
        this.server = new Server(0);
        PutHandler putHandler = new PutHandler(repositoryDirectory);
        this.server.addHandler((Handler)putHandler);
        this.createContext(this.server, repositoryDirectory);
        this.addConnectors(this.server);
        this.server.start();
        this.testRepository.setUrl(this.getTestRepositoryUrl());
    }

    @Override
    protected final int getTestRepositoryPort() {
        if (this.server == null) {
            return 0;
        }
        return this.server.getConnectors()[0].getLocalPort();
    }

    protected void createContext(Server server, File repositoryDirectory) throws IOException {
        Context root = new Context((HandlerContainer)server, "/", 1);
        root.setResourceBase(repositoryDirectory.getAbsolutePath());
        ServletHolder servletHolder = new ServletHolder((Servlet)new DefaultServlet());
        root.addServlet(servletHolder, "/*");
    }

    @Override
    protected void tearDownWagonTestingFixtures() throws Exception {
        this.server.stop();
    }

    @Override
    public void testWagonGetFileList() throws Exception {
        File dir = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)dir);
        File f = new File(dir, "file-list");
        f.mkdirs();
        super.testWagonGetFileList();
    }

    public void testHttpHeaders() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("User-Agent", "Maven-Wagon/1.0");
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        this.setHttpHeaders(wagon, properties);
        Server server = new Server(0);
        TestHeaderHandler handler = new TestHeaderHandler();
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        wagon.connect(new Repository("id", this.getProtocol() + "://localhost:" + server.getConnectors()[0].getLocalPort()));
        wagon.getToStream("resource", (OutputStream)new ByteArrayOutputStream());
        wagon.disconnect();
        server.stop();
        HttpWagonTestCase.assertEquals((String)"Maven-Wagon/1.0", (String)handler.headers.get("User-Agent"));
    }

    public void testHttpHeadersWithCommonMethods() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("User-Agent", "Maven-Wagon/1.0");
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Method setHttpHeaders = wagon.getClass().getMethod("setHttpHeaders", Properties.class);
        setHttpHeaders.invoke((Object)wagon, properties);
        Server server = new Server(0);
        TestHeaderHandler handler = new TestHeaderHandler();
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        wagon.connect(new Repository("id", this.getProtocol() + "://localhost:" + server.getConnectors()[0].getLocalPort()));
        wagon.getToStream("resource", (OutputStream)new ByteArrayOutputStream());
        wagon.disconnect();
        server.stop();
        HttpWagonTestCase.assertEquals((String)"Maven-Wagon/1.0", (String)handler.headers.get("User-Agent"));
    }

    public void testUserAgentHeaderIsPresentByDefault() throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = new Server(0);
        TestHeaderHandler handler = new TestHeaderHandler();
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        wagon.connect(new Repository("id", this.getProtocol() + "://localhost:" + server.getConnectors()[0].getLocalPort()));
        wagon.getToStream("resource", (OutputStream)new ByteArrayOutputStream());
        wagon.disconnect();
        server.stop();
        HttpWagonTestCase.assertNotNull((String)"default User-Agent header of wagon provider should be present", (Object)handler.headers.get("User-Agent"));
    }

    public void testUserAgentHeaderIsPresentOnlyOnceIfSetMultipleTimes() throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Properties headers1 = new Properties();
        headers1.setProperty("User-Agent", "test-user-agent");
        this.setHttpHeaders(wagon, headers1);
        Properties headers2 = new Properties();
        headers2.setProperty("User-Agent", "test-user-agent");
        Method setHttpHeaders = wagon.getClass().getMethod("setHttpHeaders", Properties.class);
        setHttpHeaders.invoke((Object)wagon, headers2);
        Server server = new Server(0);
        TestHeaderHandler handler = new TestHeaderHandler();
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        wagon.connect(new Repository("id", this.getProtocol() + "://localhost:" + server.getConnectors()[0].getLocalPort()));
        wagon.getToStream("resource", (OutputStream)new ByteArrayOutputStream());
        wagon.disconnect();
        server.stop();
        HttpWagonTestCase.assertEquals((String)"test-user-agent", (String)handler.headers.get("User-Agent"));
    }

    protected abstract void setHttpHeaders(StreamingWagon var1, Properties var2);

    protected void addConnectors(Server server) {
    }

    protected String getRepositoryUrl(Server server) {
        int localPort = server.getConnectors()[0].getLocalPort();
        return this.getProtocol() + "://localhost:" + localPort;
    }

    public void testGetForbidden() throws Exception {
        try {
            this.runTestGet(403);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testGet404() throws Exception {
        try {
            this.runTestGet(404);
            HttpWagonTestCase.fail();
        }
        catch (ResourceDoesNotExistException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testList429() throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        try {
            Server server = new Server(0);
            final AtomicBoolean called = new AtomicBoolean();
            AbstractHandler handler = new AbstractHandler(){

                public void handle(String s, HttpServletRequest request, HttpServletResponse response, int i) throws IOException, ServletException {
                    if (called.get()) {
                        response.setStatus(200);
                        ((Request)request).setHandled(true);
                    } else {
                        called.set(true);
                        response.setStatus(429);
                        ((Request)request).setHandled(true);
                    }
                }
            };
            server.setHandler((Handler)handler);
            this.addConnectors(server);
            server.start();
            wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
            try {
                wagon.getFileList("resource");
            }
            finally {
                wagon.disconnect();
                server.stop();
            }
        }
        catch (ResourceDoesNotExistException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
        catch (TransferFailedException e) {
            if (wagon.getClass().getName().contains("Lightweight")) {
                HttpWagonTestCase.assertTrue((boolean)true);
            }
            HttpWagonTestCase.fail();
        }
    }

    public void testGet500() throws Exception {
        try {
            this.runTestGet(500);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestGet(int status) throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = new Server(0);
        StatusHandler handler = new StatusHandler();
        handler.setStatusToReturn(status);
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
        try {
            wagon.getToStream("resource", (OutputStream)new ByteArrayOutputStream());
            HttpWagonTestCase.fail();
        }
        finally {
            wagon.disconnect();
            server.stop();
        }
    }

    public void testResourceExistsForbidden() throws Exception {
        try {
            this.runTestResourceExists(403);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testResourceExists404() throws Exception {
        try {
            HttpWagonTestCase.assertFalse((boolean)this.runTestResourceExists(404));
        }
        catch (ResourceDoesNotExistException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testResourceExists500() throws Exception {
        try {
            this.runTestResourceExists(500);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceExists429() throws Exception {
        try {
            final AtomicBoolean called = new AtomicBoolean();
            AbstractHandler handler = new AbstractHandler(){

                public void handle(String s, HttpServletRequest request, HttpServletResponse response, int i) throws IOException, ServletException {
                    if (called.get()) {
                        response.setStatus(500);
                        ((Request)request).setHandled(true);
                    } else {
                        called.set(true);
                        response.setStatus(429);
                        ((Request)request).setHandled(true);
                    }
                }
            };
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Server server = new Server(0);
            server.setHandler((Handler)handler);
            this.addConnectors(server);
            server.start();
            wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
            try {
                wagon.resourceExists("resource");
            }
            finally {
                wagon.disconnect();
                server.stop();
            }
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTestResourceExists(int status) throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = new Server(0);
        StatusHandler handler = new StatusHandler();
        handler.setStatusToReturn(status);
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
        try {
            boolean bl = wagon.resourceExists("resource");
            return bl;
        }
        finally {
            wagon.disconnect();
            server.stop();
        }
    }

    @Override
    protected long getExpectedLastModifiedOnGet(Repository repository, Resource resource) {
        File file = new File(this.getRepositoryDirectory(), resource.getName());
        return file.lastModified() / 1000L * 1000L;
    }

    protected File getRepositoryDirectory() {
        return HttpWagonTestCase.getTestFile((String)"target/test-output/http-repository");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGzipGet() throws Exception {
        Server server = new Server(this.getTestRepositoryPort());
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Context root = new Context((HandlerContainer)server, "/", 1);
        root.setResourceBase(localRepositoryPath);
        ServletHolder servletHolder = new ServletHolder((Servlet)new DefaultServlet());
        servletHolder.setInitParameter("gzip", "true");
        root.addServlet(servletHolder, "/*");
        this.addConnectors(server);
        server.start();
        try {
            Wagon wagon = this.getWagon();
            Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
            File sourceFile = new File(localRepositoryPath + "/gzip");
            sourceFile.deleteOnExit();
            String resName = "gzip-res.txt";
            String sourceContent = this.writeTestFileGzip(sourceFile, resName);
            wagon.connect(testRepository);
            File destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            destFile.deleteOnExit();
            wagon.get("gzip/" + resName, destFile);
            wagon.disconnect();
            String destContent = FileUtils.fileRead((File)destFile);
            HttpWagonTestCase.assertEquals((String)sourceContent, (String)destContent);
        }
        finally {
            server.stop();
        }
    }

    public void testProxiedRequest() throws Exception {
        ProxyInfo proxyInfo = this.createProxyInfo();
        TestHeaderHandler handler = new TestHeaderHandler();
        this.runTestProxiedRequest(proxyInfo, handler);
    }

    public void testProxiedRequestWithAuthentication() throws Exception {
        ProxyInfo proxyInfo = this.createProxyInfo();
        proxyInfo.setUserName("user");
        proxyInfo.setPassword("secret");
        AuthorizingProxyHandler handler = new AuthorizingProxyHandler();
        this.runTestProxiedRequest(proxyInfo, handler);
        HttpWagonTestCase.assertTrue((boolean)handler.headers.containsKey("Proxy-Authorization"));
        if (this.supportProxyPreemptiveAuthentication()) {
            HttpWagonTestCase.assertEquals((int)200, (int)handler.handlerRequestResponses.get((int)0).responseCode);
        } else {
            HttpWagonTestCase.assertEquals((int)407, (int)handler.handlerRequestResponses.get((int)0).responseCode);
            HttpWagonTestCase.assertEquals((int)200, (int)handler.handlerRequestResponses.get((int)1).responseCode);
        }
    }

    public void testProxiedRequestWithAuthenticationWithProvider() throws Exception {
        final ProxyInfo proxyInfo = this.createProxyInfo();
        proxyInfo.setUserName("user");
        proxyInfo.setPassword("secret");
        AuthorizingProxyHandler handler = new AuthorizingProxyHandler();
        ProxyInfoProvider proxyInfoProvider = new ProxyInfoProvider(){

            public ProxyInfo getProxyInfo(String protocol) {
                return proxyInfo;
            }
        };
        this.runTestProxiedRequestWithProvider(proxyInfoProvider, handler);
        HttpWagonTestCase.assertTrue((boolean)handler.headers.containsKey("Proxy-Authorization"));
        if (this.supportProxyPreemptiveAuthentication()) {
            HttpWagonTestCase.assertEquals((int)200, (int)handler.handlerRequestResponses.get((int)0).responseCode);
        } else {
            HttpWagonTestCase.assertEquals((int)407, (int)handler.handlerRequestResponses.get((int)0).responseCode);
            HttpWagonTestCase.assertEquals((int)200, (int)handler.handlerRequestResponses.get((int)1).responseCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectGetToStream() throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = new Server(0);
        TestHeaderHandler handler = new TestHeaderHandler();
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        Server redirectServer = new Server(0);
        this.addConnectors(redirectServer);
        String protocol = this.getProtocol();
        if (protocol.equals("dav")) {
            protocol = "http";
        }
        if (protocol.equals("davs")) {
            protocol = "https";
        }
        String redirectUrl = protocol + "://localhost:" + server.getConnectors()[0].getLocalPort();
        RedirectHandler redirectHandler = new RedirectHandler("Found", 303, redirectUrl, null);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        wagon.connect(new Repository("id", this.getRepositoryUrl(redirectServer)));
        File tmpResult = File.createTempFile("foo", "get");
        FileOutputStream fileOutputStream = new FileOutputStream(tmpResult);
        try {
            wagon.getToStream("resource", (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
            String found = FileUtils.fileRead((File)tmpResult);
            HttpWagonTestCase.assertEquals((String)("found:'" + found + "'"), (String)"Hello, World!", (String)found);
            this.checkHandlerResult(handler.handlerRequestResponses, 200);
            this.checkHandlerResult(redirectHandler.handlerRequestResponses, 302);
        }
        finally {
            wagon.disconnect();
            server.stop();
            tmpResult.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectGet() throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = new Server(0);
        TestHeaderHandler handler = new TestHeaderHandler();
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        Server redirectServer = new Server(0);
        this.addConnectors(redirectServer);
        String protocol = this.getProtocol();
        if (protocol.equals("dav")) {
            protocol = "http";
        }
        if (protocol.equals("davs")) {
            protocol = "https";
        }
        String redirectUrl = protocol + "://localhost:" + server.getConnectors()[0].getLocalPort();
        RedirectHandler redirectHandler = new RedirectHandler("Found", 303, redirectUrl, null);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        wagon.connect(new Repository("id", this.getRepositoryUrl(redirectServer)));
        File tmpResult = File.createTempFile("foo", "get");
        try {
            wagon.get("resource", tmpResult);
            String found = FileUtils.fileRead((File)tmpResult);
            HttpWagonTestCase.assertEquals((String)("found:'" + found + "'"), (String)"Hello, World!", (String)found);
            this.checkHandlerResult(handler.handlerRequestResponses, 200);
            this.checkHandlerResult(redirectHandler.handlerRequestResponses, 302);
        }
        finally {
            wagon.disconnect();
            server.stop();
            tmpResult.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectPutFromStreamWithFullUrl() throws Exception {
        Server realServer = new Server(0);
        this.addConnectors(realServer);
        File repositoryDirectory = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)repositoryDirectory);
        repositoryDirectory.mkdirs();
        PutHandler putHandler = new PutHandler(repositoryDirectory);
        realServer.setHandler((Handler)putHandler);
        realServer.start();
        Server redirectServer = new Server(0);
        this.addConnectors(redirectServer);
        String protocol = this.getProtocol();
        if (protocol.equals("dav")) {
            protocol = "http";
        }
        if (protocol.equals("davs")) {
            protocol = "https";
        }
        String redirectUrl = protocol + "://localhost:" + realServer.getConnectors()[0].getLocalPort();
        RedirectHandler redirectHandler = new RedirectHandler("Found", 303, redirectUrl, repositoryDirectory);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository repository = new Repository("foo", this.getRepositoryUrl(redirectServer));
            wagon.connect(repository);
            File sourceFile = new File(repositoryDirectory, "test-secured-put-resource");
            sourceFile.delete();
            HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
            File tempFile = File.createTempFile("wagon", "tmp");
            tempFile.deleteOnExit();
            String content = "put top secret";
            FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)content);
            FileInputStream fileInputStream = new FileInputStream(tempFile);
            try {
                wagon.putFromStream((InputStream)fileInputStream, "test-secured-put-resource", (long)content.length(), -1L);
            }
            finally {
                fileInputStream.close();
                tempFile.delete();
            }
            HttpWagonTestCase.assertEquals((String)content, (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
            this.checkRequestResponseForRedirectPutFromStreamWithFullUrl(putHandler, redirectHandler);
        }
        finally {
            realServer.stop();
            redirectServer.stop();
        }
    }

    protected void checkRequestResponseForRedirectPutFromStreamWithFullUrl(PutHandler putHandler, RedirectHandler redirectHandler) {
        this.checkHandlerResult(putHandler.handlerRequestResponses, 201);
        this.checkHandlerResult(redirectHandler.handlerRequestResponses, 302);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectPutFromStreamRelativeUrl() throws Exception {
        Server realServer = new Server(0);
        this.addConnectors(realServer);
        File repositoryDirectory = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)repositoryDirectory);
        repositoryDirectory.mkdirs();
        PutHandler putHandler = new PutHandler(repositoryDirectory);
        realServer.setHandler((Handler)putHandler);
        realServer.start();
        Server redirectServer = new Server(0);
        this.addConnectors(redirectServer);
        RedirectHandler redirectHandler = new RedirectHandler("Found", 303, "/redirectRequest/foo", repositoryDirectory);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository repository = new Repository("foo", this.getRepositoryUrl(redirectServer));
            wagon.connect(repository);
            File sourceFile = new File(repositoryDirectory, "/redirectRequest/foo/test-secured-put-resource");
            sourceFile.delete();
            HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
            File tempFile = File.createTempFile("wagon", "tmp");
            tempFile.deleteOnExit();
            String content = "put top secret";
            FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)content);
            FileInputStream fileInputStream = new FileInputStream(tempFile);
            try {
                wagon.putFromStream((InputStream)fileInputStream, "test-secured-put-resource", (long)content.length(), -1L);
            }
            finally {
                fileInputStream.close();
                tempFile.delete();
            }
            HttpWagonTestCase.assertEquals((String)content, (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
            this.checkRequestResponseForRedirectPutFromStreamWithRelativeUrl(putHandler, redirectHandler);
        }
        finally {
            realServer.stop();
            redirectServer.stop();
        }
    }

    protected void checkRequestResponseForRedirectPutFromStreamWithRelativeUrl(PutHandler putHandler, RedirectHandler redirectHandler) {
        this.checkHandlerResult(putHandler.handlerRequestResponses, new int[0]);
        this.checkHandlerResult(redirectHandler.handlerRequestResponses, 302, 201);
    }

    protected void checkHandlerResult(List<HandlerRequestResponse> handlerRequestResponses, int ... expectedResponseCodes) {
        boolean success = true;
        if (handlerRequestResponses.size() == expectedResponseCodes.length) {
            for (int i = 0; i < expectedResponseCodes.length; ++i) {
                success &= expectedResponseCodes[i] == handlerRequestResponses.get((int)i).responseCode;
            }
        }
        if (!success) {
            HttpWagonTestCase.fail((String)("expected " + expectedResponseCodes + ", got " + handlerRequestResponses));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectPutFileWithFullUrl() throws Exception {
        Server realServer = new Server(0);
        this.addConnectors(realServer);
        File repositoryDirectory = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)repositoryDirectory);
        repositoryDirectory.mkdirs();
        PutHandler putHandler = new PutHandler(repositoryDirectory);
        realServer.setHandler((Handler)putHandler);
        realServer.start();
        Server redirectServer = new Server(0);
        this.addConnectors(redirectServer);
        String protocol = this.getProtocol();
        if (protocol.equals("dav")) {
            protocol = "http";
        }
        if (protocol.equals("davs")) {
            protocol = "https";
        }
        String redirectUrl = protocol + "://localhost:" + realServer.getConnectors()[0].getLocalPort();
        RedirectHandler redirectHandler = new RedirectHandler("Found", 303, redirectUrl, repositoryDirectory);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository repository = new Repository("foo", this.getRepositoryUrl(redirectServer));
            wagon.connect(repository);
            File sourceFile = new File(repositoryDirectory, "test-secured-put-resource");
            sourceFile.delete();
            HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
            File tempFile = File.createTempFile("wagon", "tmp");
            tempFile.deleteOnExit();
            String content = "put top secret";
            FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)content);
            try {
                wagon.put(tempFile, "test-secured-put-resource");
            }
            finally {
                tempFile.delete();
            }
            HttpWagonTestCase.assertEquals((String)content, (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
        }
        finally {
            realServer.stop();
            redirectServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectPutFileRelativeUrl() throws Exception {
        Server realServer = new Server(0);
        this.addConnectors(realServer);
        File repositoryDirectory = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)repositoryDirectory);
        repositoryDirectory.mkdirs();
        PutHandler putHandler = new PutHandler(repositoryDirectory);
        realServer.setHandler((Handler)putHandler);
        realServer.start();
        Server redirectServer = new Server(0);
        this.addConnectors(redirectServer);
        RedirectHandler redirectHandler = new RedirectHandler("Found", 303, "/redirectRequest/foo", repositoryDirectory);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository repository = new Repository("foo", this.getRepositoryUrl(redirectServer));
            wagon.connect(repository);
            File sourceFile = new File(repositoryDirectory, "/redirectRequest/foo/test-secured-put-resource");
            sourceFile.delete();
            HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
            File tempFile = File.createTempFile("wagon", "tmp");
            tempFile.deleteOnExit();
            String content = "put top secret";
            FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)content);
            try {
                wagon.put(tempFile, "test-secured-put-resource");
            }
            finally {
                tempFile.delete();
            }
            HttpWagonTestCase.assertEquals((String)content, (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
        }
        finally {
            realServer.stop();
            redirectServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestProxiedRequest(ProxyInfo proxyInfo, TestHeaderHandler handler) throws Exception {
        Thread.sleep(5001L);
        Server proxyServer = new Server(0);
        proxyServer.setHandler((Handler)handler);
        proxyServer.start();
        proxyInfo.setPort(proxyServer.getConnectors()[0].getLocalPort());
        System.out.println("start proxy on host/port " + proxyInfo.getHost() + "/" + proxyInfo.getPort() + " with non proxyHosts " + proxyInfo.getNonProxyHosts());
        while (!proxyServer.isRunning() || !proxyServer.isStarted()) {
            Thread.sleep(10L);
        }
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", "http://www.example.com/");
            String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
            File sourceFile = new File(localRepositoryPath, "test-proxied-resource");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"content");
            wagon.connect(testRepository, proxyInfo);
            try {
                wagon.getToStream("test-proxied-resource", (OutputStream)new ByteArrayOutputStream());
                HttpWagonTestCase.assertTrue((boolean)handler.headers.containsKey("Proxy-Connection"));
            }
            finally {
                System.setProperty("http.proxyHost", "");
                System.setProperty("http.proxyPort", "");
                wagon.disconnect();
            }
        }
        finally {
            proxyServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestProxiedRequestWithProvider(ProxyInfoProvider proxyInfoProvider, TestHeaderHandler handler) throws Exception {
        Thread.sleep(5001L);
        Server proxyServer = new Server(0);
        proxyServer.setHandler((Handler)handler);
        proxyServer.start();
        proxyInfoProvider.getProxyInfo(null).setPort(proxyServer.getConnectors()[0].getLocalPort());
        System.out.println("start proxy on host/port " + proxyInfoProvider.getProxyInfo(null).getHost() + "/" + proxyInfoProvider.getProxyInfo(null).getPort() + " with non proxyHosts " + proxyInfoProvider.getProxyInfo(null).getNonProxyHosts());
        while (!proxyServer.isRunning() || !proxyServer.isStarted()) {
            Thread.sleep(10L);
        }
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", "http://www.example.com/");
            String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
            File sourceFile = new File(localRepositoryPath, "test-proxied-resource");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"content");
            wagon.connect(testRepository, proxyInfoProvider);
            try {
                wagon.getToStream("test-proxied-resource", (OutputStream)new ByteArrayOutputStream());
                HttpWagonTestCase.assertTrue((boolean)handler.headers.containsKey("Proxy-Connection"));
            }
            finally {
                System.setProperty("http.proxyHost", "");
                System.setProperty("http.proxyPort", "");
                wagon.disconnect();
            }
        }
        finally {
            proxyServer.stop();
        }
    }

    private ProxyInfo createProxyInfo() {
        ProxyInfo proxyInfo = new ProxyInfo();
        proxyInfo.setHost("localhost");
        proxyInfo.setNonProxyHosts(null);
        proxyInfo.setType("http");
        return proxyInfo;
    }

    public void testSecuredGetUnauthorized() throws Exception {
        try {
            this.runTestSecuredGet(null);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredGetWrongPassword() throws Exception {
        try {
            AuthenticationInfo authInfo = new AuthenticationInfo();
            authInfo.setUserName("user");
            authInfo.setPassword("admin");
            this.runTestSecuredGet(authInfo);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredGet() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredGet(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredGet(AuthenticationInfo authInfo) throws Exception {
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = this.createSecurityServer(localRepositoryPath);
        server.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
            File sourceFile = new File(localRepositoryPath, "test-secured-resource");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"top secret");
            wagon.connect(testRepository, authInfo);
            File file = File.createTempFile("wagon-test", "txt");
            try {
                wagon.get("test-secured-resource", file);
            }
            finally {
                wagon.disconnect();
            }
            FileInputStream in = new FileInputStream(file);
            HttpWagonTestCase.assertEquals((String)"top secret", (String)IOUtil.toString((InputStream)in));
            TestSecurityHandler securityHandler = (TestSecurityHandler)((Context)server.getHandler()).getHandler();
            this.testPreemptiveAuthenticationGet(securityHandler, this.supportPreemptiveAuthenticationGet());
        }
        finally {
            server.stop();
        }
    }

    public void testSecuredGetToStream() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredGetToStream(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredGetToStream(AuthenticationInfo authInfo) throws Exception {
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = this.createSecurityServer(localRepositoryPath);
        server.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
            File sourceFile = new File(localRepositoryPath, "test-secured-resource");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"top secret");
            wagon.connect(testRepository, authInfo);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                wagon.getToStream("test-secured-resource", (OutputStream)out);
            }
            finally {
                wagon.disconnect();
            }
            HttpWagonTestCase.assertEquals((String)"top secret", (String)out.toString("US-ASCII"));
            TestSecurityHandler securityHandler = (TestSecurityHandler)((Context)server.getHandler()).getHandler();
            this.testPreemptiveAuthenticationGet(securityHandler, this.supportPreemptiveAuthenticationGet());
        }
        finally {
            server.stop();
        }
    }

    public void testSecuredResourceExistsUnauthorized() throws Exception {
        try {
            this.runTestSecuredResourceExists(null);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredResourceExistsWrongPassword() throws Exception {
        try {
            AuthenticationInfo authInfo = new AuthenticationInfo();
            authInfo.setUserName("user");
            authInfo.setPassword("admin");
            this.runTestSecuredResourceExists(authInfo);
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredResourceExists() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredResourceExists(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredResourceExists(AuthenticationInfo authInfo) throws Exception {
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = this.createSecurityServer(localRepositoryPath);
        server.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
            File sourceFile = new File(localRepositoryPath, "test-secured-resource-exists");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"top secret");
            wagon.connect(testRepository, authInfo);
            try {
                HttpWagonTestCase.assertTrue((boolean)wagon.resourceExists("test-secured-resource-exists"));
                HttpWagonTestCase.assertFalse((boolean)wagon.resourceExists("test-secured-resource-not-exists"));
            }
            finally {
                wagon.disconnect();
            }
        }
        finally {
            server.stop();
        }
    }

    private Server createSecurityServer(String localRepositoryPath) {
        Server server = new Server(0);
        TestSecurityHandler sh = this.createSecurityHandler();
        Context root = new Context(1);
        root.setContextPath("/");
        root.addHandler((Handler)sh);
        root.setResourceBase(localRepositoryPath);
        ServletHolder servletHolder = new ServletHolder((Servlet)new DefaultServlet());
        root.addServlet(servletHolder, "/*");
        server.setHandler((Handler)root);
        this.addConnectors(server);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeTestFileGzip(File parent, String child) throws IOException {
        String content;
        File file = new File(parent, child);
        file.getParentFile().mkdirs();
        file.deleteOnExit();
        OutputStream out = new FileOutputStream(file);
        try {
            out.write(child.getBytes());
        }
        finally {
            out.close();
        }
        file = new File(parent, child + ".gz");
        file.deleteOnExit();
        out = new FileOutputStream(file);
        out = new GZIPOutputStream(out);
        try {
            content = file.getAbsolutePath();
            out.write(content.getBytes());
        }
        finally {
            out.close();
        }
        return content;
    }

    public void testPutForbidden() throws Exception {
        try {
            this.runTestPut(403);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testPut404() throws Exception {
        try {
            this.runTestPut(404);
            HttpWagonTestCase.fail();
        }
        catch (ResourceDoesNotExistException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testPut500() throws Exception {
        try {
            this.runTestPut(500);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPut429() throws Exception {
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Server server = new Server(0);
            final AtomicBoolean called = new AtomicBoolean();
            AbstractHandler handler = new AbstractHandler(){

                public void handle(String s, HttpServletRequest request, HttpServletResponse response, int i) throws IOException, ServletException {
                    if (called.get()) {
                        response.setStatus(500);
                        ((Request)request).setHandled(true);
                    } else {
                        called.set(true);
                        response.setStatus(429);
                        ((Request)request).setHandled(true);
                    }
                }
            };
            server.setHandler((Handler)handler);
            this.addConnectors(server);
            server.start();
            wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
            File tempFile = File.createTempFile("wagon", "tmp");
            tempFile.deleteOnExit();
            FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)"content");
            try {
                wagon.put(tempFile, "resource");
                HttpWagonTestCase.fail();
            }
            finally {
                wagon.disconnect();
                server.stop();
                tempFile.delete();
            }
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestPut(int status) throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = new Server(0);
        StatusHandler handler = new StatusHandler();
        handler.setStatusToReturn(status);
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
        File tempFile = File.createTempFile("wagon", "tmp");
        tempFile.deleteOnExit();
        FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)"content");
        try {
            wagon.put(tempFile, "resource");
            HttpWagonTestCase.fail();
        }
        finally {
            wagon.disconnect();
            server.stop();
            tempFile.delete();
        }
    }

    public void testSecuredPutUnauthorized() throws Exception {
        try {
            this.runTestSecuredPut(null);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredPutWrongPassword() throws Exception {
        try {
            AuthenticationInfo authInfo = new AuthenticationInfo();
            authInfo.setUserName("user");
            authInfo.setPassword("admin");
            this.runTestSecuredPut(authInfo);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredPut() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredPut(authInfo);
    }

    public void runTestSecuredPut(AuthenticationInfo authInfo) throws Exception {
        this.runTestSecuredPut(authInfo, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredPut(AuthenticationInfo authInfo, int putNumber) throws Exception {
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = new Server(0);
        TestSecurityHandler sh = this.createSecurityHandler();
        PutHandler putHandler = new PutHandler(new File(localRepositoryPath));
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{sh, putHandler});
        server.setHandler((Handler)handlers);
        this.addConnectors(server);
        server.start();
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
        wagon.connect(testRepository, authInfo);
        try {
            for (int i = 0; i < putNumber; ++i) {
                File sourceFile = new File(localRepositoryPath, "test-secured-put-resource");
                sourceFile.delete();
                HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
                File tempFile = File.createTempFile("wagon", "tmp");
                tempFile.deleteOnExit();
                FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)"put top secret");
                try {
                    wagon.put(tempFile, "test-secured-put-resource");
                }
                finally {
                    tempFile.delete();
                }
                HttpWagonTestCase.assertEquals((String)"put top secret", (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
            }
        }
        finally {
            wagon.disconnect();
            server.stop();
        }
        HttpWagonTestCase.assertEquals((int)putNumber, (int)putHandler.putCallNumber);
        this.testPreemptiveAuthenticationPut(sh, this.supportPreemptiveAuthenticationPut());
    }

    public void testNonSecuredPutFromStream() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredPutFromStream(authInfo, 1, false);
    }

    public void testSecuredPutFromStream() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredPutFromStream(authInfo, 1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredPutFromStream(AuthenticationInfo authInfo, int putNumber, boolean addSecurityHandler) throws Exception {
        Handler[] handlerArray;
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = new Server(0);
        TestSecurityHandler sh = this.createSecurityHandler();
        PutHandler putHandler = new PutHandler(new File(localRepositoryPath));
        HandlerCollection handlers = new HandlerCollection();
        if (addSecurityHandler) {
            Handler[] handlerArray2 = new Handler[2];
            handlerArray2[0] = sh;
            handlerArray = handlerArray2;
            handlerArray2[1] = putHandler;
        } else {
            Handler[] handlerArray3 = new Handler[1];
            handlerArray = handlerArray3;
            handlerArray3[0] = putHandler;
        }
        handlers.setHandlers(handlerArray);
        server.setHandler((Handler)handlers);
        this.addConnectors(server);
        server.start();
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
        if (addSecurityHandler) {
            wagon.connect(testRepository, authInfo);
        } else {
            wagon.connect(testRepository);
        }
        try {
            for (int i = 0; i < putNumber; ++i) {
                File sourceFile = new File(localRepositoryPath, "test-secured-put-resource");
                sourceFile.delete();
                HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
                File tempFile = File.createTempFile("wagon", "tmp");
                tempFile.deleteOnExit();
                String content = "put top secret";
                FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)content);
                FileInputStream fileInputStream = new FileInputStream(tempFile);
                try {
                    wagon.putFromStream((InputStream)fileInputStream, "test-secured-put-resource", (long)content.length(), -1L);
                }
                finally {
                    fileInputStream.close();
                    tempFile.delete();
                }
                HttpWagonTestCase.assertEquals((String)content, (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
            }
        }
        finally {
            wagon.disconnect();
            server.stop();
        }
        HttpWagonTestCase.assertEquals((int)putNumber, (int)putHandler.putCallNumber);
        if (addSecurityHandler) {
            this.testPreemptiveAuthenticationPut(sh, this.supportPreemptiveAuthenticationPut());
        }
        for (DeployedResource deployedResource : putHandler.deployedResources) {
            if (!StringUtils.equalsIgnoreCase((String)"chunked", (String)deployedResource.transferEncoding)) continue;
            HttpWagonTestCase.fail((String)("deployedResource use chunked: " + deployedResource));
        }
    }

    protected abstract boolean supportPreemptiveAuthenticationPut();

    protected abstract boolean supportPreemptiveAuthenticationGet();

    protected abstract boolean supportProxyPreemptiveAuthentication();

    protected void testPreemptiveAuthenticationGet(TestSecurityHandler sh, boolean preemptive) {
        this.testPreemptiveAuthentication(sh, preemptive);
    }

    protected void testPreemptiveAuthenticationPut(TestSecurityHandler sh, boolean preemptive) {
        this.testPreemptiveAuthentication(sh, preemptive);
    }

    protected void testPreemptiveAuthentication(TestSecurityHandler sh, boolean preemptive) {
        if (preemptive) {
            HttpWagonTestCase.assertEquals((String)("not 1 security handler use " + sh.handlerRequestResponses), (int)1, (int)sh.handlerRequestResponses.size());
            HttpWagonTestCase.assertEquals((int)200, (int)sh.handlerRequestResponses.get((int)0).responseCode);
        } else {
            HttpWagonTestCase.assertEquals((String)("not 2 security handler use " + sh.handlerRequestResponses), (int)2, (int)sh.handlerRequestResponses.size());
            HttpWagonTestCase.assertEquals((int)401, (int)sh.handlerRequestResponses.get((int)0).responseCode);
            HttpWagonTestCase.assertEquals((int)200, (int)sh.handlerRequestResponses.get((int)1).responseCode);
        }
    }

    protected TestSecurityHandler createSecurityHandler() {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"admin"});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        TestSecurityHandler sh = new TestSecurityHandler();
        HashUserRealm hashUserRealm = new HashUserRealm("MyRealm");
        hashUserRealm.put((Object)"user", (Object)"secret");
        hashUserRealm.addUserToRole("user", "admin");
        sh.setUserRealm((UserRealm)hashUserRealm);
        sh.setConstraintMappings(new ConstraintMapping[]{cm});
        return sh;
    }

    public static class HandlerRequestResponse {
        public String method;
        public int responseCode;
        public String requestUri;

        private HandlerRequestResponse(String method, int responseCode, String requestUri) {
            this.method = method;
            this.responseCode = responseCode;
            this.requestUri = requestUri;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("HandlerRequestResponse");
            sb.append("{method='").append(this.method).append('\'');
            sb.append(", responseCode=").append(this.responseCode);
            sb.append(", requestUri='").append(this.requestUri).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static class TestSecurityHandler
    extends SecurityHandler {
        public List<HandlerRequestResponse> handlerRequestResponses = new ArrayList<HandlerRequestResponse>();

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            String method = request.getMethod();
            super.handle(target, request, response, dispatch);
            this.handlerRequestResponses.add(new HandlerRequestResponse(method, ((Response)response).getStatus(), request.getRequestURI()));
        }
    }

    private static class TestHeaderHandler
    extends AbstractHandler {
        public Map<String, String> headers = Collections.emptyMap();
        public List<HandlerRequestResponse> handlerRequestResponses = new ArrayList<HandlerRequestResponse>();

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            this.headers = new HashMap<String, String>();
            Enumeration e = request.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Enumeration headerValues = request.getHeaders(name);
                StringBuffer combinedHeaderValue = new StringBuffer();
                int i = 0;
                while (headerValues.hasMoreElements()) {
                    if (i > 0) {
                        combinedHeaderValue.append(",");
                    }
                    combinedHeaderValue.append(headerValues.nextElement());
                    ++i;
                }
                this.headers.put(name, combinedHeaderValue.toString());
            }
            response.setContentType("text/plain");
            response.setStatus(200);
            response.getWriter().print("Hello, World!");
            this.handlerRequestResponses.add(new HandlerRequestResponse(request.getMethod(), ((Response)response).getStatus(), request.getRequestURI()));
            ((Request)request).setHandled(true);
        }
    }

    private static class AuthorizingProxyHandler
    extends TestHeaderHandler {
        List<HandlerRequestResponse> handlerRequestResponses = new ArrayList<HandlerRequestResponse>();

        private AuthorizingProxyHandler() {
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            System.out.println(" handle proxy request");
            if (request.getHeader("Proxy-Authorization") == null) {
                this.handlerRequestResponses.add(new HandlerRequestResponse(request.getMethod(), 407, request.getRequestURI()));
                response.setStatus(407);
                response.addHeader("Proxy-Authenticate", "Basic realm=\"Squid proxy-caching web server\"");
                ((Request)request).setHandled(true);
                return;
            }
            this.handlerRequestResponses.add(new HandlerRequestResponse(request.getMethod(), 200, request.getRequestURI()));
            super.handle(target, request, response, dispatch);
        }
    }

    public static class PutHandler
    extends AbstractHandler {
        private final File resourceBase;
        public List<DeployedResource> deployedResources = new ArrayList<DeployedResource>();
        public int putCallNumber = 0;
        public List<HandlerRequestResponse> handlerRequestResponses = new ArrayList<HandlerRequestResponse>();

        public PutHandler(File repositoryDirectory) {
            this.resourceBase = repositoryDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            Request baseRequest;
            Request request2 = baseRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
            if (baseRequest.isHandled() || !"PUT".equals(baseRequest.getMethod())) {
                return;
            }
            baseRequest.setHandled(true);
            File file = new File(this.resourceBase, URLDecoder.decode(request.getPathInfo()));
            file.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(file);
            ServletInputStream in = request.getInputStream();
            try {
                IOUtil.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                in.close();
                out.close();
            }
            ++this.putCallNumber;
            DeployedResource deployedResource = new DeployedResource();
            deployedResource.httpMethod = request.getMethod();
            deployedResource.requestUri = request.getRequestURI();
            deployedResource.transferEncoding = request.getHeader("Transfer-Encoding");
            deployedResource.contentLength = request.getHeader("Content-Length");
            this.deployedResources.add(deployedResource);
            response.setStatus(201);
            this.handlerRequestResponses.add(new HandlerRequestResponse(request.getMethod(), ((Response)response).getStatus(), request.getRequestURI()));
        }
    }

    static class DeployedResource {
        String httpMethod;
        String requestUri;
        String contentLength;
        String transferEncoding;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DeployedResource");
            sb.append("{httpMethod='").append(this.httpMethod).append('\'');
            sb.append(", requestUri='").append(this.requestUri).append('\'');
            sb.append(", contentLength='").append(this.contentLength).append('\'');
            sb.append(", transferEncoding='").append(this.transferEncoding).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    static class StatusHandler
    extends AbstractHandler {
        private int status;

        StatusHandler() {
        }

        public void setStatusToReturn(int status) {
            this.status = status;
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            if (this.status != 0) {
                response.setStatus(this.status);
                ((Request)request).setHandled(true);
            }
        }
    }

    public static class RedirectHandler
    extends AbstractHandler {
        String reason;
        int retCode;
        String redirectUrl;
        File repositoryDirectory;
        public List<HandlerRequestResponse> handlerRequestResponses = new ArrayList<HandlerRequestResponse>();

        RedirectHandler(String reason, int retCode, String redirectUrl, File repositoryDirectory) {
            this.reason = reason;
            this.retCode = retCode;
            this.redirectUrl = redirectUrl;
            this.repositoryDirectory = repositoryDirectory;
        }

        public void handle(String s, HttpServletRequest req, HttpServletResponse resp, int i) throws IOException, ServletException {
            if (req.getRequestURI().contains("redirectRequest")) {
                PutHandler putHandler = new PutHandler(this.repositoryDirectory);
                putHandler.handle(s, req, resp, i);
                this.handlerRequestResponses.add(new HandlerRequestResponse(req.getMethod(), ((Response)resp).getStatus(), req.getRequestURI()));
                return;
            }
            resp.setStatus(this.retCode);
            resp.sendRedirect(this.redirectUrl + "/" + req.getRequestURI());
            this.handlerRequestResponses.add(new HandlerRequestResponse(req.getMethod(), ((Response)resp).getStatus(), req.getRequestURI()));
        }
    }
}

