/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.codec.delimited;

import org.apache.mina.codec.IoBuffer;
import org.apache.mina.codec.ProtocolDecoder;
import org.apache.mina.codec.delimited.IoBufferDecoder;

public class SizePrefixedDecoder<OUT>
implements ProtocolDecoder<IoBuffer, OUT, MutableInt> {
    private final IoBufferDecoder<Integer> sizeDecoder;
    private final IoBufferDecoder<OUT> payloadDecoder;

    public SizePrefixedDecoder(IoBufferDecoder<Integer> sizeDecoder, IoBufferDecoder<OUT> payloadDecoder) {
        this.sizeDecoder = sizeDecoder;
        this.payloadDecoder = payloadDecoder;
    }

    @Override
    public MutableInt createDecoderState() {
        return new MutableInt();
    }

    @Override
    public OUT decode(IoBuffer input, MutableInt nextBlockSize) {
        OUT output = null;
        if (nextBlockSize.getValue() == null) {
            nextBlockSize.setValue(this.sizeDecoder.decode(input));
        }
        if (nextBlockSize.isDefined() && input.remaining() >= nextBlockSize.getValue()) {
            IoBuffer buffer = input.slice();
            buffer.limit(buffer.position() + nextBlockSize.getValue());
            output = this.payloadDecoder.decode(buffer);
            nextBlockSize.reset();
        }
        return output;
    }

    @Override
    public void finishDecode(MutableInt context) {
    }

    protected static final class MutableInt {
        private Integer value = null;

        private MutableInt() {
        }

        public Integer getValue() {
            return this.value;
        }

        public boolean isDefined() {
            return this.value != null;
        }

        public void reset() {
            this.value = null;
        }

        public void setValue(Integer value) {
            this.value = value;
        }
    }
}

