/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.codec.delimited;

import java.nio.ByteBuffer;
import org.apache.mina.codec.StatelessProtocolEncoder;
import org.apache.mina.codec.delimited.ByteBufferEncoder;

public class SizePrefixedEncoder<IN>
implements StatelessProtocolEncoder<IN, ByteBuffer> {
    private final ByteBufferEncoder<Integer> sizeEncoder;
    private final ByteBufferEncoder<IN> payloadEncoder;

    public SizePrefixedEncoder(ByteBufferEncoder<Integer> sizeEncoder, ByteBufferEncoder<IN> payloadEncoder) {
        this.sizeEncoder = sizeEncoder;
        this.payloadEncoder = payloadEncoder;
    }

    @Override
    public Void createEncoderState() {
        return null;
    }

    @Override
    public ByteBuffer encode(IN message, Void context) {
        int messageSize = this.payloadEncoder.getEncodedSize(message);
        ByteBuffer buffer = ByteBuffer.allocate(this.sizeEncoder.getEncodedSize(messageSize) + messageSize);
        this.sizeEncoder.writeTo(messageSize, buffer);
        this.payloadEncoder.writeTo(message, buffer);
        buffer.flip();
        return buffer;
    }
}

