/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.codec.textline;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.mina.codec.StatelessProtocolEncoder;
import org.apache.mina.codec.textline.LineDelimiter;

public class TextLineEncoder
implements StatelessProtocolEncoder<String, ByteBuffer> {
    private final CharsetEncoder charsetEncoder;
    private final LineDelimiter delimiter;
    private int maxLineLength = Integer.MAX_VALUE;

    public TextLineEncoder() {
        this(Charset.defaultCharset(), LineDelimiter.UNIX);
    }

    public TextLineEncoder(String delimiter) {
        this(new LineDelimiter(delimiter));
    }

    public TextLineEncoder(LineDelimiter delimiter) {
        this(Charset.defaultCharset(), delimiter);
    }

    public TextLineEncoder(Charset charset) {
        this(charset, LineDelimiter.UNIX);
    }

    public TextLineEncoder(Charset charset, String delimiter) {
        this(charset, new LineDelimiter(delimiter));
    }

    public TextLineEncoder(Charset charset, LineDelimiter delimiter) {
        if (charset == null) {
            throw new IllegalArgumentException("charset");
        }
        if (delimiter == null) {
            throw new IllegalArgumentException("delimiter");
        }
        if (LineDelimiter.AUTO.equals(delimiter)) {
            throw new IllegalArgumentException("AUTO delimiter is not allowed for encoder.");
        }
        this.charsetEncoder = charset.newEncoder();
        this.delimiter = delimiter;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        if (maxLineLength <= 0) {
            throw new IllegalArgumentException("maxLineLength: " + maxLineLength);
        }
        this.maxLineLength = maxLineLength;
    }

    @Override
    public Void createEncoderState() {
        return null;
    }

    @Override
    public ByteBuffer encode(String message, Void context) {
        try {
            String value;
            String string = value = message == null ? "" : message;
            if (value.length() > this.maxLineLength) {
                throw new IllegalArgumentException("Line length: " + message.length());
            }
            return this.charsetEncoder.encode(CharBuffer.wrap(value + this.delimiter.getValue()));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }
}

