/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.style;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.style.StylePageLayoutNameAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStylePageLayout;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.odfdom.type.Percent;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.style.DefaultStyleHandler;
import org.odftoolkit.simple.style.PageLayoutProperties;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.w3c.dom.Node;

public class MasterPage {
    private StyleMasterPageElement mStyleMasterPageElement;
    private StyleHandlerImpl mStyleHandler;

    MasterPage(StyleMasterPageElement styleMasterPageElement) {
        this.mStyleMasterPageElement = styleMasterPageElement;
    }

    public static MasterPage getOrCreateMasterPage(Document doc, String name) throws Exception {
        OdfOfficeMasterStyles officeMasterStyles = doc.getOfficeMasterStyles();
        StyleMasterPageElement master = officeMasterStyles.getMasterPage(name);
        if (master == null) {
            master = (StyleMasterPageElement)doc.getStylesDom().newOdfElement(StyleMasterPageElement.class);
            master.setStyleNameAttribute(name);
            officeMasterStyles.appendChild((Node)master);
        }
        return new MasterPage(master);
    }

    StyleHandlerImpl getPageLayoutStyleHandler() {
        if (this.mStyleHandler != null) {
            return this.mStyleHandler;
        }
        this.mStyleHandler = new StyleHandlerImpl((OdfStylableElement)this.mStyleMasterPageElement);
        return this.mStyleHandler;
    }

    public String getName() {
        return this.mStyleMasterPageElement.getStyleNameAttribute();
    }

    public double getMarginTop() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getMarginTop();
    }

    public double getMarginRight() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getMarginRight();
    }

    public double getMarginLeft() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getMarginLeft();
    }

    public double getMarginBottom() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getMarginBottom();
    }

    public void setMargins(double marginTop, double marginBottom, double marginLeft, double marginRight) throws Exception {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForWrite();
        properties.setMarginTop(marginTop);
        properties.setMarginBottom(marginBottom);
        properties.setMarginLeft(marginLeft);
        properties.setMarginRight(marginRight);
    }

    public double getPageWidth() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getPageWidth();
    }

    public void setPageWidth(double pageWidth) throws Exception {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForWrite();
        properties.setPageWidth(pageWidth);
    }

    public double getPageHeight() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getPageHeight();
    }

    public void setPageHeight(double pageHeight) throws Exception {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForWrite();
        properties.setPageHeight(pageHeight);
    }

    public String getNumberFormat() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getNumberFormat();
    }

    public void setNumberFormat(String format) throws Exception {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForWrite();
        properties.setNumberFormat(format);
    }

    public String getPrintOrientation() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getPrintOrientation();
    }

    public void setPrintOrientation(StyleTypeDefinitions.PrintOrientation orientation) throws Exception {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForWrite();
        properties.setPrintOrientation(orientation);
    }

    public String getWritingMode() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getWritingMode();
    }

    public void setWritingMode(StyleTypeDefinitions.WritingMode mode) throws Exception {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForWrite();
        properties.setWritingMode(mode);
    }

    public double getFootnoteMaxHeight() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getFootnoteMaxHeight();
    }

    public void setFootnoteMaxHeight(double height) throws Exception {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForWrite();
        properties.setFootnoteMaxHeight(height);
    }

    public String getFootnoteSepAdjustment() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getFootnoteSepAdjustment();
    }

    public String getFootnoteSepColor() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getFootnoteSepColor();
    }

    public double getFootnoteSepDistanceAfterSep() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getFootnoteSepDistanceAfterSep();
    }

    public double getFootnoteSepDistanceBeforeSep() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getFootnoteSepDistanceBeforeSep();
    }

    public String getFootnoteSepLineStyle() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getFootnoteSepLineStyle();
    }

    public double getFootnoteSepWidth() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getFootnoteSepWidth();
    }

    public double getFootnoteSepThickness() {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForRead();
        return properties.getFootnoteSepThickness();
    }

    public void setFootnoteSepProperties(StyleTypeDefinitions.AdjustmentStyle adjustment, Color color, double distanceAfterSep, double distanceBeforeSep, StyleTypeDefinitions.LineStyle lineStyle, Percent width, double thickness) throws Exception {
        PageLayoutProperties properties = this.getPageLayoutStyleHandler().getPageLayoutPropertiesForWrite();
        properties.setFootnoteSepProperties(adjustment, color, distanceAfterSep, distanceBeforeSep, lineStyle, width, thickness);
    }

    class StyleHandlerImpl {
        private OdfStylePageLayout mWritableStyleElement;
        private OdfStyleBase mStyleElement;
        private PageLayoutProperties mPageLayoutProperties;
        private PageLayoutProperties mWritablePageLayoutProperties;
        private OdfStylableElement mOdfElement;
        private Document mDocument;

        public StyleHandlerImpl(OdfStylableElement element) {
            this.mOdfElement = element;
            this.mDocument = (Document)((OdfFileDom)this.mOdfElement.getOwnerDocument()).getDocument();
        }

        public PageLayoutProperties getPageLayoutPropertiesForRead() {
            if (this.mWritablePageLayoutProperties != null) {
                return this.mWritablePageLayoutProperties;
            }
            if (this.mPageLayoutProperties != null) {
                return this.mPageLayoutProperties;
            }
            OdfStyleBase style = this.getPageLayoutElementForRead();
            if (style == null) {
                Logger.getLogger(DefaultStyleHandler.class.getName()).log(Level.FINE, "No style definition is found!", "");
                return null;
            }
            this.mPageLayoutProperties = PageLayoutProperties.getPageLayoutProperties(style);
            if (this.mPageLayoutProperties != null) {
                return this.mPageLayoutProperties;
            }
            Logger.getLogger(DefaultStyleHandler.class.getName()).log(Level.FINE, "No explicit pageLayout properties definition is found!", "");
            return null;
        }

        public PageLayoutProperties getPageLayoutPropertiesForWrite() throws Exception {
            if (this.mWritablePageLayoutProperties != null) {
                return this.mWritablePageLayoutProperties;
            }
            OdfStylePageLayout style = this.getPageLayoutElementForWrite();
            this.mWritablePageLayoutProperties = PageLayoutProperties.getOrCreatePageLayoutProperties((OdfStyleBase)style);
            return this.mWritablePageLayoutProperties;
        }

        public OdfStyleBase getPageLayoutElementForRead() {
            if (this.getCurrentUsedStyle() != null) {
                return this.getCurrentUsedStyle();
            }
            String styleName = this.getUsedPageLayoutStyleName();
            this.mStyleElement = this.getReadableStyleElementByName(styleName);
            return this.mStyleElement;
        }

        public OdfStylePageLayout getPageLayoutElementForWrite() throws Exception {
            if (this.mWritableStyleElement != null) {
                return this.mWritableStyleElement;
            }
            String styleName = this.getUsedPageLayoutStyleName();
            this.mWritableStyleElement = this.getWritableStyleElementByName(styleName, false);
            return this.mWritableStyleElement;
        }

        protected OdfStyleBase getReadableStyleElementByName(String styleName) {
            if (styleName == null || styleName.equals("")) {
                // empty if block
            }
            OdfStylePageLayout styleElement = this.mOdfElement.getAutomaticStyles().getPageLayout(styleName);
            return styleElement;
        }

        protected OdfStylePageLayout getWritableStyleElementByName(String styleName, boolean isShared) throws Exception {
            boolean createNew = isShared;
            OdfStylePageLayout pageLayout = null;
            OdfOfficeAutomaticStyles styles = this.mOdfElement.getAutomaticStyles();
            if (styleName == null || styleName.equals("")) {
                createNew = true;
            } else {
                styles = this.mOdfElement.getAutomaticStyles();
                pageLayout = styles.getPageLayout(styleName);
                if (pageLayout == null || pageLayout.getStyleUserCount() > 1) {
                    createNew = true;
                }
            }
            if (createNew) {
                OdfStylePageLayout newPageLayout = null;
                if (pageLayout != null) {
                    newPageLayout = (OdfStylePageLayout)pageLayout.cloneNode(true);
                }
                newPageLayout = (OdfStylePageLayout)this.mDocument.getStylesDom().newOdfElement(StylePageLayoutElement.class);
                String newname = this.newUniquePageLayoutName();
                newPageLayout.setStyleNameAttribute(newname);
                styles.appendChild((Node)newPageLayout);
                this.mOdfElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:page-layout-name", newname);
                newPageLayout.addStyleUser(this.mOdfElement);
                return newPageLayout;
            }
            return pageLayout;
        }

        private String newUniquePageLayoutName() {
            String unique_name;
            OdfOfficeAutomaticStyles styles = this.mOdfElement.getAutomaticStyles();
            while (styles.getPageLayout(unique_name = String.format("a%06x", (int)(Math.random() * 1.6777215E7))) != null) {
            }
            return unique_name;
        }

        private OdfStyleBase getCurrentUsedStyle() {
            if (this.mWritableStyleElement != null) {
                return this.mWritableStyleElement;
            }
            return this.mStyleElement;
        }

        public String getUsedPageLayoutStyleName() {
            return this.mOdfElement.getAttribute(StylePageLayoutNameAttribute.ATTRIBUTE_NAME.getQName());
        }
    }
}

