/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.table;

import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowsElement;
import org.odftoolkit.simple.table.DomNodeList;
import org.odftoolkit.simple.table.Table;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class RepeatedNumberUtils {
    private static final int LIBRE_OFFICE_WORKAROUND_COLCOUNT = 1024;
    private static final int LIBRE_OFFICE_WORKAROUND_ROWCOUNT = 0x100000;
    private static final int MS_EXCEL_BINARY_WORKAROUND_ROWCOUNT = 32768;

    public static void removeDummyCellsFromTable(Table table) {
        int n;
        int wholeColumnCount = 0;
        int wholeRowCount = 0;
        int maxCellCount = 0;
        TableTableColumnElement lastColumnNode = null;
        TableTableRowElement msExcelDummyRow = null;
        for (Node node : new DomNodeList(table.getOdfElement().getChildNodes())) {
            if (node instanceof TableTableHeaderColumnsElement) {
                wholeColumnCount += RepeatedNumberUtils._getHeaderColumnCount((TableTableHeaderColumnsElement)node);
                lastColumnNode = null;
            } else if (node instanceof TableTableColumnsElement) {
                wholeColumnCount += RepeatedNumberUtils._getColumnsCount((TableTableColumnsElement)node);
                lastColumnNode = null;
            } else if (node instanceof TableTableColumnElement) {
                wholeColumnCount += RepeatedNumberUtils._getNumberColumnsRepeated((TableTableColumnElement)node);
                lastColumnNode = (TableTableColumnElement)node;
            }
            if (node instanceof TableTableHeaderRowsElement) {
                wholeRowCount += RepeatedNumberUtils._getHeaderRowCount((TableTableHeaderRowsElement)node);
                int n2 = RepeatedNumberUtils._getCellCountOfRowWithoutDummies(node);
                maxCellCount = n2 > maxCellCount ? n2 : maxCellCount;
                continue;
            }
            if (node instanceof TableTableRowElement) {
                int n3;
                if ((wholeRowCount += RepeatedNumberUtils._getNumberRowsRepeated((TableTableRowElement)node)) == 32768) {
                    msExcelDummyRow = (TableTableRowElement)node;
                }
                maxCellCount = (n3 = RepeatedNumberUtils._getCellCountOfRowWithoutDummies(node)) > maxCellCount ? n3 : maxCellCount;
                continue;
            }
            if (!(node instanceof TableTableRowsElement)) continue;
            for (Node nodeChild : new DomNodeList(node.getChildNodes())) {
                if (!(nodeChild instanceof TableTableRowElement)) continue;
                wholeRowCount += RepeatedNumberUtils._getNumberRowsRepeated((TableTableRowElement)nodeChild);
                int n4 = RepeatedNumberUtils._getCellCountOfRowWithoutDummies(node);
                maxCellCount = n4 > maxCellCount ? n4 : maxCellCount;
            }
        }
        if (wholeRowCount == 0x100000) {
            boolean done = false;
            for (int nodeIndex = table.getOdfElement().getChildNodes().getLength() - 1; !done && nodeIndex > 0; --nodeIndex) {
                Node node = table.getOdfElement().getChildNodes().item(nodeIndex);
                if (node instanceof TableTableHeaderRowsElement || node instanceof TableTableRowsElement) {
                    done = true;
                    continue;
                }
                if (!(node instanceof TableTableRowElement)) continue;
                if (RepeatedNumberUtils._isEmptyDummyRow((TableTableRowElement)node)) {
                    table.getOdfElement().removeChild(node);
                    continue;
                }
                done = true;
            }
        }
        if (msExcelDummyRow != null && msExcelDummyRow == table.getOdfElement().getLastChild()) {
            try {
                table.getOdfElement().removeChild(msExcelDummyRow);
            }
            catch (DOMException e) {
                // empty catch block
            }
        }
        if (wholeColumnCount == 1024 && lastColumnNode != null && (n = RepeatedNumberUtils._getNumberColumnsRepeated(lastColumnNode)) > 1) {
            int realColumnCount = wholeColumnCount - n;
            if (realColumnCount < maxCellCount) {
                lastColumnNode.setTableNumberColumnsRepeatedAttribute(Integer.valueOf(maxCellCount - realColumnCount));
            } else {
                table.getOdfElement().removeChild((Node)lastColumnNode);
            }
        }
    }

    private static int _getCellCountOfRowWithoutDummies(Node row) {
        int cellCount = 0;
        Node lastCell = row.getLastChild();
        for (Node node : new DomNodeList(row.getChildNodes())) {
            Integer spanned;
            if (!(node instanceof TableTableCellElement)) continue;
            TableTableCellElement cell = (TableTableCellElement)node;
            Integer repCnt = cell.getTableNumberColumnsRepeatedAttribute();
            if (repCnt == null) {
                repCnt = 1;
            }
            if ((spanned = cell.getTableNumberColumnsSpannedAttribute()) == null || spanned == 0) {
                spanned = 1;
            }
            if (node == lastCell && repCnt != 1 && spanned == 1) continue;
            cellCount += repCnt * spanned;
        }
        return cellCount;
    }

    private static int _getNumberRowsRepeated(TableTableRowElement rowElement) {
        int numberRowsRepeated = 0;
        if (rowElement != null) {
            Integer repCnt = rowElement.getTableNumberRowsRepeatedAttribute();
            numberRowsRepeated = repCnt == null ? 1 : repCnt;
        }
        return numberRowsRepeated;
    }

    static int _getNumberColumnsRepeated(TableTableColumnElement columnElement) {
        int numberColumnsRepeated = 0;
        if (columnElement != null) {
            Integer repCnt = columnElement.getTableNumberColumnsRepeatedAttribute();
            numberColumnsRepeated = repCnt == null ? 1 : repCnt;
        }
        return numberColumnsRepeated;
    }

    private static int _getHeaderColumnCount(TableTableHeaderColumnsElement headers) {
        int result = 0;
        if (headers != null) {
            for (Node n : new DomNodeList(headers.getChildNodes())) {
                result += RepeatedNumberUtils._getNumberColumnsRepeated((TableTableColumnElement)n);
            }
        }
        return result;
    }

    private static int _getColumnsCount(TableTableColumnsElement columns) {
        int result = 0;
        if (columns != null) {
            for (Node n : new DomNodeList(columns.getChildNodes())) {
                result += RepeatedNumberUtils._getNumberColumnsRepeated((TableTableColumnElement)n);
            }
        }
        return result;
    }

    private static int _getHeaderRowCount(TableTableHeaderRowsElement headers) {
        int result = 0;
        if (headers != null) {
            for (Node n : new DomNodeList(headers.getChildNodes())) {
                if (!(n instanceof TableTableRowElement)) continue;
                result += RepeatedNumberUtils._getNumberRowsRepeated((TableTableRowElement)n);
            }
        }
        return result;
    }

    private static boolean _isEmptyDummyRow(TableTableRowElement row) {
        boolean dummyRow = true;
        for (Node child = row.getChildNodes().item(0); dummyRow && child != null; child = child.getNextSibling()) {
            dummyRow = child instanceof TableTableCellElement ? child.getChildNodes().getLength() == 0 : false;
        }
        return dummyRow;
    }
}

