/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.util.ObjUtil;

public class StdAttributeValue<T>
implements AttributeValue<T> {
    private Identifier dataTypeId;
    private T value;
    private Identifier xpathCategory;

    public StdAttributeValue(Identifier dataTypeIdIn, T valueIn, Identifier xpathCategoryIn) {
        this.dataTypeId = dataTypeIdIn;
        this.value = valueIn;
        this.xpathCategory = xpathCategoryIn;
    }

    public StdAttributeValue(Identifier dataTypeIdIn, T valueIn) {
        this(dataTypeIdIn, valueIn, null);
    }

    @Override
    public Identifier getDataTypeId() {
        return this.dataTypeId;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataTypeId == null ? 0 : this.dataTypeId.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.xpathCategory == null ? 0 : this.xpathCategory.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().isInstance(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AttributeValue attributeValueObj = (AttributeValue)this.getClass().cast(obj);
        return ObjUtil.equalsAllowNull(this.getDataTypeId(), attributeValueObj.getDataTypeId()) && ObjUtil.equalsAllowNull(this.getValue(), attributeValueObj.getValue());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        Identifier objectToDump = null;
        objectToDump = this.getDataTypeId();
        if (objectToDump != null) {
            stringBuilder.append("dataTypeId=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getValue()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("value=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getXPathCategory()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("xpathCategory=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Identifier getXPathCategory() {
        return this.xpathCategory;
    }
}

