/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeCategory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.util.ListUtil;
import org.apache.openaz.xacml.util.ObjUtil;

public class StdMutableAttributeCategory
implements AttributeCategory {
    private static final List<Attribute> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    protected Log logger = LogFactory.getLog(this.getClass());
    private Identifier category;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private Map<Identifier, List<Attribute>> attributesById = new HashMap<Identifier, List<Attribute>>();

    private void buildMap() {
        for (Attribute attribute : this.attributes) {
            List<Attribute> listAttributes = this.attributesById.get(attribute.getAttributeId());
            if (listAttributes == null) {
                listAttributes = new ArrayList<Attribute>();
                this.attributesById.put(attribute.getAttributeId(), listAttributes);
            }
            listAttributes.add(attribute);
        }
    }

    public StdMutableAttributeCategory() {
    }

    public StdMutableAttributeCategory(Identifier identifierCategory, Collection<Attribute> listAttributes) {
        this.category = identifierCategory;
        if (listAttributes != null) {
            this.attributes.addAll(listAttributes);
            this.buildMap();
        }
    }

    public StdMutableAttributeCategory(AttributeCategory attributeCategory) {
        this.category = attributeCategory.getCategory();
        this.attributes.addAll(attributeCategory.getAttributes());
        this.buildMap();
    }

    @Override
    public Identifier getCategory() {
        return this.category;
    }

    public void setCategory(Identifier identifierCategory) {
        this.category = identifierCategory;
    }

    @Override
    public Collection<Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes);
    }

    public void add(Attribute attribute) {
        this.attributes.add(attribute);
        List<Attribute> listAttributes = this.attributesById.get(attribute.getAttributeId());
        if (listAttributes == null) {
            listAttributes = new ArrayList<Attribute>();
            this.attributesById.put(attribute.getAttributeId(), listAttributes);
        }
        listAttributes.add(attribute);
    }

    @Override
    public Iterator<Attribute> getAttributes(Identifier attributeId) {
        List<Attribute> listAttributes = this.attributesById.get(attributeId);
        return listAttributes == null ? EMPTY_LIST.iterator() : listAttributes.iterator();
    }

    @Override
    public boolean hasAttributes(Identifier attributeId) {
        List<Attribute> listAttributes = this.attributesById.get(attributeId);
        return listAttributes != null && listAttributes.size() > 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AttributeCategory)) {
            return false;
        }
        AttributeCategory objAttributeCategory = (AttributeCategory)obj;
        return ObjUtil.equalsAllowNull(this.getCategory(), objAttributeCategory.getCategory()) && ListUtil.equalsAllowNulls(this.getAttributes(), objAttributeCategory.getAttributes());
    }

    public int hashCode() {
        int result = 17;
        if (this.getCategory() != null) {
            result = 31 * result + this.getCategory().hashCode();
        }
        if (this.getAttributes() != null) {
            result = 31 * result + this.getAttributes().hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        Identifier objectToDump = this.getCategory();
        if (objectToDump != null) {
            stringBuilder.append("category=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if (this.attributes.size() > 0) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("attributes=");
            stringBuilder.append(ListUtil.toString(this.attributes));
            needsComma = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

