/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.openaz.xacml.api.SemanticString;
import org.apache.openaz.xacml.util.StringUtils;

public class Base64Binary
implements SemanticString {
    private byte[] data;

    public Base64Binary(byte[] dataIn) {
        this.data = dataIn;
    }

    public static Base64Binary newInstance(String stringBase64Binary) throws DecoderException {
        if (stringBase64Binary == null) {
            return null;
        }
        byte[] base64Bytes = new Base64().decode(stringBase64Binary);
        return new Base64Binary(base64Bytes);
    }

    public byte[] getData() {
        return this.data;
    }

    public int hashCode() {
        return this.getData() == null ? 0 : this.getData().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Base64Binary)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Base64Binary hexBinaryObj = (Base64Binary)obj;
        if (this.getData() == null) {
            return hexBinaryObj.getData() == null;
        }
        if (hexBinaryObj.getData() == null) {
            return false;
        }
        return Arrays.equals(this.getData(), hexBinaryObj.getData());
    }

    @Override
    public String stringValue() {
        if (this.getData() == null) {
            return null;
        }
        return Base64.encodeBase64String((byte[])this.getData());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        byte[] thisData = this.getData();
        if (thisData != null) {
            stringBuilder.append("data=");
            stringBuilder.append(StringUtils.toString(thisData));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

