/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Node;

public abstract class DataTypeBase<T>
implements DataType<T> {
    private Identifier id;
    private Class<T> classConvert;

    protected DataTypeBase(Identifier identifierIn, Class<T> classConvertIn) {
        this.id = identifierIn;
        this.classConvert = classConvertIn;
    }

    protected Class<T> getClassConvert() {
        return this.classConvert;
    }

    private Object collapse(Collection<?> objects) throws DataTypeException {
        if (objects == null || objects.size() == 0) {
            return "";
        }
        if (objects.size() == 1) {
            return objects.iterator().next();
        }
        Iterator<?> iterObjects = objects.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterObjects.hasNext()) {
            stringBuilder.append(this.convertToString(iterObjects.next()));
        }
        return stringBuilder.toString();
    }

    protected String convertToString(Object obj) throws DataTypeException {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (this.getClassConvert().isInstance(obj)) {
            return this.toStringValue(this.getClassConvert().cast(obj));
        }
        if (obj instanceof Node) {
            return ((Node)obj).getTextContent();
        }
        if (obj instanceof List) {
            return this.convertToString(this.collapse((Collection)obj));
        }
        return obj.toString();
    }

    @Override
    public Identifier getId() {
        return this.id;
    }

    @Override
    public AttributeValue<T> createAttributeValue(Object source) throws DataTypeException {
        if (source != null && source instanceof Node) {
            Identifier xpathCategory = null;
            try {
                xpathCategory = DOMUtil.getIdentifierAttribute((Node)source, "XPathCategory", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new StdAttributeValue(this.getId(), this.convert(source), xpathCategory);
        }
        return new StdAttributeValue(this.getId(), this.convert(source));
    }

    @Override
    public AttributeValue<T> createAttributeValue(Object source, Identifier xpathCategory) throws DataTypeException {
        return new StdAttributeValue(this.getId(), this.convert(source), xpathCategory);
    }

    @Override
    public AttributeValue<T> convertAttributeValue(AttributeValue<?> attributeValue) throws DataTypeException {
        if (attributeValue == null) {
            return null;
        }
        return new StdAttributeValue(this.getId(), this.convert(attributeValue.getValue()), attributeValue.getXPathCategory());
    }

    @Override
    public String toStringValue(T source) throws DataTypeException {
        return source == null ? null : source.toString();
    }
}

