/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.datatypes.DataTypeBase;

public class DataTypeBoolean
extends DataTypeBase<Boolean> {
    private static final DataTypeBoolean singleInstance = new DataTypeBoolean();
    public static final AttributeValue<Boolean> AV_TRUE = new StdAttributeValue<Boolean>(XACML.ID_DATATYPE_BOOLEAN, Boolean.TRUE);
    public static final AttributeValue<Boolean> AV_FALSE = new StdAttributeValue<Boolean>(XACML.ID_DATATYPE_BOOLEAN, Boolean.FALSE);

    private DataTypeBoolean() {
        super(XACML.ID_DATATYPE_BOOLEAN, Boolean.class);
    }

    public static DataTypeBoolean newInstance() {
        return singleInstance;
    }

    @Override
    public Boolean convert(Object source) throws DataTypeException {
        if (source == null || source instanceof Boolean) {
            return (Boolean)source;
        }
        if (source instanceof Integer) {
            int iValue = (Integer)source;
            if (iValue == 0) {
                return Boolean.FALSE;
            }
            if (iValue == 1) {
                return Boolean.TRUE;
            }
            throw new DataTypeException(this, "Cannot convert from integer " + iValue + " to boolean");
        }
        String stringValue = this.convertToString(source);
        if (stringValue == null) {
            return null;
        }
        if (stringValue.equals("0") || stringValue.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (stringValue.equals("1") || stringValue.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        throw new DataTypeException(this, "Cannot convert from \"" + source.getClass().getCanonicalName() + "\" with value \"" + stringValue + "\" to boolean");
    }
}

