/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import org.apache.openaz.xacml.api.SemanticString;
import org.apache.openaz.xacml.std.datatypes.ParseUtils;

public class ISO8601TimeZone
implements Comparable<ISO8601TimeZone>,
SemanticString {
    private static int MAX_TZOFFSET_MINUTES = 1440;
    private static int MAX_NORMALIZED_TZOFFSET_MINUTES = 720;
    private int tzOffsetMinutes;
    public static final ISO8601TimeZone TIMEZONE_GMT = new ISO8601TimeZone(0);

    public ISO8601TimeZone(int tzOffsetMinutesIn) {
        int absOffsetMinutes = Math.abs(tzOffsetMinutesIn);
        if (absOffsetMinutes > MAX_TZOFFSET_MINUTES) {
            throw new IllegalArgumentException("Invalid ISO8601 timezone offset " + tzOffsetMinutesIn);
        }
        this.tzOffsetMinutes = absOffsetMinutes <= MAX_NORMALIZED_TZOFFSET_MINUTES ? tzOffsetMinutesIn : (tzOffsetMinutesIn < 0 ? MAX_TZOFFSET_MINUTES - absOffsetMinutes : -(MAX_TZOFFSET_MINUTES - absOffsetMinutes));
    }

    public static ISO8601TimeZone fromString(String timezoneString) throws ParseException {
        int startPos = ParseUtils.nextNonWhite(timezoneString, 0);
        int offsetMinutes = 0;
        int signPart = 1;
        switch (timezoneString.charAt(startPos)) {
            case 'Z': {
                offsetMinutes = 0;
                ++startPos;
                break;
            }
            case '-': {
                signPart = -1;
            }
            case '+': {
                int minutePart;
                int hourPart = ParseUtils.getTwoDigitValue(timezoneString, ++startPos);
                if (hourPart < 0 || hourPart > 24) {
                    throw new ParseException("Invalid timezone", startPos);
                }
                if ((startPos += 2) >= timezoneString.length() || timezoneString.charAt(startPos) != ':') {
                    throw new ParseException("Invalid time string", startPos);
                }
                if ((minutePart = ParseUtils.getTwoDigitValue(timezoneString, ++startPos)) < 0 || minutePart >= 60) {
                    throw new ParseException("Invalid timezone", startPos);
                }
                startPos += 2;
                offsetMinutes = signPart * (hourPart * 60 + minutePart);
                break;
            }
            default: {
                throw new ParseException("Invalid timezone", startPos);
            }
        }
        return new ISO8601TimeZone(offsetMinutes);
    }

    public int getTzOffsetMinutes() {
        return this.tzOffsetMinutes;
    }

    public String getTimeZoneString() {
        if (this.tzOffsetMinutes == 0) {
            return "GMT";
        }
        int offsetAbs = Math.abs(this.tzOffsetMinutes);
        String sign = this.tzOffsetMinutes < 0 ? "-" : "+";
        int hours = offsetAbs / 60;
        int minutes = offsetAbs - 60 * hours;
        return "GMT" + sign + String.format("%02d", hours) + ":" + String.format("%02d", minutes);
    }

    @Override
    public String stringValue() {
        int offset = this.getTzOffsetMinutes();
        if (offset == 0) {
            return "Z";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (offset < 0) {
            stringBuilder.append('-');
        } else {
            stringBuilder.append('+');
        }
        int hourPart = offset / 60;
        int minutePart = offset - hourPart * 60;
        stringBuilder.append(String.format("%02d", hourPart));
        stringBuilder.append(':');
        stringBuilder.append(String.format("%02d", minutePart));
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.getTzOffsetMinutes();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ISO8601TimeZone)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.getTzOffsetMinutes() == ((ISO8601TimeZone)obj).getTzOffsetMinutes();
    }

    public String toString() {
        return "{tzOffsetMinutes=" + this.getTzOffsetMinutes() + "}";
    }

    @Override
    public int compareTo(ISO8601TimeZone o) {
        return this.getTzOffsetMinutes() - o.getTzOffsetMinutes();
    }
}

