/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Advice;
import org.apache.openaz.xacml.std.StdAdvice;
import org.apache.openaz.xacml.std.StdMutableAdvice;
import org.apache.openaz.xacml.std.dom.DOMAttributeAssignment;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMAdvice {
    private static Log logger = LogFactory.getLog(StdMutableAdvice.class);

    protected DOMAdvice() {
    }

    public static Advice newInstance(Node nodeAdvice) throws DOMStructureException {
        int numChildren;
        Element elementAdvice = DOMUtil.getElement(nodeAdvice);
        StdMutableAdvice mutableAdvice = new StdMutableAdvice();
        boolean bLenient = DOMProperties.isLenient();
        mutableAdvice.setId(DOMUtil.getIdentifierAttribute((Node)elementAdvice, "AdviceId", !bLenient));
        NodeList children = elementAdvice.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("AttributeAssignment".equals(child.getLocalName())) {
                        mutableAdvice.addAttributeAssignment(DOMAttributeAssignment.newInstance(child));
                        continue;
                    }
                    if (bLenient) continue;
                    throw DOMUtil.newUnexpectedElementException(child, nodeAdvice);
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeAdvice);
            }
        }
        return new StdAdvice(mutableAdvice);
    }

    public static boolean repair(Node nodeAdvice) throws DOMStructureException {
        int numChildren;
        Element elementAdvice = DOMUtil.getElement(nodeAdvice);
        boolean result = false;
        result = result || DOMUtil.repairIdentifierAttribute(elementAdvice, "AdviceId", logger);
        NodeList children = elementAdvice.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("AttributeAssignment".equals(child.getLocalName())) {
                        result = DOMAttributeAssignment.repair(child) || result;
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementAdvice.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementAdvice.removeChild(child);
                result = true;
            }
        }
        return result;
    }

    public static List<Advice> newList(Node nodeAssociatedAdvice) throws DOMStructureException {
        int numChildren;
        Element elementAssociatedAdvice = DOMUtil.getElement(nodeAssociatedAdvice);
        ArrayList<Advice> listAdvice = new ArrayList<Advice>();
        boolean bLenient = DOMProperties.isLenient();
        NodeList children = elementAssociatedAdvice.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("Advice".equals(child.getLocalName())) {
                        listAdvice.add(DOMAdvice.newInstance(child));
                        continue;
                    }
                    if (bLenient) continue;
                    throw DOMUtil.newUnexpectedElementException(child, nodeAssociatedAdvice);
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeAssociatedAdvice);
            }
        }
        return listAdvice;
    }

    public static boolean repairList(Node nodeAssociatedAdvice) throws DOMStructureException {
        int numChildren;
        Element elementAssociatedAdvice = DOMUtil.getElement(nodeAssociatedAdvice);
        boolean result = false;
        NodeList children = elementAssociatedAdvice.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("Advice".equals(child.getLocalName())) {
                        result = DOMAdvice.repair(child) || result;
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementAssociatedAdvice.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementAssociatedAdvice.removeChild(child);
                result = true;
            }
        }
        return result;
    }
}

