/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.datatypes.DataTypeBase;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.apache.openaz.xacml.util.FactoryException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMAttributeValue<T>
extends StdAttributeValue<T> {
    private static Log logger = LogFactory.getLog(DOMAttributeValue.class);

    protected DOMAttributeValue(Identifier dataTypeIdIn, T valueIn) {
        super(dataTypeIdIn, valueIn);
    }

    public static AttributeValue<?> newInstance(Node nodeAttributeValue, Identifier category) throws DOMStructureException {
        DOMAttributeValue.repair(nodeAttributeValue);
        Element elementAttributeValue = DOMUtil.getElement(nodeAttributeValue);
        boolean bLenient = DOMProperties.isLenient();
        Identifier identifierDataTypeId = DOMUtil.getIdentifierAttribute((Node)elementAttributeValue, "DataType", !bLenient);
        DataTypeFactory dataTypeFactory = null;
        try {
            dataTypeFactory = DataTypeFactory.newInstance();
            if (dataTypeFactory == null) {
                throw new DOMStructureException("Failed to get DataTypeFactory");
            }
        }
        catch (FactoryException ex) {
            throw new DOMStructureException("FactoryException loading DataTypeFactory: " + ex.getMessage(), (Throwable)ex);
        }
        DataType<?> dataTypeExtended = dataTypeFactory.getDataType(identifierDataTypeId);
        if (dataTypeExtended == null) {
            throw new DOMStructureException((Node)elementAttributeValue, "Unknown dataTypeId \"" + identifierDataTypeId.toString() + "\" in \"" + DOMUtil.getNodeLabel(nodeAttributeValue));
        }
        AttributeValue<?> attributeValue = null;
        try {
            attributeValue = dataTypeExtended.createAttributeValue(elementAttributeValue);
            if (!bLenient && attributeValue != null && attributeValue.getXPathCategory() != null && category != null && !category.equals(attributeValue.getXPathCategory())) {
                throw new DOMStructureException((Node)elementAttributeValue, "AttributeValue XPathCategory does not match " + category.stringValue());
            }
        }
        catch (DataTypeException ex) {
            throw new DOMStructureException("Unable to convert \"" + DOMUtil.getNodeLabel(nodeAttributeValue) + "\" to \"" + identifierDataTypeId.toString() + "\"");
        }
        return attributeValue;
    }

    public static boolean repair(Node nodeAttributeValue) throws DOMStructureException {
        Element elementAttributeValue = DOMUtil.getElement(nodeAttributeValue);
        boolean result = false;
        result = DOMUtil.repairIdentifierAttribute(elementAttributeValue, "DataType", logger) || result;
        Identifier identifierDataTypeId = DOMUtil.getIdentifierAttribute(elementAttributeValue, "DataType");
        try {
            DataTypeFactory dataTypeFactory = DataTypeFactory.newInstance();
            DataTypeBase dataTypeExtended = dataTypeFactory.getDataType(identifierDataTypeId);
            if (dataTypeExtended == null) {
                dataTypeExtended = identifierDataTypeId.equals(XACML.ID_DATATYPE_WD_DAYTIMEDURATION) ? DataTypes.DT_DAYTIMEDURATION : (identifierDataTypeId.equals(XACML.ID_DATATYPE_WD_YEARMONTHDURATION) ? DataTypes.DT_YEARMONTHDURATION : DataTypes.DT_STRING);
                logger.warn((Object)("Changing unknown DataType " + identifierDataTypeId.stringValue() + " to " + dataTypeExtended.getId().stringValue()));
                elementAttributeValue.setAttribute("DataType", dataTypeExtended.getId().stringValue());
                result = true;
            }
            dataTypeExtended.createAttributeValue(nodeAttributeValue);
            if (result) {
                nodeAttributeValue.getAttributes().getNamedItem("DataType").setNodeValue(dataTypeExtended.getId().stringValue());
            }
        }
        catch (Exception ex) {
            throw new DOMStructureException("Unable to convert \"" + DOMUtil.getNodeLabel(nodeAttributeValue) + "\" to \"" + identifierDataTypeId.toString() + "\"");
        }
        return result;
    }
}

