/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.RequestDefaults;
import org.apache.openaz.xacml.std.StdRequestDefaults;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMRequestDefaults {
    private static final Log logger = LogFactory.getLog(DOMRequestDefaults.class);

    protected DOMRequestDefaults() {
    }

    public static RequestDefaults newInstance(Node nodeRequestDefaults) throws DOMStructureException {
        int numChildren;
        Element elementRequestDefaults = DOMUtil.getElement(nodeRequestDefaults);
        boolean bLenient = DOMProperties.isLenient();
        URI uriXPathVersion = null;
        NodeList children = elementRequestDefaults.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "XPathVersion".equals(child.getLocalName())) {
                    uriXPathVersion = DOMUtil.getURIContent(child);
                    continue;
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeRequestDefaults);
            }
        }
        return new StdRequestDefaults(uriXPathVersion);
    }

    public static boolean repair(Node nodeRequestDefaults) throws DOMStructureException {
        int numChildren;
        Element elementRequestDefaults = DOMUtil.getElement(nodeRequestDefaults);
        boolean result = false;
        NodeList children = elementRequestDefaults.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "XPathVersion".equals(child.getLocalName())) {
                    try {
                        DOMUtil.getURIContent(child);
                    }
                    catch (DOMStructureException ex) {
                        logger.warn((Object)("Deleting invalid XPathVersion " + child.getTextContent()));
                        elementRequestDefaults.removeChild(child);
                        result = true;
                    }
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementRequestDefaults.removeChild(child);
                result = true;
            }
        }
        return result;
    }
}

