/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Version;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdVersion;
import org.apache.openaz.xacml.std.StdVersionMatch;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil {
    private static String[] NAMESPACES = new String[]{"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "urn:oasis:names:tc:xacml:2.0:context:schema:os"};
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";

    protected DOMUtil() {
    }

    public static Node getDirectDocumentChild(Node node) throws DOMStructureException {
        Element nodeResult = null;
        try {
            DocumentBuilder documentBuilder = DOMUtil.getDocumentBuilder();
            Document documentRoot = documentBuilder.newDocument();
            Node nodeTopRoot = documentRoot.importNode(node, true);
            documentRoot.appendChild(nodeTopRoot);
            nodeResult = documentRoot.getDocumentElement();
        }
        catch (Exception ex) {
            throw new DOMStructureException("Exception generating Document root Node from Node: " + ex.getMessage(), (Throwable)ex);
        }
        return nodeResult;
    }

    public static Element getElement(Node node) throws DOMStructureException {
        if (node == null) {
            throw new DOMStructureException(node, (Throwable)new NullPointerException("Null Node"));
        }
        if (node.getNodeType() != 1) {
            throw new DOMStructureException(node, "Non-element Node");
        }
        return (Element)node;
    }

    public static boolean isElement(Node node) {
        return node != null && node.getNodeType() == 1;
    }

    public static boolean isInNamespace(Node node, String namespace) {
        return namespace.equals(node.getNamespaceURI());
    }

    public static boolean isNamespaceElement(Node node, String namespace) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != 1) {
            return false;
        }
        return namespace == null || namespace.equals(node.getNamespaceURI());
    }

    public static String getNodeLabel(Node node) {
        String namespaceURI = node.getNamespaceURI();
        return namespaceURI == null ? node.getLocalName() : namespaceURI + ":" + node.getLocalName();
    }

    public static DOMStructureException newUnexpectedElementException(Node node) {
        return new DOMStructureException(node, "Unexpected element \"" + DOMUtil.getNodeLabel(node) + "\"");
    }

    public static DOMStructureException newUnexpectedElementException(Node node, Node parent) {
        return new DOMStructureException(node, "Unexpected element \"" + DOMUtil.getNodeLabel(node) + "\" in \"" + DOMUtil.getNodeLabel(parent) + "\"");
    }

    public static Element getFirstChildElement(Node rootNode) {
        Node node;
        if (rootNode == null) {
            return null;
        }
        for (node = rootNode.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        if (node != null && node.getNodeType() == 1) {
            return (Element)node;
        }
        return null;
    }

    protected static DOMStructureException newMissingAttributeException(Node node, String attributeName) {
        return new DOMStructureException("Missing attribute \"" + attributeName + "\" in \"" + DOMUtil.getNodeLabel(node) + "\"");
    }

    protected static DOMStructureException newMissingAttributeException(Node node, String namespace, String attributeName) {
        return new DOMStructureException("Missing attribute \"" + (namespace == null ? "" : namespace + ":") + attributeName + "\" in \"" + DOMUtil.getNodeLabel(node) + "\"");
    }

    protected static DOMStructureException newMissingContentException(Node node) {
        return new DOMStructureException("Missing content for \"" + DOMUtil.getNodeLabel(node) + "\"");
    }

    public static DOMStructureException newMissingElementException(Node node, String namespace, String elementName) {
        return new DOMStructureException("Missing element \"" + (namespace == null ? "" : namespace + ":") + elementName + "\" in \"" + DOMUtil.getNodeLabel(node));
    }

    public static Node getAttribute(Node node, String[] nameSpace, String localName, boolean bRequired) throws DOMStructureException {
        Node nodeResult = null;
        for (String namespace : nameSpace) {
            nodeResult = node.getAttributes().getNamedItemNS(namespace, localName);
            if (nodeResult == null) continue;
            return nodeResult;
        }
        if (bRequired) {
            throw DOMUtil.newMissingAttributeException(node, localName);
        }
        return null;
    }

    public static Node getAttribute(Node node, String[] nameSpace, String localName) {
        Node nodeResult = null;
        for (String namespace : nameSpace) {
            nodeResult = node.getAttributes().getNamedItemNS(namespace, localName);
            if (nodeResult == null) continue;
            return nodeResult;
        }
        return nodeResult;
    }

    public static Node getAttribute(Node node, String nameSpace, String localName, boolean bRequired) throws DOMStructureException {
        Node nodeAttribute = node.getAttributes().getNamedItemNS(nameSpace, localName);
        if (bRequired && nodeAttribute == null) {
            throw DOMUtil.newMissingAttributeException(node, nameSpace, localName);
        }
        return nodeAttribute;
    }

    public static Node getAttribute(Node node, String nameSpace, String localName) {
        return node.getAttributes().getNamedItemNS(nameSpace, localName);
    }

    public static Node getAttribute(Node node, String localName, boolean bRequired) throws DOMStructureException {
        Node nodeAttribute = node.getAttributes().getNamedItem(localName);
        if (bRequired && nodeAttribute == null) {
            throw DOMUtil.newMissingAttributeException(node, localName);
        }
        return nodeAttribute;
    }

    public static Node getAttribute(Node node, String localName) {
        return node.getAttributes().getNamedItem(localName);
    }

    public static String getStringAttribute(Node node, String[] nameSpaces, String localName, boolean bRequired) throws DOMStructureException {
        Node nodeAttribute = DOMUtil.getAttribute(node, nameSpaces, localName, bRequired);
        return nodeAttribute == null ? null : nodeAttribute.getNodeValue();
    }

    public static String getStringAttribute(Node node, String[] nameSpaces, String localName) {
        Node nodeAttribute = DOMUtil.getAttribute(node, nameSpaces, localName);
        return nodeAttribute == null ? null : nodeAttribute.getNodeValue();
    }

    public static String getStringAttribute(Node node, String nameSpace, String localName, boolean bRequired) throws DOMStructureException {
        Node nodeAttribute = DOMUtil.getAttribute(node, nameSpace, localName, bRequired);
        return nodeAttribute == null ? null : nodeAttribute.getNodeValue();
    }

    public static String getStringAttribute(Node node, String nameSpace, String localName) {
        Node nodeAttribute = DOMUtil.getAttribute(node, nameSpace, localName);
        return nodeAttribute == null ? null : nodeAttribute.getNodeValue();
    }

    public static String getStringAttribute(Node node, String localName, boolean bRequired) throws DOMStructureException {
        Node nodeAttribute = DOMUtil.getAttribute(node, localName, bRequired);
        return nodeAttribute == null ? null : nodeAttribute.getNodeValue();
    }

    public static String getStringAttribute(Node node, String localName) {
        Node nodeAttribute = DOMUtil.getAttribute(node, localName);
        return nodeAttribute == null ? null : nodeAttribute.getNodeValue();
    }

    public static String getXmlId(Node node) {
        return DOMUtil.getStringAttribute(node, XML_NAMESPACE, "id");
    }

    public static String getXmlId(Node node, boolean bRequired) throws DOMStructureException {
        return DOMUtil.getStringAttribute(node, XML_NAMESPACE, "id", bRequired);
    }

    private static Identifier getIdentifierFromString(Node node, String stringAttribute) throws DOMStructureException {
        if (stringAttribute == null) {
            return null;
        }
        IdentifierImpl identifierResult = null;
        try {
            identifierResult = new IdentifierImpl(stringAttribute);
        }
        catch (IllegalArgumentException ex) {
            throw new DOMStructureException(node, "Invalid Identifier \"" + stringAttribute + "\" in \"" + DOMUtil.getNodeLabel(node) + "\"", ex);
        }
        return identifierResult;
    }

    public static Identifier getIdentifierAttribute(Node node, String[] nameSpaces, String localName, boolean bRequired) throws DOMStructureException {
        return DOMUtil.getIdentifierFromString(node, DOMUtil.getStringAttribute(node, nameSpaces, localName, bRequired));
    }

    public static Identifier getIdentifierAttribute(Node node, String[] nameSpaces, String localName) throws DOMStructureException {
        return DOMUtil.getIdentifierFromString(node, DOMUtil.getStringAttribute(node, nameSpaces, localName));
    }

    public static Identifier getIdentifierAttribute(Node node, String nameSpace, String localName, boolean bRequired) throws DOMStructureException {
        return DOMUtil.getIdentifierFromString(node, DOMUtil.getStringAttribute(node, nameSpace, localName, bRequired));
    }

    public static Identifier getIdentifierAttribute(Node node, String nameSpace, String localName) throws DOMStructureException {
        return DOMUtil.getIdentifierFromString(node, DOMUtil.getStringAttribute(node, nameSpace, localName));
    }

    public static Identifier getIdentifierAttribute(Node node, String localName, boolean bRequired) throws DOMStructureException {
        return DOMUtil.getIdentifierFromString(node, DOMUtil.getStringAttribute(node, localName, bRequired));
    }

    public static Identifier getIdentifierAttribute(Node node, String localName) throws DOMStructureException {
        return DOMUtil.getIdentifierFromString(node, DOMUtil.getStringAttribute(node, localName));
    }

    public static Identifier getIdentifierContent(Node node, boolean bRequired) throws DOMStructureException {
        Identifier identifier = DOMUtil.getIdentifierFromString(node, node.getTextContent());
        if (bRequired && identifier == null) {
            throw DOMUtil.newMissingContentException(node);
        }
        return identifier;
    }

    public static Identifier getIdentifierContent(Node node) throws DOMStructureException {
        return DOMUtil.getIdentifierFromString(node, node.getTextContent());
    }

    private static Integer getIntegerFromString(Node node, String stringValue) throws DOMStructureException {
        if (stringValue == null) {
            return null;
        }
        Integer iresult = null;
        try {
            iresult = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException ex) {
            throw new DOMStructureException(node, "Invalid Integer \"" + stringValue + "\" in \"" + DOMUtil.getNodeLabel(node) + "\"", ex);
        }
        return iresult;
    }

    public static Integer getIntegerAttribute(Node node, String[] nameSpaces, String localName, boolean bRequired) throws DOMStructureException {
        return DOMUtil.getIntegerFromString(node, DOMUtil.getStringAttribute(node, nameSpaces, localName, bRequired));
    }

    public static Integer getIntegerAttribute(Node node, String[] nameSpaces, String localName) throws DOMStructureException {
        return DOMUtil.getIntegerFromString(node, DOMUtil.getStringAttribute(node, nameSpaces, localName));
    }

    public static Integer getIntegerAttribute(Node node, String nameSpace, String localName, boolean bRequired) throws DOMStructureException {
        return DOMUtil.getIntegerFromString(node, DOMUtil.getStringAttribute(node, nameSpace, localName, bRequired));
    }

    public static Integer getIntegerAttribute(Node node, String nameSpace, String localName) throws DOMStructureException {
        return DOMUtil.getIntegerFromString(node, DOMUtil.getStringAttribute(node, nameSpace, localName));
    }

    public static Integer getIntegerAttribute(Node node, String localName, boolean bRequired) throws DOMStructureException {
        return DOMUtil.getIntegerFromString(node, DOMUtil.getStringAttribute(node, localName, bRequired));
    }

    public static Integer getIntegerAttribute(Node node, String localName) throws DOMStructureException {
        return DOMUtil.getIntegerFromString(node, DOMUtil.getStringAttribute(node, localName));
    }

    private static Version getVersionFromString(Node node, String stringValue) throws DOMStructureException {
        StdVersion version = null;
        try {
            version = StdVersion.newInstance(stringValue);
        }
        catch (ParseException ex) {
            throw new DOMStructureException(node, "Invalid Version \"" + stringValue + "\" in \"" + DOMUtil.getNodeLabel(node) + "\"", ex);
        }
        return version;
    }

    public static Version getVersionAttribute(Node node, String[] nameSpaces, String localName, boolean bRequired) throws DOMStructureException {
        return DOMUtil.getVersionFromString(node, DOMUtil.getStringAttribute(node, nameSpaces, localName, bRequired));
    }

    public static Version getVersionAttribute(Node node, String[] nameSpaces, String localName) throws DOMStructureException {
        return DOMUtil.getVersionFromString(node, DOMUtil.getStringAttribute(node, nameSpaces, localName));
    }

    public static Version getVersionAttribute(Node node, String nameSpace, String localName, boolean bRequired) throws DOMStructureException {
        return DOMUtil.getVersionFromString(node, DOMUtil.getStringAttribute(node, nameSpace, localName, bRequired));
    }

    public static Version getVersionAttribute(Node node, String nameSpace, String localName) throws DOMStructureException {
        return DOMUtil.getVersionFromString(node, DOMUtil.getStringAttribute(node, nameSpace, localName));
    }

    public static Version getVersionAttribute(Node node, String localName, boolean bRequired) throws DOMStructureException {
        return DOMUtil.getVersionFromString(node, DOMUtil.getStringAttribute(node, localName, bRequired));
    }

    public static Version getVersionAttribute(Node node, String localName) throws DOMStructureException {
        return DOMUtil.getVersionFromString(node, DOMUtil.getStringAttribute(node, localName));
    }

    private static URI getURIFromString(Node node, String stringAttribute) throws DOMStructureException {
        if (stringAttribute == null) {
            return null;
        }
        URI uriResult = null;
        try {
            uriResult = new URI(stringAttribute);
        }
        catch (URISyntaxException ex) {
            throw new DOMStructureException(node, "Illegal URI value \"" + stringAttribute + "\" in \"" + DOMUtil.getNodeLabel(node) + "\"", ex);
        }
        return uriResult;
    }

    public static URI getURIContent(Node node, boolean bRequired) throws DOMStructureException {
        URI uri = DOMUtil.getURIFromString(node, node.getTextContent());
        if (bRequired && uri == null) {
            throw DOMUtil.newMissingContentException(node);
        }
        return uri;
    }

    public static URI getURIContent(Node node) throws DOMStructureException {
        return DOMUtil.getURIFromString(node, node.getTextContent());
    }

    protected static Boolean toBoolean(Node node, String stringAttribute) throws DOMStructureException {
        if (stringAttribute == null) {
            return null;
        }
        if (stringAttribute.equals("0") || stringAttribute.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (stringAttribute.equals("1") || stringAttribute.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        throw new DOMStructureException("Illegal Boolean value \"" + stringAttribute + "\" in \"" + DOMUtil.getNodeLabel(node) + "\"");
    }

    public static Boolean getBooleanAttribute(Node node, String[] nameSpaces, String localName, boolean bRequired) throws DOMStructureException {
        return DOMUtil.toBoolean(node, DOMUtil.getStringAttribute(node, nameSpaces, localName, bRequired));
    }

    public static Boolean getBooleanAttribute(Node node, String[] nameSpaces, String localName) throws DOMStructureException {
        return DOMUtil.toBoolean(node, DOMUtil.getStringAttribute(node, nameSpaces, localName));
    }

    public static Boolean getBooleanAttribute(Node node, String nameSpace, String localName, boolean bRequired) throws DOMStructureException {
        return DOMUtil.toBoolean(node, DOMUtil.getStringAttribute(node, nameSpace, localName, bRequired));
    }

    public static Boolean getBooleanAttribute(Node node, String nameSpace, String localName) throws DOMStructureException {
        return DOMUtil.toBoolean(node, DOMUtil.getStringAttribute(node, nameSpace, localName));
    }

    public static Boolean getBooleanAttribute(Node node, String localName, boolean bRequired) throws DOMStructureException {
        return DOMUtil.toBoolean(node, DOMUtil.getStringAttribute(node, localName, bRequired));
    }

    public static Boolean getBooleanAttribute(Node node, String localName) throws DOMStructureException {
        return DOMUtil.toBoolean(node, DOMUtil.getStringAttribute(node, localName));
    }

    public static NodeList getNodes(Element element, String[] nameSpaces, String localName) {
        NodeList nodeListResult = null;
        for (String namespace : nameSpaces) {
            nodeListResult = element.getElementsByTagNameNS(namespace, localName);
            if (nodeListResult == null || nodeListResult.getLength() <= 0) continue;
            return nodeListResult;
        }
        return null;
    }

    public static Node getNode(Element element, String[] nameSpaces, String localName) throws DOMStructureException {
        NodeList nodeList = DOMUtil.getNodes(element, nameSpaces, localName);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        if (nodeList.getLength() > 1) {
            throw new DOMStructureException((Node)element, "More than one \"" + localName + "\" element");
        }
        return nodeList.item(0);
    }

    public static NodeList getNodes(Element element, String nameSpace, String localName) {
        return element.getElementsByTagNameNS(nameSpace, localName);
    }

    public static Node getNode(Element element, String nameSpace, String localName) throws DOMStructureException {
        NodeList nodeList = DOMUtil.getNodes(element, nameSpace, localName);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        if (nodeList.getLength() > 1) {
            throw new DOMStructureException((Node)element, "More than one \"" + localName + "\" element");
        }
        return nodeList.item(0);
    }

    public static NodeList getNodes(Element element, String localName) {
        return DOMUtil.getNodes(element, NAMESPACES, localName);
    }

    public static Node getNode(Element element, String localName) throws DOMStructureException {
        NodeList nodeList = DOMUtil.getNodes(element, localName);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        if (nodeList.getLength() > 1) {
            throw new DOMStructureException((Node)element, "More than one \"" + localName + "\" element");
        }
        return nodeList.item(0);
    }

    public static String toString(Document document) throws DOMStructureException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", new Integer(4));
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StringWriter stringOut = new StringWriter();
            StreamResult result = new StreamResult(stringOut);
            transformer.transform(source, result);
            return stringOut.toString();
        }
        catch (Exception ex) {
            throw new DOMStructureException(document, "Exception converting Document to a String", ex);
        }
    }

    public static boolean repairIdentifierAttribute(Element element, String attributeName, Identifier identifierDefault, Log logger) throws DOMStructureException {
        Identifier identifier = DOMUtil.getIdentifierAttribute(element, attributeName);
        if (identifier == null) {
            identifier = identifierDefault != null ? identifierDefault : IdentifierImpl.gensym("urn:" + attributeName.toLowerCase());
            logger.warn((Object)("Setting missing " + attributeName + " attribute to " + identifier.stringValue()));
            element.setAttribute(attributeName, identifier.stringValue());
            return true;
        }
        return false;
    }

    public static boolean repairIdentifierAttribute(Element element, String attributeName, Log logger) throws DOMStructureException {
        return DOMUtil.repairIdentifierAttribute(element, attributeName, null, logger);
    }

    public static boolean repairIdentifierContent(Element element, Log logger) throws DOMStructureException {
        Identifier identifier = DOMUtil.getIdentifierContent(element);
        if (identifier == null) {
            identifier = IdentifierImpl.gensym();
            logger.warn((Object)("Setting missing content to " + identifier.stringValue()));
            element.setTextContent(identifier.stringValue());
            return true;
        }
        return false;
    }

    public static boolean repairBooleanAttribute(Element element, String attributeName, boolean bvalue, Log logger) throws DOMStructureException {
        Boolean booleanValue = null;
        try {
            booleanValue = DOMUtil.getBooleanAttribute(element, attributeName);
        }
        catch (DOMStructureException ex) {
            logger.warn((Object)("Setting invalid " + attributeName + " attribute to " + bvalue));
            element.setAttribute(attributeName, Boolean.toString(bvalue));
            return true;
        }
        if (booleanValue == null) {
            logger.warn((Object)("Setting missing " + attributeName + " attribute to " + bvalue));
            element.setAttribute(attributeName, Boolean.toString(bvalue));
            return true;
        }
        return false;
    }

    public static boolean repairVersionMatchAttribute(Element element, String attributeName, Log logger) {
        String versionString = DOMUtil.getStringAttribute(element, attributeName);
        if (versionString == null) {
            return false;
        }
        try {
            StdVersionMatch.newInstance(versionString);
        }
        catch (ParseException ex) {
            logger.warn((Object)("Deleting invalid " + attributeName + " string " + versionString), (Throwable)ex);
            element.removeAttribute(attributeName);
            return true;
        }
        return false;
    }

    public static boolean repairVersionAttribute(Element element, String attributeName, Log logger) {
        String versionString = DOMUtil.getStringAttribute(element, attributeName);
        if (versionString == null) {
            logger.warn((Object)("Adding default " + attributeName + " string 1.0"));
            element.setAttribute(attributeName, "1.0");
            return true;
        }
        try {
            StdVersion.newInstance(versionString);
        }
        catch (ParseException ex) {
            logger.warn((Object)("Setting invalid " + attributeName + " string " + versionString + " to 1.0"), (Throwable)ex);
            element.setAttribute(attributeName, "1.0");
            return true;
        }
        return false;
    }

    public static boolean repairStringAttribute(Element element, String attributeName, String defaultValue, Log logger) {
        String attributeValue = DOMUtil.getStringAttribute(element, attributeName);
        if (attributeValue == null) {
            if (defaultValue == null) {
                defaultValue = IdentifierImpl.gensym().stringValue();
            }
            logger.warn((Object)("Setting missing " + attributeName + " attribute to " + defaultValue));
            element.setAttribute(attributeName, defaultValue);
            return true;
        }
        return false;
    }

    public static DocumentBuilder getDocumentBuilder() throws DOMStructureException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        if (documentBuilderFactory == null) {
            throw new DOMStructureException("No XML DocumentBuilderFactory configured");
        }
        documentBuilderFactory.setNamespaceAware(true);
        try {
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception ex) {
            throw new DOMStructureException("Exception creating DocumentBuilder: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static Document loadDocument(File fileDocument) throws DOMStructureException {
        DocumentBuilder documentBuilder = DOMUtil.getDocumentBuilder();
        Document document = null;
        try {
            document = documentBuilder.parse(fileDocument);
            if (document == null) {
                throw new DOMStructureException("Null document returned");
            }
        }
        catch (Exception ex) {
            throw new DOMStructureException("Exception loading file \"" + fileDocument.getAbsolutePath() + "\": " + ex.getMessage(), (Throwable)ex);
        }
        return document;
    }

    public static Document loadDocument(InputStream inputStreamDocument) throws DOMStructureException {
        DocumentBuilder documentBuilder = DOMUtil.getDocumentBuilder();
        Document document = null;
        try {
            document = documentBuilder.parse(inputStreamDocument);
            if (document == null) {
                throw new DOMStructureException("Null document returned");
            }
        }
        catch (Exception ex) {
            throw new DOMStructureException("Exception loading file from stream: " + ex.getMessage(), (Throwable)ex);
        }
        return document;
    }
}

