/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.jaxp;

import java.math.BigInteger;
import java.net.URI;
import javax.security.auth.x500.X500Principal;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AttributeValueType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.api.XACML1;
import org.apache.openaz.xacml.api.XACML2;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.datatypes.Base64Binary;
import org.apache.openaz.xacml.std.datatypes.DataTypeAnyURI;
import org.apache.openaz.xacml.std.datatypes.DataTypeBase64Binary;
import org.apache.openaz.xacml.std.datatypes.DataTypeBoolean;
import org.apache.openaz.xacml.std.datatypes.DataTypeDNSName;
import org.apache.openaz.xacml.std.datatypes.DataTypeDate;
import org.apache.openaz.xacml.std.datatypes.DataTypeDateTime;
import org.apache.openaz.xacml.std.datatypes.DataTypeDayTimeDuration;
import org.apache.openaz.xacml.std.datatypes.DataTypeDouble;
import org.apache.openaz.xacml.std.datatypes.DataTypeHexBinary;
import org.apache.openaz.xacml.std.datatypes.DataTypeInteger;
import org.apache.openaz.xacml.std.datatypes.DataTypeIpAddress;
import org.apache.openaz.xacml.std.datatypes.DataTypeRFC822Name;
import org.apache.openaz.xacml.std.datatypes.DataTypeString;
import org.apache.openaz.xacml.std.datatypes.DataTypeTime;
import org.apache.openaz.xacml.std.datatypes.DataTypeX500Name;
import org.apache.openaz.xacml.std.datatypes.DataTypeXPathExpression;
import org.apache.openaz.xacml.std.datatypes.DataTypeYearMonthDuration;
import org.apache.openaz.xacml.std.datatypes.HexBinary;
import org.apache.openaz.xacml.std.datatypes.IPAddress;
import org.apache.openaz.xacml.std.datatypes.ISO8601Date;
import org.apache.openaz.xacml.std.datatypes.ISO8601DateTime;
import org.apache.openaz.xacml.std.datatypes.ISO8601Time;
import org.apache.openaz.xacml.std.datatypes.RFC2396DomainName;
import org.apache.openaz.xacml.std.datatypes.RFC822Name;
import org.apache.openaz.xacml.std.datatypes.XPathDayTimeDuration;
import org.apache.openaz.xacml.std.datatypes.XPathExpressionWrapper;
import org.apache.openaz.xacml.std.datatypes.XPathYearMonthDuration;

public class JaxpAttributeValue<T>
extends StdAttributeValue<T> {
    private JaxpAttributeValue(Identifier dataTypeIdIn, T valueIn) {
        super(dataTypeIdIn, valueIn);
    }

    public static JaxpAttributeValue<?> newInstance(AttributeValueType attributeValueType) {
        if (attributeValueType == null) {
            throw new NullPointerException("Null AttributeValueType");
        }
        if (attributeValueType.getDataType() == null) {
            throw new IllegalArgumentException("Null dataType in AttributeValueType");
        }
        IdentifierImpl dataTypeId = new IdentifierImpl(attributeValueType.getDataType());
        String source = attributeValueType.getContent() == null || attributeValueType.getContent().size() == 0 ? "" : attributeValueType.getContent().get(0);
        try {
            if (dataTypeId.equals(XACML.ID_DATATYPE_ANYURI)) {
                return new JaxpAttributeValue<URI>(dataTypeId, DataTypeAnyURI.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML.ID_DATATYPE_BASE64BINARY)) {
                return new JaxpAttributeValue<Base64Binary>(dataTypeId, DataTypeBase64Binary.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML.ID_DATATYPE_BOOLEAN)) {
                return new JaxpAttributeValue<Boolean>(dataTypeId, DataTypeBoolean.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML.ID_DATATYPE_DATE)) {
                return new JaxpAttributeValue<ISO8601Date>(dataTypeId, DataTypeDate.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML.ID_DATATYPE_DATETIME)) {
                return new JaxpAttributeValue<ISO8601DateTime>(dataTypeId, DataTypeDateTime.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML.ID_DATATYPE_DAYTIMEDURATION)) {
                return new JaxpAttributeValue<XPathDayTimeDuration>(dataTypeId, DataTypeDayTimeDuration.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML2.ID_DATATYPE_DNSNAME)) {
                return new JaxpAttributeValue<RFC2396DomainName>(dataTypeId, DataTypeDNSName.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML.ID_DATATYPE_DOUBLE)) {
                return new JaxpAttributeValue<Double>(dataTypeId, DataTypeDouble.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML.ID_DATATYPE_HEXBINARY)) {
                return new JaxpAttributeValue<HexBinary>(dataTypeId, DataTypeHexBinary.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML.ID_DATATYPE_INTEGER)) {
                return new JaxpAttributeValue<BigInteger>(dataTypeId, DataTypeInteger.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML2.ID_DATATYPE_IPADDRESS)) {
                return new JaxpAttributeValue<IPAddress>(dataTypeId, DataTypeIpAddress.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML1.ID_DATATYPE_RFC822NAME)) {
                return new JaxpAttributeValue<RFC822Name>(dataTypeId, DataTypeRFC822Name.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML.ID_DATATYPE_STRING)) {
                return new JaxpAttributeValue<String>(dataTypeId, DataTypeString.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML.ID_DATATYPE_TIME)) {
                return new JaxpAttributeValue<ISO8601Time>(dataTypeId, DataTypeTime.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML1.ID_DATATYPE_X500NAME)) {
                return new JaxpAttributeValue<X500Principal>(dataTypeId, DataTypeX500Name.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML3.ID_DATATYPE_XPATHEXPRESSION)) {
                return new JaxpAttributeValue<XPathExpressionWrapper>(dataTypeId, DataTypeXPathExpression.newInstance().convert(source));
            }
            if (dataTypeId.equals(XACML.ID_DATATYPE_YEARMONTHDURATION)) {
                return new JaxpAttributeValue<XPathYearMonthDuration>(dataTypeId, DataTypeYearMonthDuration.newInstance().convert(source));
            }
            throw new IllegalArgumentException("Unknown dataType \"" + attributeValueType.getDataType() + "\"");
        }
        catch (DataTypeException ex) {
            throw new IllegalArgumentException("DataTypeException converting to dataType \"" + attributeValueType.getDataType() + "\"");
        }
    }
}

