/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pap;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.pap.PAPEngine;
import org.apache.openaz.xacml.api.pap.PAPException;
import org.apache.openaz.xacml.api.pap.PDP;
import org.apache.openaz.xacml.api.pap.PDPGroup;
import org.apache.openaz.xacml.api.pap.PDPPolicy;
import org.apache.openaz.xacml.api.pap.PDPStatus;
import org.apache.openaz.xacml.std.pap.StdPDP;
import org.apache.openaz.xacml.std.pap.StdPDPGroup;
import org.apache.openaz.xacml.std.pap.StdPDPItemSetChangeNotifier;
import org.apache.openaz.xacml.util.XACMLProperties;

public class StdEngine
extends StdPDPItemSetChangeNotifier
implements PAPEngine {
    private static Log logger = LogFactory.getLog(StdEngine.class);
    public static String PROP_PAP_REPO = "xacml.pap.pdps";
    public static String PROP_PAP_GROUPS = "xacml.pap.groups";
    public static String PROP_PAP_GROUPS_DEFAULT = "xacml.pap.groups.default";
    public static String PROP_PAP_GROUPS_DEFAULT_NAME = "default";
    protected final Path repository;
    protected Set<StdPDPGroup> groups;

    public StdEngine() throws PAPException, IOException {
        this.repository = Paths.get(XACMLProperties.getProperty(PROP_PAP_REPO), new String[0]);
        this.intialize();
    }

    public StdEngine(Properties properties) throws PAPException, IOException {
        this.repository = Paths.get(properties.getProperty(PROP_PAP_REPO), new String[0]);
        this.intialize();
    }

    public StdEngine(Path repository) throws PAPException, IOException {
        this.repository = repository;
        this.intialize();
    }

    private void intialize() throws PAPException, IOException {
        if (this.repository == null) {
            throw new PAPException("No repository specified.");
        }
        if (Files.notExists(this.repository, new LinkOption[0])) {
            Files.createDirectory(this.repository, new FileAttribute[0]);
        }
        if (!Files.isDirectory(this.repository, new LinkOption[0])) {
            throw new PAPException("Repository is NOT a directory: " + this.repository.toAbsolutePath());
        }
        if (!Files.isWritable(this.repository)) {
            throw new PAPException("Repository is NOT writable: " + this.repository.toAbsolutePath());
        }
        this.loadGroups();
    }

    private void loadGroups() throws PAPException {
        Properties properties = new Properties();
        Path file = Paths.get(this.repository.toString(), "xacml.properties");
        try {
            try (FileInputStream is = new FileInputStream(file.toFile());){
                properties.load(is);
            }
            this.groups = this.readProperties(this.repository, properties);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to load " + file.toAbsolutePath().toString()));
            this.groups = new HashSet<StdPDPGroup>();
        }
        PDPGroup defaultGroup = this.initializeDefaultGroup(file, properties);
        logger.info((Object)("Default group is: " + defaultGroup.getId() + "=" + defaultGroup.getName()));
    }

    private PDPGroup initializeDefaultGroup(Path file, Properties properties) throws PAPException {
        PDPGroup group = this.getDefaultGroup();
        if (group != null) {
            return group;
        }
        String defaultId = properties.getProperty(PROP_PAP_GROUPS_DEFAULT, PROP_PAP_GROUPS_DEFAULT_NAME);
        logger.warn((Object)("Default group does NOT exist, creating " + defaultId));
        Path defaultPath = Paths.get(this.repository.toString(), defaultId);
        try {
            if (Files.notExists(defaultPath, new LinkOption[0])) {
                Throwable throwable;
                OutputStream os;
                Files.createDirectory(defaultPath, new FileAttribute[0]);
                Properties props = new Properties();
                props.setProperty("xacml.referencedPolicies", "");
                props.setProperty("xacml.rootPolicies", "");
                Path policyPath = Paths.get(defaultPath.toAbsolutePath().toString(), "xacml.policy.properties");
                Files.createFile(policyPath, new FileAttribute[0]);
                try {
                    os = Files.newOutputStream(policyPath, new OpenOption[0]);
                    throwable = null;
                    try {
                        props.store(os, "");
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (os != null) {
                            if (throwable != null) {
                                try {
                                    os.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                os.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to write default policy properties", (Throwable)e);
                }
                props = new Properties();
                props.setProperty("xacml.pip.engines", "");
                Path pipPath = Paths.get(defaultPath.toAbsolutePath().toString(), "xacml.pip.properties");
                Files.createFile(pipPath, new FileAttribute[0]);
                try {
                    os = Files.newOutputStream(pipPath, new OpenOption[0]);
                    throwable = null;
                    try {
                        props.store(os, "");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (os != null) {
                            if (throwable != null) {
                                try {
                                    os.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                os.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to write default pip properties", (Throwable)e);
                }
            }
            StdPDPGroup newDefault = new StdPDPGroup(defaultId, true, "default", "The default group where new PDP's are put.", defaultPath);
            this.groups.add(newDefault);
            StdEngine.setGroupProperties(newDefault, properties);
            try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
                properties.store(os, "");
            }
            catch (IOException e) {
                logger.error((Object)"Failed to save properties with new default group information.", (Throwable)e);
            }
            return newDefault;
        }
        catch (IOException e) {
            logger.error((Object)("Failed to create default group: " + defaultId), (Throwable)e);
            throw new PAPException("Failed to create default group");
        }
    }

    @Override
    public PDPGroup getDefaultGroup() throws PAPException {
        for (PDPGroup pDPGroup : this.groups) {
            if (!pDPGroup.isDefaultGroup()) continue;
            return pDPGroup;
        }
        return null;
    }

    @Override
    public void SetDefaultGroup(PDPGroup group) throws PAPException {
        boolean changesMade = false;
        for (PDPGroup pDPGroup : this.groups) {
            if (pDPGroup.getId().equals(group.getId())) {
                if (pDPGroup.isDefaultGroup()) continue;
                if (pDPGroup instanceof StdPDPGroup) {
                    ((StdPDPGroup)pDPGroup).setDefault(true);
                    changesMade = true;
                    continue;
                }
                throw new IllegalArgumentException("Group in groups of unknown type '" + pDPGroup.getClass().getName() + "'");
            }
            if (!pDPGroup.isDefaultGroup()) continue;
            if (pDPGroup instanceof StdPDPGroup) {
                ((StdPDPGroup)pDPGroup).setDefault(false);
                changesMade = true;
                continue;
            }
            throw new IllegalArgumentException("Group in groups of unknown type '" + pDPGroup.getClass().getName() + "'");
        }
        if (changesMade) {
            this.doSave();
        }
    }

    @Override
    public Set<PDPGroup> getPDPGroups() throws PAPException {
        HashSet<PDPGroup> grps = new HashSet<PDPGroup>();
        for (PDPGroup pDPGroup : this.groups) {
            grps.add(pDPGroup);
        }
        return Collections.unmodifiableSet(grps);
    }

    @Override
    public PDPGroup getGroup(String id) throws PAPException {
        for (PDPGroup pDPGroup : this.groups) {
            if (!pDPGroup.getId().equals(id)) continue;
            return pDPGroup;
        }
        return null;
    }

    @Override
    public void newGroup(String name, String description) throws PAPException, NullPointerException {
        if (name == null) {
            throw new NullPointerException();
        }
        for (PDPGroup pDPGroup : this.groups) {
            if (!pDPGroup.getName().equals(name)) continue;
            throw new PAPException("Group with this name=" + name + " already exists.");
        }
        String id = this.createNewPDPGroupId(name);
        Path path = Paths.get(this.repository.toString(), id);
        if (Files.exists(path, new LinkOption[0])) {
            logger.warn((Object)("addGroup " + id + " directory exists" + path.toString()));
        } else {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error((Object)("Failed to create " + path));
                throw new PAPException("Failed to create " + id);
            }
        }
        Path policyProperties = Paths.get(path.toString(), "xacml.policy.properties");
        if (Files.exists(policyProperties, new LinkOption[0])) {
            logger.warn((Object)("addGroup " + id + " file exists: " + policyProperties.toString()));
        } else {
            Properties props = new Properties();
            props.setProperty("xacml.referencedPolicies", "");
            props.setProperty("xacml.rootPolicies", "");
            try {
                Files.createFile(policyProperties, new FileAttribute[0]);
                try (OutputStream os = Files.newOutputStream(policyProperties, new OpenOption[0]);){
                    props.store(os, "");
                }
            }
            catch (IOException e) {
                logger.error((Object)("Failed to create " + policyProperties));
                throw new PAPException("Failed to create " + id);
            }
        }
        Path pipProperties = Paths.get(path.toString(), "xacml.pip.properties");
        if (Files.exists(pipProperties, new LinkOption[0])) {
            logger.warn((Object)("addGroup " + id + " file exists: " + pipProperties.toString()));
        } else {
            try {
                Properties props = new Properties();
                props.setProperty("xacml.pip.engines", "");
                Files.createFile(pipProperties, new FileAttribute[0]);
                try (OutputStream os = Files.newOutputStream(pipProperties, new OpenOption[0]);){
                    props.store(os, "");
                }
            }
            catch (IOException e) {
                logger.error((Object)("Failed to create " + pipProperties));
                throw new PAPException("Failed to create " + id);
            }
        }
        StdPDPGroup newGroup = new StdPDPGroup(id, name, description, path);
        if (this.groups.add(newGroup)) {
            this.groupChanged(newGroup);
        }
    }

    private String createNewPDPGroupId(String name) {
        String id = name;
        id = id.replace(" ", "_sp_");
        id = id.replace("\t", "_tab_");
        id = id.replace("\\", "_bksl_");
        id = id.replace("/", "_sl_");
        id = id.replace(":", "_col_");
        id = id.replace("*", "_ast_");
        id = id.replace("?", "_q_");
        id = id.replace("\"", "_quo_");
        id = id.replace("<", "_lt_");
        id = id.replace(">", "_gt_");
        id = id.replace("|", "_bar_");
        id = id.replace("=", "_eq_");
        id = id.replace(",", "_com_");
        id = id.replace(";", "_scom_");
        return id;
    }

    @Override
    public void updateGroup(PDPGroup group) throws PAPException {
        if (group == null || group.getId() == null) {
            throw new PAPException("Group or id is null");
        }
        if (group.getName() == null || group.getName().trim().length() == 0) {
            throw new PAPException("New name for group cannot be null or blank");
        }
        StdPDPGroup existingGroup = (StdPDPGroup)this.getGroup(group.getId());
        if (existingGroup == null) {
            throw new PAPException("Update found no existing group with id '" + group.getId() + "'");
        }
        if (group.getName().equals(existingGroup.getName())) {
            try {
                ((StdPDPGroup)group).saveGroupConfiguration();
            }
            catch (IOException e) {
                throw new PAPException("Unable to save new configuration for '" + group.getName() + "': " + e.getMessage());
            }
            this.groups.remove(existingGroup);
            this.groups.add((StdPDPGroup)group);
        } else {
            String newId = this.createNewPDPGroupId(group.getName());
            for (PDPGroup pDPGroup : this.groups) {
                if (!pDPGroup.getId().equals(newId)) continue;
                throw new PAPException("Replacement name maps to ID '" + newId + "' which is already in use");
            }
            ((StdPDPGroup)group).setId(newId);
            Path oldPath = existingGroup.getDirectory();
            Path path = Paths.get(oldPath.getParent().toString(), newId);
            ((StdPDPGroup)group).setDirectory(path);
            try {
                boolean success = oldPath.toFile().renameTo(path.toFile());
                if (!success) {
                    throw new PAPException("Unable to rename directory; reason unknown");
                }
            }
            catch (Exception e) {
                logger.error((Object)("Move '" + oldPath + "' to '" + path + "': " + e.getMessage()), (Throwable)e);
                throw new PAPException("Unable to move directory from '" + oldPath + "' to '" + path + "': " + e.getMessage());
            }
            try {
                ((StdPDPGroup)group).saveGroupConfiguration();
            }
            catch (IOException e) {
                throw new PAPException("Unable to save new configuration for '" + group.getName() + "': " + e.getMessage());
            }
            this.groups.remove(existingGroup);
            this.groups.add((StdPDPGroup)group);
        }
        this.changed();
    }

    @Override
    public void removeGroup(PDPGroup group, PDPGroup newGroup) throws PAPException, NullPointerException {
        if (group == null) {
            throw new NullPointerException();
        }
        if (!this.groups.contains(group)) {
            logger.error((Object)"This group doesn't exist.");
            throw new PAPException("The group '" + group.getId() + "' does not exist");
        }
        if (group.isDefaultGroup()) {
            throw new PAPException("You cannot delete the default group.");
        }
        Set<PDP> pdps = group.getPdps();
        if (!pdps.isEmpty() && newGroup == null) {
            throw new NullPointerException("Group targeted for deletion has PDPs, you must provide a new group for them.");
        }
        if (!pdps.isEmpty()) {
            if (!(newGroup instanceof StdPDPGroup)) {
                throw new PAPException("Unexpected class for newGroup: " + newGroup.getClass().getCanonicalName());
            }
            ArrayList<PDP> pdpList = new ArrayList<PDP>();
            for (PDP pdp : pdps) {
                pdpList.add(pdp);
            }
            for (PDP pdp : pdpList) {
                this.movePDP(pdp, newGroup);
            }
        }
        String id = group.getId();
        Path groupPath = Paths.get(this.repository.toString(), id);
        if (!Files.exists(groupPath, new LinkOption[0])) {
            logger.warn((Object)("removeGroup " + id + " directory does not exist" + groupPath.toString()));
        } else {
            try {
                Files.walkFileTree(groupPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return super.visitFile(file, attrs);
                    }
                });
                Files.delete(groupPath);
            }
            catch (IOException e) {
                logger.error((Object)("Failed to delete " + groupPath + ": " + e));
                throw new PAPException("Failed to delete " + id);
            }
        }
        this.groups.remove(group);
        this.changed();
        this.doSave();
    }

    @Override
    public PDPGroup getPDPGroup(PDP pdp) throws PAPException {
        for (PDPGroup pDPGroup : this.groups) {
            if (!pDPGroup.getPdps().contains(pdp)) continue;
            return pDPGroup;
        }
        return null;
    }

    @Override
    public PDPGroup getPDPGroup(String pdpId) throws PAPException {
        for (PDPGroup pDPGroup : this.groups) {
            for (PDP pdp : pDPGroup.getPdps()) {
                if (!pdp.getId().equals(pdpId)) continue;
                return pDPGroup;
            }
        }
        return null;
    }

    @Override
    public PDP getPDP(String pdpId) throws PAPException {
        for (PDPGroup pDPGroup : this.groups) {
            for (PDP pdp : pDPGroup.getPdps()) {
                if (!pdp.getId().equals(pdpId)) continue;
                return pdp;
            }
        }
        return null;
    }

    @Override
    public void newPDP(String id, PDPGroup group, String name, String description) throws PAPException, NullPointerException {
        StdPDP pdp;
        if (group == null) {
            throw new PAPException("You must specify which group the PDP will belong to.");
        }
        if (!this.groups.contains(group)) {
            throw new PAPException("Unknown group, not in our list.");
        }
        for (PDP p : group.getPdps()) {
            if (!p.getId().equals(id)) continue;
            throw new PAPException("A PDP with this ID exists.");
        }
        if (group instanceof StdPDPGroup && ((StdPDPGroup)group).addPDP(pdp = new StdPDP(id, name, description))) {
            this.pdpChanged(pdp);
            return;
        }
    }

    @Override
    public void movePDP(PDP pdp, PDPGroup newGroup) throws PAPException {
        if (newGroup == null) {
            throw new NullPointerException("You must specify which group the PDP will belong to.");
        }
        PDPGroup currentGroup = this.getPDPGroup(pdp);
        if (currentGroup == null) {
            throw new PAPException("PDP must already belong to a group.");
        }
        if (currentGroup.equals(newGroup)) {
            logger.warn((Object)"Already in that group.");
            return;
        }
        if (currentGroup instanceof StdPDPGroup && newGroup instanceof StdPDPGroup) {
            if (((StdPDPGroup)currentGroup).removePDP(pdp)) {
                boolean result = ((StdPDPGroup)newGroup).addPDP(pdp);
                if (result) {
                    this.doSave();
                } else {
                    logger.error((Object)"Failed to add to new group, putting back into original group.");
                    if (!((StdPDPGroup)currentGroup).removePDP(pdp)) {
                        logger.error((Object)"Failed to put PDP back into original group.");
                    }
                }
            }
        } else {
            String message = "Unknown PDP group class: " + newGroup.getClass().getCanonicalName() + " and " + currentGroup.getClass().getCanonicalName();
            logger.warn((Object)message);
            throw new PAPException(message);
        }
    }

    @Override
    public void updatePDP(PDP pdp) throws PAPException {
        PDP currentPDP = this.getPDP(pdp.getId());
        if (currentPDP == null) {
            String message = "Unknown PDP id '" + pdp.getId() + "'";
            logger.warn((Object)message);
            throw new PAPException(message);
        }
        currentPDP.setDescription(pdp.getDescription());
        currentPDP.setName(pdp.getName());
        this.doSave();
    }

    @Override
    public void removePDP(PDP pdp) throws PAPException {
        PDPGroup group = this.getPDPGroup(pdp);
        if (group == null) {
            throw new NullPointerException();
        }
        if (group instanceof StdPDPGroup) {
            boolean result = ((StdPDPGroup)group).removePDP(pdp);
            if (result) {
                this.doSave();
            }
            return;
        }
        String message = "Unknown PDP group class: " + group.getClass().getCanonicalName();
        logger.warn((Object)message);
        throw new PAPException(message);
    }

    @Override
    public PDPStatus getStatus(PDP pdp) throws PAPException {
        return this.getPDP(pdp.getId()).getStatus();
    }

    @Override
    public void publishPolicy(String id, String name, boolean isRoot, InputStream policy, PDPGroup group) throws PAPException {
        if (group == null) {
            throw new NullPointerException();
        }
        if (group instanceof StdPDPGroup && this.groups.contains(group)) {
            ((StdPDPGroup)group).publishPolicy(id, name, isRoot, policy);
            return;
        }
        logger.warn((Object)("unknown PDP Group: " + group));
        throw new PAPException("Unknown PDP Group: " + group.getId());
    }

    @Override
    public void copyPolicy(PDPPolicy policy, PDPGroup group) throws PAPException {
    }

    @Override
    public void removePolicy(PDPPolicy policy, PDPGroup group) throws PAPException {
        if (group == null) {
            throw new NullPointerException();
        }
        if (group instanceof StdPDPGroup && this.groups.contains(group)) {
            ((StdPDPGroup)group).removePolicy(policy);
            return;
        }
        logger.warn((Object)("unknown PDP Group: " + group));
        throw new PAPException("Unknown PDP Group: " + group.getId());
    }

    private Set<StdPDPGroup> readProperties(Path repository, Properties properties) throws PAPException {
        HashSet<StdPDPGroup> groups = new HashSet<StdPDPGroup>();
        String groupList = properties.getProperty(PROP_PAP_GROUPS, "");
        if (groupList == null) {
            logger.warn((Object)("null group list " + PROP_PAP_GROUPS));
            groupList = "";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("group list: " + groupList));
        }
        for (String id : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)groupList)) {
            StdPDPGroup g = new StdPDPGroup(id.trim(), id.equals(properties.getProperty(PROP_PAP_GROUPS_DEFAULT, PROP_PAP_GROUPS_DEFAULT_NAME)), properties, Paths.get(repository.toString(), id));
            groups.add(g);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PDP Group List: " + ((Object)groups).toString()));
        }
        return groups;
    }

    private void saveConfiguration() throws PAPException, IOException {
        Properties properties = new Properties(){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        ArrayList<String> ids = new ArrayList<String>();
        for (PDPGroup pDPGroup : this.groups) {
            ids.add(pDPGroup.getId());
            properties.setProperty(pDPGroup.getId() + ".name", pDPGroup.getName() == null ? "" : pDPGroup.getName());
            properties.setProperty(pDPGroup.getId() + ".description", pDPGroup.getDescription() == null ? "" : pDPGroup.getDescription());
            ArrayList<String> pdps = new ArrayList<String>();
            for (PDP pdp : pDPGroup.getPdps()) {
                pdps.add(pdp.getId());
                properties.setProperty(pdp.getId() + ".name", pdp.getName() == null ? "" : pdp.getName());
                properties.setProperty(pdp.getId() + ".description", pdp.getDescription() == null ? "" : pdp.getDescription());
            }
            String pdpList = "";
            if (pdps.size() == 1) {
                pdpList = (String)pdps.get(0);
            } else if (pdps.size() > 1) {
                pdpList = Joiner.on((char)',').skipNulls().join(pdps);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Group " + pDPGroup.getId() + " PDPS: " + pdpList));
            }
            properties.setProperty(pDPGroup.getId() + ".pdps", pdpList);
        }
        if (ids.isEmpty()) {
            throw new PAPException("Inconsistency - we have NO groups. We should have at least one.");
        }
        String groupList = "";
        if (ids.size() == 1) {
            groupList = (String)ids.get(0);
        } else if (ids.size() > 1) {
            groupList = Joiner.on((char)',').skipNulls().join(ids);
        }
        logger.info((Object)("New Group List: " + groupList));
        properties.setProperty(PROP_PAP_GROUPS, groupList);
        PDPGroup pDPGroup = this.getDefaultGroup();
        if (pDPGroup == null) {
            throw new PAPException("Invalid state - no default group.");
        }
        properties.setProperty(PROP_PAP_GROUPS_DEFAULT, pDPGroup.getId());
        Path file = Paths.get(this.repository.toString(), "xacml.properties");
        try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
            properties.store(os, "");
        }
    }

    public static void removeGroupProperties(String id, Properties properties) {
        for (Object key : properties.keySet()) {
            if (!key.toString().startsWith(id + ".")) continue;
            properties.remove(key);
        }
    }

    public static void setGroupProperties(PDPGroup group, Properties properties) {
        Iterable groups = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)properties.getProperty(PROP_PAP_GROUPS, ""));
        boolean inList = false;
        for (String g : groups) {
            if (!g.equals(group.getId())) continue;
            inList = true;
        }
        if (!inList) {
            HashSet grps = Sets.newHashSet((Iterable)groups);
            grps.add(group.getId());
            String newGroupList = "";
            if (grps.size() == 1) {
                newGroupList = (String)grps.iterator().next();
            } else if (grps.size() > 1) {
                newGroupList = Joiner.on((char)',').skipNulls().join((Iterable)grps);
            }
            logger.info((Object)("New Group List: " + newGroupList));
            properties.setProperty(PROP_PAP_GROUPS, newGroupList);
        }
        properties.setProperty(group.getId() + ".name", group.getName());
        properties.setProperty(group.getId() + ".description", group.getDescription());
        if (group.getPdps().size() > 0) {
            String pdpList = "";
            if (group.getPdps().size() == 1) {
                pdpList = group.getPdps().iterator().next().getId();
            } else if (group.getPdps().size() > 1) {
                HashSet<String> ids = new HashSet<String>();
                for (PDP pdp : group.getPdps()) {
                    ids.add(pdp.getId());
                }
                pdpList = Joiner.on((char)',').skipNulls().join(ids);
            }
            properties.setProperty(group.getId() + ".pdps", pdpList);
        } else {
            properties.setProperty(group.getId() + ".pdps", "");
        }
    }

    public void changed() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"changed");
        }
        this.doSave();
        this.fireChanged();
    }

    public void groupChanged(PDPGroup group) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("groupChanged: " + group));
        }
        this.doSave();
        this.firePDPGroupChanged(group);
    }

    public void pdpChanged(PDP pdp) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("pdpChanged: " + pdp));
        }
        this.doSave();
        this.firePDPChanged(pdp);
    }

    private void doSave() {
        try {
            this.saveConfiguration();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to save configuration", (Throwable)e);
        }
        catch (PAPException e) {
            logger.error((Object)"Failed to save configuration", (Throwable)e);
        }
    }
}

